/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.test;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.streams.psi.impl.JavaChainTransformerImpl;
import com.intellij.debugger.streams.psi.impl.JavaStreamChainBuilder;
import com.intellij.debugger.streams.psi.impl.PackageChainDetector;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.StreamChainBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightJavaCodeInsightTestCase;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class StreamChainBuilderTestCase
extends LightJavaCodeInsightTestCase {
    private final StreamChainBuilder myBuilder = new JavaStreamChainBuilder(new JavaChainTransformerImpl(), PackageChainDetector.Companion.forJavaStreams("java.util.stream"));

    @NotNull
    protected String getTestDataPath() {
        String string = new File(PluginPathManager.getPluginHomePath((String)"stream-debugger") + "/testData/" + this.getRelativeTestPath()).getAbsolutePath();
        if (string == null) {
            StreamChainBuilderTestCase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected PsiElement configureAndGetElementAtCaret() {
        String name = File.separator + this.getTestName(false) + this.getFileExtension();
        this.configureByFile(name);
        PsiFile file = this.getFile();
        int offset = this.getEditor().getCaretModel().getCurrentCaret().getOffset();
        PsiElement elementAtCaret = DebuggerUtilsEx.findElementAt((PsiFile)file, (int)offset);
        StreamChainBuilderTestCase.assertNotNull((Object)elementAtCaret);
        PsiElement psiElement = elementAtCaret;
        if (psiElement == null) {
            StreamChainBuilderTestCase.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @NotNull
    protected StreamChainBuilder getChainBuilder() {
        StreamChainBuilder streamChainBuilder = this.myBuilder;
        if (streamChainBuilder == null) {
            StreamChainBuilderTestCase.$$$reportNull$$$0(2);
        }
        return streamChainBuilder;
    }

    protected List<StreamChain> buildChains() {
        return (List)ApplicationManager.getApplication().runReadAction(() -> {
            PsiElement elementAtCaret = this.configureAndGetElementAtCaret();
            StreamChainBuilderTestCase.assertNotNull((Object)elementAtCaret);
            StreamChainBuilder builder = this.getChainBuilder();
            StreamChainBuilderTestCase.assertTrue((boolean)builder.isChainExists(elementAtCaret));
            return builder.build(elementAtCaret);
        });
    }

    protected String getFileExtension() {
        return ".java";
    }

    @NotNull
    protected abstract String getRelativeTestPath();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/debugger/streams/test/StreamChainBuilderTestCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "configureAndGetElementAtCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChainBuilder";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

