/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.lib.impl;

import com.intellij.debugger.streams.lib.HandlerFactory;
import com.intellij.debugger.streams.lib.IntermediateOperation;
import com.intellij.debugger.streams.lib.InterpreterFactory;
import com.intellij.debugger.streams.lib.LibrarySupport;
import com.intellij.debugger.streams.lib.Operation;
import com.intellij.debugger.streams.lib.ResolverFactory;
import com.intellij.debugger.streams.lib.TerminalOperation;
import com.intellij.debugger.streams.lib.impl.DefaultLibrarySupport;
import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.IntermediateCallHandler;
import com.intellij.debugger.streams.trace.TerminatorCallHandler;
import com.intellij.debugger.streams.trace.dsl.Dsl;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.wrapper.TerminatorStreamCall;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J!\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0015\"\u00020\u000bH\u0004\u00a2\u0006\u0002\u0010\u0016J!\u0010\u0017\u001a\u00020\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0015\"\u00020\rH\u0004\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/intellij/debugger/streams/lib/impl/LibrarySupportBase;", "Lcom/intellij/debugger/streams/lib/LibrarySupport;", "compatibleLibrary", "(Lcom/intellij/debugger/streams/lib/LibrarySupport;)V", "interpreterFactory", "Lcom/intellij/debugger/streams/lib/InterpreterFactory;", "getInterpreterFactory", "()Lcom/intellij/debugger/streams/lib/InterpreterFactory;", "mySupportedIntermediateOperations", "", "", "Lcom/intellij/debugger/streams/lib/IntermediateOperation;", "mySupportedTerminalOperations", "Lcom/intellij/debugger/streams/lib/TerminalOperation;", "resolverFactory", "Lcom/intellij/debugger/streams/lib/ResolverFactory;", "getResolverFactory", "()Lcom/intellij/debugger/streams/lib/ResolverFactory;", "addIntermediateOperationsSupport", "", "operations", "", "([Lcom/intellij/debugger/streams/lib/IntermediateOperation;)V", "addTerminationOperationsSupport", "([Lcom/intellij/debugger/streams/lib/TerminalOperation;)V", "createHandlerFactory", "Lcom/intellij/debugger/streams/lib/HandlerFactory;", "dsl", "Lcom/intellij/debugger/streams/trace/dsl/Dsl;", "findOperationByName", "Lcom/intellij/debugger/streams/lib/Operation;", "name", "Companion", "intellij.java.debugger.streams"})
public abstract class LibrarySupportBase
implements LibrarySupport {
    private final Map<String, IntermediateOperation> mySupportedIntermediateOperations;
    private final Map<String, TerminalOperation> mySupportedTerminalOperations;
    @NotNull
    private final InterpreterFactory interpreterFactory;
    @NotNull
    private final ResolverFactory resolverFactory;
    private final LibrarySupport compatibleLibrary;
    @NotNull
    private static final LibrarySupport EMPTY;
    public static final Companion Companion;

    @Override
    @NotNull
    public final HandlerFactory createHandlerFactory(@NotNull Dsl dsl) {
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        HandlerFactory compatibleLibraryFactory = this.compatibleLibrary.createHandlerFactory(dsl);
        return new HandlerFactory(this, dsl, compatibleLibraryFactory){
            final /* synthetic */ LibrarySupportBase this$0;
            final /* synthetic */ Dsl $dsl;
            final /* synthetic */ HandlerFactory $compatibleLibraryFactory;

            @NotNull
            public IntermediateCallHandler getForIntermediate(int number, @NotNull IntermediateStreamCall call2) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                IntermediateOperation operation = (IntermediateOperation)LibrarySupportBase.access$getMySupportedIntermediateOperations$p(this.this$0).get(call2.getName());
                Object object = operation;
                if (object == null || (object = object.getTraceHandler(number, call2, this.$dsl)) == null) {
                    object = this.$compatibleLibraryFactory.getForIntermediate(number, call2);
                }
                return object;
            }

            @NotNull
            public TerminatorCallHandler getForTermination(@NotNull TerminatorStreamCall call2, @NotNull String resultExpression) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)resultExpression, (String)"resultExpression");
                TerminalOperation terminalOperation = (TerminalOperation)LibrarySupportBase.access$getMySupportedTerminalOperations$p(this.this$0).get(call2.getName());
                Object object = terminalOperation;
                if (object == null || (object = object.getTraceHandler(call2, resultExpression, this.$dsl)) == null) {
                    object = this.$compatibleLibraryFactory.getForTermination(call2, resultExpression);
                }
                return object;
            }
            {
                this.this$0 = this$0;
                this.$dsl = $captured_local_variable$1;
                this.$compatibleLibraryFactory = $captured_local_variable$2;
            }
        };
    }

    @Override
    @NotNull
    public final InterpreterFactory getInterpreterFactory() {
        return this.interpreterFactory;
    }

    @Override
    @NotNull
    public final ResolverFactory getResolverFactory() {
        return this.resolverFactory;
    }

    protected final void addIntermediateOperationsSupport(IntermediateOperation ... operations) {
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        IntermediateOperation[] $this$forEach$iv = operations;
        boolean $i$f$forEach = false;
        IntermediateOperation[] intermediateOperationArray = $this$forEach$iv;
        int n = intermediateOperationArray.length;
        for (int i = 0; i < n; ++i) {
            IntermediateOperation element$iv;
            IntermediateOperation it = element$iv = intermediateOperationArray[i];
            boolean bl = false;
            this.mySupportedIntermediateOperations.put(it.getName(), it);
        }
    }

    protected final void addTerminationOperationsSupport(TerminalOperation ... operations) {
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        TerminalOperation[] $this$forEach$iv = operations;
        boolean $i$f$forEach = false;
        TerminalOperation[] terminalOperationArray = $this$forEach$iv;
        int n = terminalOperationArray.length;
        for (int i = 0; i < n; ++i) {
            TerminalOperation element$iv;
            TerminalOperation it = element$iv = terminalOperationArray[i];
            boolean bl = false;
            this.mySupportedTerminalOperations.put(it.getName(), it);
        }
    }

    private final Operation findOperationByName(String name) {
        IntermediateOperation intermediateOperation = this.mySupportedIntermediateOperations.get(name);
        return intermediateOperation != null ? (Operation)intermediateOperation : (Operation)this.mySupportedTerminalOperations.get(name);
    }

    public LibrarySupportBase(@NotNull LibrarySupport compatibleLibrary) {
        Intrinsics.checkNotNullParameter((Object)compatibleLibrary, (String)"compatibleLibrary");
        this.compatibleLibrary = compatibleLibrary;
        boolean bl = false;
        this.mySupportedIntermediateOperations = new LinkedHashMap();
        bl = false;
        this.mySupportedTerminalOperations = new LinkedHashMap();
        this.interpreterFactory = new InterpreterFactory(this){
            final /* synthetic */ LibrarySupportBase this$0;

            @NotNull
            public CallTraceInterpreter getInterpreter(@NotNull String callName) {
                Intrinsics.checkNotNullParameter((Object)callName, (String)"callName");
                Operation operation = LibrarySupportBase.access$findOperationByName(this.this$0, callName);
                Object object = operation;
                if (object == null || (object = object.getTraceInterpreter()) == null) {
                    object = LibrarySupportBase.access$getCompatibleLibrary$p(this.this$0).getInterpreterFactory().getInterpreter(callName);
                }
                return object;
            }
            {
                this.this$0 = this$0;
            }
        };
        this.resolverFactory = new ResolverFactory(this){
            final /* synthetic */ LibrarySupportBase this$0;

            @NotNull
            public ValuesOrderResolver getResolver(@NotNull String callName) {
                Intrinsics.checkNotNullParameter((Object)callName, (String)"callName");
                Operation operation = LibrarySupportBase.access$findOperationByName(this.this$0, callName);
                Object object = operation;
                if (object == null || (object = object.getValuesOrderResolver()) == null) {
                    object = LibrarySupportBase.access$getCompatibleLibrary$p(this.this$0).getResolverFactory().getResolver(callName);
                }
                return object;
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    public /* synthetic */ LibrarySupportBase(LibrarySupport librarySupport, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            librarySupport = EMPTY;
        }
        this(librarySupport);
    }

    public LibrarySupportBase() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        EMPTY = new DefaultLibrarySupport();
    }

    public static final /* synthetic */ Map access$getMySupportedIntermediateOperations$p(LibrarySupportBase $this) {
        return $this.mySupportedIntermediateOperations;
    }

    public static final /* synthetic */ Map access$getMySupportedTerminalOperations$p(LibrarySupportBase $this) {
        return $this.mySupportedTerminalOperations;
    }

    public static final /* synthetic */ Operation access$findOperationByName(LibrarySupportBase $this, String name) {
        return $this.findOperationByName(name);
    }

    public static final /* synthetic */ LibrarySupport access$getCompatibleLibrary$p(LibrarySupportBase $this) {
        return $this.compatibleLibrary;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/debugger/streams/lib/impl/LibrarySupportBase$Companion;", "", "()V", "EMPTY", "Lcom/intellij/debugger/streams/lib/LibrarySupport;", "getEMPTY", "()Lcom/intellij/debugger/streams/lib/LibrarySupport;", "intellij.java.debugger.streams"})
    public static final class Companion {
        @NotNull
        public final LibrarySupport getEMPTY() {
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

