/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.output.InlayScratchFileRenderer;
import org.jetbrains.kotlin.idea.scratch.output.InlayScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/output/InlayScratchOutputHandler;", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "toolWindowHandler", "(Lcom/intellij/openapi/fileEditor/TextEditor;Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;)V", "maxInsertOffset", "", "maxLineLength", "minSpaceCount", "clear", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "clearInlays", "editor", "createInlay", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "output", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutput;", "error", "message", "", "handle", "onFinish", "onStart", "printToToolWindow", "kotlin.jvm"})
public final class InlayScratchOutputHandler
implements ScratchOutputHandler {
    private final int maxLineLength;
    private final int maxInsertOffset;
    private final int minSpaceCount;
    private final TextEditor textEditor;
    private final ScratchOutputHandler toolWindowHandler;

    @Override
    public void onStart(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.toolWindowHandler.onStart(file);
    }

    @Override
    public void handle(@NotNull ScratchFile file, @NotNull ScratchExpression expression, @NotNull ScratchOutput output) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (StringsKt.isBlank((CharSequence)output.getText())) {
            return;
        }
        this.createInlay(file, expression, output);
        if (output.getType() == ScratchOutputType.ERROR) {
            this.toolWindowHandler.handle(file, expression, output);
        }
    }

    @Override
    public void error(@NotNull ScratchFile file, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.toolWindowHandler.error(file, message);
    }

    @Override
    public void onFinish(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.toolWindowHandler.onFinish(file);
    }

    @Override
    public void clear(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.clearInlays(this.textEditor);
        this.toolWindowHandler.clear(file);
    }

    private final void createInlay(ScratchFile file, ScratchExpression expression, ScratchOutput output) {
        TransactionGuard.submitTransaction((Disposable)((Disposable)file.getProject()), (Runnable)new Runnable(this, expression, file, output){
            final /* synthetic */ InlayScratchOutputHandler this$0;
            final /* synthetic */ ScratchExpression $expression;
            final /* synthetic */ ScratchFile $file;
            final /* synthetic */ ScratchOutput $output;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                Object v3;
                Function1<String, Unit> $fun$addInlay$1;
                void spaceCount;
                block6: {
                    Editor editor = InlayScratchOutputHandler.access$getTextEditor$p(this.this$0).getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"textEditor.editor");
                    Editor editor2 = editor;
                    int line = this.$expression.getLineStart();
                    int lineStartOffset = editor2.getDocument().getLineStartOffset(line);
                    int lineEndOffset = editor2.getDocument().getLineEndOffset(line);
                    int lineLength = lineEndOffset - lineStartOffset;
                    Ref.IntRef intRef = new Ref.IntRef();
                    intRef.element = InlayScratchOutputHandler.access$maxLineLength(this.this$0, this.$file) - lineLength + InlayScratchOutputHandler.access$getMinSpaceCount$p(this.this$0);
                    while (spaceCount.element + lineLength > InlayScratchOutputHandler.access$getMaxInsertOffset$p(this.this$0) && spaceCount.element > InlayScratchOutputHandler.access$getMinSpaceCount$p(this.this$0)) {
                        int n = spaceCount.element;
                        spaceCount.element = n + -1;
                    }
                    $fun$addInlay$1 = new Function1<String, Unit>(this, (Ref.IntRef)spaceCount, lineLength, editor2, lineEndOffset){
                        final /* synthetic */ createInlay.1 this$0;
                        final /* synthetic */ Ref.IntRef $spaceCount;
                        final /* synthetic */ int $lineLength;
                        final /* synthetic */ Editor $editor;
                        final /* synthetic */ int $lineEndOffset;

                        public final void invoke(@NotNull String text) {
                            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                            String textBeforeNewLine = StringUtil.containsLineBreak((CharSequence)text) ? StringsKt.substringBefore$default((String)text, (String)"\n", null, (int)2, null) + "..." : text;
                            Integer n = InlayScratchOutputHandler.access$getMaxLineLength$p(this.this$0.this$0) - this.$spaceCount.element - this.$lineLength;
                            boolean bl = false;
                            boolean bl2 = false;
                            int it = ((Number)n).intValue();
                            boolean bl3 = false;
                            Integer n2 = it > 5 ? n : null;
                            int maxInlayLength = n2 != null ? n2 : 5;
                            String string = StringUtil.shortenTextWithEllipsis((String)textBeforeNewLine, (int)maxInlayLength, (int)0);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.shortenTextWi\u2026wLine, maxInlayLength, 0)");
                            String shortText = string;
                            if (Intrinsics.areEqual((Object)shortText, (Object)text) ^ true) {
                                InlayScratchOutputHandler.access$printToToolWindow(this.this$0.this$0, this.this$0.$file, this.this$0.$expression, this.this$0.$output);
                            }
                            this.$editor.getInlayModel().addAfterLineEndElement(this.$lineEndOffset, false, (EditorCustomElementRenderer)new InlayScratchFileRenderer(StringsKt.repeat((CharSequence)" ", (int)this.$spaceCount.element) + shortText, this.this$0.$output.getType()));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$spaceCount = intRef;
                            this.$lineLength = n;
                            this.$editor = editor;
                            this.$lineEndOffset = n2;
                            super(1);
                        }
                    };
                    List list = editor2.getInlayModel().getAfterLineEndElementsInRange(lineEndOffset, lineEndOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"editor.inlayModel\n      \u2026EndOffset, lineEndOffset)");
                    Iterable $this$singleOrNull$iv = list;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (T element$iv : $this$singleOrNull$iv) {
                        Inlay it = (Inlay)element$iv;
                        boolean bl = false;
                        Inlay inlay = it;
                        Intrinsics.checkNotNullExpressionValue((Object)inlay, (String)"it");
                        if (!(inlay.getRenderer() instanceof InlayScratchFileRenderer)) continue;
                        if (found$iv) {
                            v3 = null;
                            break block6;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v3 = !found$iv ? null : single$iv;
                }
                Inlay existing = v3;
                if (existing != null) {
                    existing.dispose();
                    EditorCustomElementRenderer editorCustomElementRenderer = existing.getRenderer();
                    if (editorCustomElementRenderer == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.scratch.output.InlayScratchFileRenderer");
                    }
                    $fun$addInlay$1.invoke(StringsKt.drop((String)(((InlayScratchFileRenderer)editorCustomElementRenderer).getText() + "; " + this.$output.getText()), (int)spaceCount.element));
                } else {
                    $fun$addInlay$1.invoke(this.$output.getText());
                }
            }
            {
                this.this$0 = inlayScratchOutputHandler;
                this.$expression = scratchExpression;
                this.$file = scratchFile;
                this.$output = scratchOutput;
            }
        });
    }

    private final void printToToolWindow(ScratchFile file, ScratchExpression expression, ScratchOutput output) {
        if (output.getType() != ScratchOutputType.ERROR) {
            this.toolWindowHandler.handle(file, expression, output);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int maxLineLength(ScratchFile file) {
        Comparable comparable;
        void $this$flatMapTo$iv$iv;
        Editor editor = this.textEditor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"textEditor.editor");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"textEditor.editor.document");
        Document doc = document;
        Iterable $this$flatMap$iv = file.getExpressions();
        boolean $i$f$flatMap = false;
        Iterator iterator = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ScratchExpression it = (ScratchExpression)element$iv$iv;
            boolean bl = false;
            int n = it.getLineStart();
            Iterable list$iv$iv = (Iterable)new IntRange(n, it.getLineEnd());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable iterable = (List)destination$iv$iv;
        boolean bl = false;
        iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            int it = ((Number)iterator.next()).intValue();
            boolean bl2 = false;
            Comparable comparable2 = Integer.valueOf(doc.getLineEndOffset(it) - doc.getLineStartOffset(it));
            while (iterator.hasNext()) {
                int it2 = ((Number)iterator.next()).intValue();
                $i$a$-maxOfOrNull-InlayScratchOutputHandler$maxLineLength$2 = false;
                Comparable comparable3 = Integer.valueOf(doc.getLineEndOffset(it2) - doc.getLineStartOffset(it2));
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : 0;
    }

    private final void clearInlays(TextEditor editor) {
        TransactionGuard.submitTransaction((Disposable)((Disposable)editor), (Runnable)new Runnable(editor){
            final /* synthetic */ TextEditor $editor;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void $this$filterTo$iv$iv;
                Editor editor = this.$editor.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editor.editor");
                InlayModel inlayModel = editor.getInlayModel();
                Editor editor2 = this.$editor.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor.editor");
                Document document = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.editor.document");
                List list = inlayModel.getAfterLineEndElementsInRange(0, document.getTextLength());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"editor.editor.inlayModel\u2026itor.document.textLength)");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Inlay it = (Inlay)element$iv$iv;
                    boolean bl = false;
                    Inlay inlay = it;
                    Intrinsics.checkNotNullExpressionValue((Object)inlay, (String)"it");
                    if (!(inlay.getRenderer() instanceof InlayScratchFileRenderer)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Inlay it = (Inlay)element$iv;
                    boolean bl = false;
                    Disposer.dispose((Disposable)((Disposable)it));
                }
            }
            {
                this.$editor = textEditor;
            }
        });
    }

    public InlayScratchOutputHandler(@NotNull TextEditor textEditor, @NotNull ScratchOutputHandler toolWindowHandler) {
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        Intrinsics.checkNotNullParameter((Object)toolWindowHandler, (String)"toolWindowHandler");
        this.textEditor = textEditor;
        this.toolWindowHandler = toolWindowHandler;
        this.maxLineLength = 120;
        this.maxInsertOffset = 60;
        this.minSpaceCount = 4;
    }

    public static final /* synthetic */ TextEditor access$getTextEditor$p(InlayScratchOutputHandler $this) {
        return $this.textEditor;
    }

    public static final /* synthetic */ int access$maxLineLength(InlayScratchOutputHandler $this, ScratchFile file) {
        return $this.maxLineLength(file);
    }

    public static final /* synthetic */ int access$getMinSpaceCount$p(InlayScratchOutputHandler $this) {
        return $this.minSpaceCount;
    }

    public static final /* synthetic */ int access$getMaxInsertOffset$p(InlayScratchOutputHandler $this) {
        return $this.maxInsertOffset;
    }

    public static final /* synthetic */ int access$getMaxLineLength$p(InlayScratchOutputHandler $this) {
        return $this.maxLineLength;
    }

    public static final /* synthetic */ void access$printToToolWindow(InlayScratchOutputHandler $this, ScratchFile file, ScratchExpression expression, ScratchOutput output) {
        $this.printToToolWindow(file, expression, output);
    }
}

