/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentRevisionCache {
    private final Object myLock;
    private final SLRUMap<Key, SoftReference<byte[]>> myCache;
    private final SLRUMap<CurrentKey, VcsRevisionNumber> myCurrentRevisionsCache;
    private final Map<Key, byte[]> myConstantCache = new HashMap<Key, byte[]>();
    private long myCounter = 0L;

    public ContentRevisionCache() {
        this.myLock = new Object();
        this.myCache = new SLRUMap(100, 50);
        this.myCurrentRevisionsCache = new SLRUMap(200, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type, byte @Nullable [] bytes) {
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(0);
        }
        if (type == null) {
            ContentRevisionCache.$$$reportNull$$$0(1);
        }
        if (bytes == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myCache.put((Object)new Key(path2, number, vcsKey, type), (Object)new SoftReference((Object)bytes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCurrent() {
        Object object = this.myLock;
        synchronized (object) {
            ++this.myCounter;
            this.myCurrentRevisionsCache.clear();
        }
    }

    public void clearScope(List<? extends VcsDirtyScope> scopes) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myLock;
            synchronized (object) {
                ++this.myCounter;
                for (VcsDirtyScope scope : scopes) {
                    HashSet toRemove = new HashSet();
                    this.myCurrentRevisionsCache.iterateKeys(currentKey -> {
                        if (scope.belongsTo(currentKey.getPath())) {
                            toRemove.add(currentKey);
                        }
                    });
                    for (CurrentKey key : toRemove) {
                        this.myCurrentRevisionsCache.remove((Object)key);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCurrent(Set<String> paths) {
        HashSet<String> converted = new HashSet<String>();
        for (String path2 : paths) {
            converted.add(FilePathsHelper.convertPath(path2));
        }
        Object object = this.myLock;
        synchronized (object) {
            HashSet toRemove = new HashSet();
            this.myCurrentRevisionsCache.iterateKeys(currentKey -> {
                if (converted.contains(FilePathsHelper.convertPath(currentKey.getPath().getPath()))) {
                    toRemove.add(currentKey);
                }
            });
            for (CurrentKey key : toRemove) {
                this.myCurrentRevisionsCache.remove((Object)key);
            }
        }
    }

    @Nullable
    @Contract(value="!null, _, _ -> !null")
    public static String getAsString(byte @Nullable [] bytes, @NotNull FilePath file, @Nullable Charset charset) {
        if (file == null) {
            ContentRevisionCache.$$$reportNull$$$0(2);
        }
        if (bytes == null) {
            return null;
        }
        if (charset == null) {
            return ContentRevisionCache.bytesToString(file, bytes);
        }
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)charset);
    }

    @NotNull
    public static String getOrLoadAsString(@NotNull Project project, @NotNull FilePath file, VcsRevisionNumber number, @NotNull VcsKey key, @NotNull UniqueType type, @NotNull Throwable2Computable<byte[], ? extends VcsException, ? extends IOException> loader, @Nullable Charset charset) throws VcsException, IOException {
        if (project == null) {
            ContentRevisionCache.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ContentRevisionCache.$$$reportNull$$$0(4);
        }
        if (key == null) {
            ContentRevisionCache.$$$reportNull$$$0(5);
        }
        if (type == null) {
            ContentRevisionCache.$$$reportNull$$$0(6);
        }
        if (loader == null) {
            ContentRevisionCache.$$$reportNull$$$0(7);
        }
        byte[] bytes = ContentRevisionCache.getOrLoadAsBytes(project, file, number, key, type, loader);
        String string = ContentRevisionCache.getAsString(bytes, file, charset);
        if (string == null) {
            ContentRevisionCache.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getOrLoadAsString(Project project, FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type, Throwable2Computable<byte[], ? extends VcsException, ? extends IOException> loader) throws VcsException, IOException {
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(9);
        }
        if (type == null) {
            ContentRevisionCache.$$$reportNull$$$0(10);
        }
        return ContentRevisionCache.getOrLoadAsString(project, path2, number, vcsKey, type, loader, null);
    }

    @NotNull
    private static String bytesToString(FilePath path2, byte @NotNull [] bytes) {
        if (bytes == null) {
            ContentRevisionCache.$$$reportNull$$$0(11);
        }
        Charset charset = null;
        if (path2.getVirtualFile() != null) {
            charset = path2.getVirtualFile().getCharset();
        }
        if (charset != null) {
            int bomLength = CharsetToolkit.getBOMLength((byte[])bytes, (Charset)charset);
            CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(bytes, bomLength, bytes.length - bomLength));
            String string = charBuffer.toString();
            if (string == null) {
                ContentRevisionCache.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = CharsetToolkit.bytesToString((byte[])bytes, (Charset)EncodingRegistry.getInstance().getDefaultCharset());
        if (string == null) {
            ContentRevisionCache.$$$reportNull$$$0(13);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte @Nullable [] getBytes(FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type) {
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(14);
        }
        if (type == null) {
            ContentRevisionCache.$$$reportNull$$$0(15);
        }
        Object object = this.myLock;
        synchronized (object) {
            SoftReference reference = (SoftReference)this.myCache.get((Object)new Key(path2, number, vcsKey, type));
            return (byte[])SoftReference.dereference((Reference)reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putCurrent(FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, long counter) {
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(16);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCounter != counter) {
                return false;
            }
            ++this.myCounter;
            this.myCurrentRevisionsCache.put((Object)new CurrentKey(path2, vcsKey), (Object)number);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<VcsRevisionNumber, Long> getCurrent(FilePath path2, VcsKey vcsKey) {
        Object object = this.myLock;
        synchronized (object) {
            return new Pair((Object)((VcsRevisionNumber)this.myCurrentRevisionsCache.get((Object)new CurrentKey(path2, vcsKey))), (Object)this.myCounter);
        }
    }

    public static byte @NotNull [] getOrLoadAsBytes(Project project, FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type, Throwable2Computable<byte @NotNull [], ? extends VcsException, ? extends IOException> loader) throws VcsException, IOException {
        ContentRevisionCache cache;
        byte[] bytes;
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(17);
        }
        if (type == null) {
            ContentRevisionCache.$$$reportNull$$$0(18);
        }
        if ((bytes = (cache = ProjectLevelVcsManager.getInstance(project).getContentRevisionCache()).getBytes(path2, number, vcsKey, type)) != null) {
            if (bytes == null) {
                ContentRevisionCache.$$$reportNull$$$0(19);
            }
            return bytes;
        }
        bytes = cache.getFromConstantCache(path2, number, vcsKey, type);
        if (bytes != null) {
            if (bytes == null) {
                ContentRevisionCache.$$$reportNull$$$0(20);
            }
            return bytes;
        }
        ContentRevisionCache.checkLocalFileSize(path2);
        bytes = (byte[])loader.compute();
        cache.put(path2, number, vcsKey, type, bytes);
        if (bytes == null) {
            ContentRevisionCache.$$$reportNull$$$0(21);
        }
        return bytes;
    }

    private static void checkLocalFileSize(FilePath path2) throws VcsException {
        File ioFile = path2.getIOFile();
        if (ioFile.exists()) {
            ContentRevisionCache.checkContentsSize(ioFile.getPath(), ioFile.length());
        }
    }

    public static void checkContentsSize(String path2, long size) throws VcsException {
        if (size > (long)VcsUtil.getMaxVcsLoadedFileSize()) {
            throw new VcsException(VcsBundle.message("file.content.too.big.to.load.increase.property.suggestion", path2, StringUtil.formatFileSize((long)VcsUtil.getMaxVcsLoadedFileSize()), "idea.max.vcs.loaded.size.kb"));
        }
    }

    private static VcsRevisionNumber putIntoCurrentCache(ContentRevisionCache cache, FilePath path2, @NotNull VcsKey vcsKey, CurrentRevisionProvider loader) throws VcsException {
        Pair<VcsRevisionNumber, Long> currentRevision;
        VcsRevisionNumber loadedRevisionNumber;
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(22);
        }
        do {
            if (!(loadedRevisionNumber = loader.getCurrentRevision()).equals((currentRevision = cache.getCurrent(path2, vcsKey)).getFirst())) continue;
            return loadedRevisionNumber;
        } while (!cache.putCurrent(path2, loadedRevisionNumber, vcsKey, (Long)currentRevision.getSecond()));
        return loadedRevisionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIntoConstantCache(@NotNull FilePath path2, @NotNull VcsRevisionNumber revisionNumber, @NotNull VcsKey vcsKey, byte[] content) {
        if (path2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(23);
        }
        if (revisionNumber == null) {
            ContentRevisionCache.$$$reportNull$$$0(24);
        }
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(25);
        }
        Map<Key, byte[]> map = this.myConstantCache;
        synchronized (map) {
            this.myConstantCache.put(new Key(path2, revisionNumber, vcsKey, UniqueType.REPOSITORY_CONTENT), content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFromConstantCache(@NotNull FilePath path2, @NotNull VcsRevisionNumber revisionNumber, @NotNull VcsKey vcsKey, @NotNull UniqueType type) {
        if (path2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(26);
        }
        if (revisionNumber == null) {
            ContentRevisionCache.$$$reportNull$$$0(27);
        }
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(28);
        }
        if (type == null) {
            ContentRevisionCache.$$$reportNull$$$0(29);
        }
        Map<Key, byte[]> map = this.myConstantCache;
        synchronized (map) {
            return this.myConstantCache.get(new Key(path2, revisionNumber, vcsKey, type));
        }
    }

    public void clearConstantCache() {
        this.myConstantCache.clear();
    }

    public static Pair<VcsRevisionNumber, byte[]> getOrLoadCurrentAsBytes(Project project, FilePath path2, @NotNull VcsKey vcsKey, CurrentRevisionProvider loader) throws VcsException, IOException {
        VcsRevisionNumber currentRevision;
        Pair<VcsRevisionNumber, byte[]> loaded;
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(30);
        }
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance(project).getContentRevisionCache();
        do {
            byte[] cachedCurrent;
            if ((cachedCurrent = cache.getBytes(path2, currentRevision = ContentRevisionCache.putIntoCurrentCache(cache, path2, vcsKey, loader), vcsKey, UniqueType.REPOSITORY_CONTENT)) != null) {
                return Pair.create((Object)currentRevision, (Object)cachedCurrent);
            }
            ContentRevisionCache.checkLocalFileSize(path2);
        } while (!((VcsRevisionNumber)(loaded = loader.get()).getFirst()).equals(currentRevision));
        cache.put(path2, currentRevision, vcsKey, UniqueType.REPOSITORY_CONTENT, (byte[])loaded.getSecond());
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Object object = this.myLock;
        synchronized (object) {
            ++this.myCounter;
            this.myCurrentRevisionsCache.clear();
            this.myCache.clear();
            this.myConstantCache.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 15: 
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/ContentRevisionCache";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/ContentRevisionCache";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrLoadAsString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "bytesToString";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrLoadAsBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAsString";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrLoadAsString";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "bytesToString";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBytes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putCurrent";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOrLoadAsBytes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "putIntoCurrentCache";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "putIntoConstantCache";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFromConstantCache";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getOrLoadCurrentAsBytes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum UniqueType {
        REPOSITORY_CONTENT,
        REMOTE_CONTENT;

    }

    private static final class Key
    extends CurrentKey {
        private final VcsRevisionNumber myNumber;
        protected final UniqueType myType;

        private Key(FilePath path2, VcsRevisionNumber number, VcsKey vcsKey, UniqueType type) {
            super(path2, vcsKey);
            this.myNumber = number;
            this.myType = type;
        }

        public VcsRevisionNumber getNumber() {
            return this.myNumber;
        }

        public UniqueType getType() {
            return this.myType;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Key key = (Key)o;
            if (this.myNumber != null ? !this.myNumber.equals(key.myNumber) : key.myNumber != null) {
                return false;
            }
            if (!this.myPath.equals(key.myPath)) {
                return false;
            }
            if (this.myType != key.myType) {
                return false;
            }
            return this.myVcsKey.equals(key.myVcsKey);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myPath.hashCode();
            result = 31 * result + (this.myNumber != null ? this.myNumber.hashCode() : 0);
            result = 31 * result + this.myVcsKey.hashCode();
            result = 31 * result + this.myType.hashCode();
            return result;
        }
    }

    private static class CurrentKey {
        protected final FilePath myPath;
        protected final VcsKey myVcsKey;

        private CurrentKey(FilePath path2, VcsKey vcsKey) {
            this.myPath = path2;
            this.myVcsKey = vcsKey;
        }

        public FilePath getPath() {
            return this.myPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CurrentKey that = (CurrentKey)o;
            if (this.myPath != null ? !this.myPath.equals(that.myPath) : that.myPath != null) {
                return false;
            }
            return !(this.myVcsKey != null ? !this.myVcsKey.equals(that.myVcsKey) : that.myVcsKey != null);
        }

        public int hashCode() {
            int result = this.myPath != null ? this.myPath.hashCode() : 0;
            result = 31 * result + (this.myVcsKey != null ? this.myVcsKey.hashCode() : 0);
            return result;
        }
    }
}

