/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, ViewSettings settings) {
        Project project;
        if (parent == null) {
            GradleTreeStructureProvider.$$$reportNull$$$0(0);
        }
        if (children == null) {
            GradleTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if ((project = parent.getProject()) == null) {
            Collection<AbstractTreeNode<?>> collection = children;
            if (collection == null) {
                GradleTreeStructureProvider.$$$reportNull$$$0(2);
            }
            return collection;
        }
        if (parent instanceof ProjectViewProjectNode) {
            return GradleTreeStructureProvider.getProjectNodeChildren(project, children);
        }
        if (parent instanceof ProjectViewModuleGroupNode) {
            SmartList modifiedChildren = new SmartList();
            for (AbstractTreeNode<?> child : children) {
                if (child instanceof ProjectViewModuleNode) {
                    Module module = (Module)((ProjectViewModuleNode)child).getValue();
                    if (!GradleTreeStructureProvider.showUnderModuleGroup(module)) continue;
                    AbstractTreeNode<?> sourceSetNode = GradleTreeStructureProvider.getGradleModuleNode(project, (ProjectViewModuleNode)child, settings);
                    child = sourceSetNode != null ? sourceSetNode : child;
                } else if (child instanceof PsiDirectoryNode) {
                    AbstractTreeNode<?> sourceSetNode = GradleTreeStructureProvider.getGradleModuleNode(project, (PsiDirectoryNode)child, settings);
                    if (sourceSetNode != null && !GradleTreeStructureProvider.showUnderModuleGroup(sourceSetNode.myModule)) continue;
                    child = sourceSetNode != null ? sourceSetNode : child;
                }
                modifiedChildren.add(child);
            }
            SmartList smartList = modifiedChildren;
            if (smartList == null) {
                GradleTreeStructureProvider.$$$reportNull$$$0(3);
            }
            return smartList;
        }
        if (parent instanceof GradleProjectViewModuleNode) {
            Module module = (Module)((GradleProjectViewModuleNode)parent).getValue();
            String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
            SmartList modifiedChildren = new SmartList();
            for (AbstractTreeNode<?> child : children) {
                PsiDirectory psiDirectory;
                if (child instanceof PsiDirectoryNode && (psiDirectory = (PsiDirectory)((PsiDirectoryNode)child).getValue()) != null) {
                    VirtualFile virtualFile = psiDirectory.getVirtualFile();
                    if (projectPath != null && FileUtil.isAncestor((String)projectPath, (String)virtualFile.getPath(), (boolean)false)) continue;
                }
                modifiedChildren.add(child);
            }
            SmartList smartList = modifiedChildren;
            if (smartList == null) {
                GradleTreeStructureProvider.$$$reportNull$$$0(4);
            }
            return smartList;
        }
        if (parent instanceof PsiDirectoryNode) {
            SmartList modifiedChildren = new SmartList();
            for (AbstractTreeNode<?> child : children) {
                if (child instanceof PsiDirectoryNode) {
                    AbstractTreeNode<?> sourceSetNode = GradleTreeStructureProvider.getGradleModuleNode(project, (PsiDirectoryNode)child, settings);
                    child = sourceSetNode != null ? sourceSetNode : child;
                }
                modifiedChildren.add(child);
            }
            SmartList smartList = modifiedChildren;
            if (smartList == null) {
                GradleTreeStructureProvider.$$$reportNull$$$0(5);
            }
            return smartList;
        }
        Collection<AbstractTreeNode<?>> collection = children;
        if (collection == null) {
            GradleTreeStructureProvider.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private static boolean showUnderModuleGroup(Module module) {
        if (ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
            for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (projectPath == null || FileUtil.isAncestor((String)projectPath, (String)root.getPath(), (boolean)true)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @NotNull
    private static Collection<AbstractTreeNode<?>> getProjectNodeChildren(@NotNull Project project, @NotNull Collection<AbstractTreeNode<?>> children) {
        if (project == null) {
            GradleTreeStructureProvider.$$$reportNull$$$0(7);
        }
        if (children == null) {
            GradleTreeStructureProvider.$$$reportNull$$$0(8);
        }
        SmartList modifiedChildren = new SmartList();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (AbstractTreeNode abstractTreeNode : children) {
            PsiDirectory psiDirectory;
            Pair parentNodePair = null;
            if (abstractTreeNode instanceof ProjectViewModuleGroupNode) {
                ProjectViewModuleGroupNode groupNode = (ProjectViewModuleGroupNode)abstractTreeNode;
                Collection groupNodeChildren = groupNode.getChildren();
                for (AbstractTreeNode node : groupNodeChildren) {
                    if (node instanceof PsiDirectoryNode) {
                        PsiDirectoryNode psiDirectoryNode = (PsiDirectoryNode)node;
                        PsiDirectory psiDirectory2 = (PsiDirectory)psiDirectoryNode.getValue();
                        if (psiDirectory2 == null) {
                            parentNodePair = null;
                        } else {
                            VirtualFile virtualFile = psiDirectory2.getVirtualFile();
                            Module module = fileIndex.getModuleForFile(virtualFile);
                            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
                                parentNodePair = null;
                            } else {
                                if (parentNodePair == null || VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)((VirtualFile)parentNodePair.first), (boolean)false)) {
                                    parentNodePair = Pair.pair((Object)virtualFile, (Object)psiDirectoryNode);
                                    continue;
                                }
                                if (VfsUtilCore.isAncestor((VirtualFile)((VirtualFile)parentNodePair.first), (VirtualFile)virtualFile, (boolean)false)) continue;
                                parentNodePair = null;
                            }
                        }
                    } else {
                        parentNodePair = null;
                    }
                    break;
                }
            } else if (abstractTreeNode instanceof PsiDirectoryNode && abstractTreeNode.getParent() == null && (psiDirectory = (PsiDirectory)((PsiDirectoryNode)abstractTreeNode).getValue()) != null) {
                VirtualFile directoryFile = psiDirectory.getVirtualFile();
                GradleModuleDirectoryNode gradleModuleNode = GradleTreeStructureProvider.getGradleModuleNode(project, (PsiDirectoryNode)abstractTreeNode, ((PsiDirectoryNode)abstractTreeNode).getSettings());
                if (gradleModuleNode != null) {
                    parentNodePair = Pair.pair((Object)directoryFile, (Object)((Object)gradleModuleNode));
                }
            }
            modifiedChildren.add(parentNodePair != null ? (AbstractTreeNode)parentNodePair.second : abstractTreeNode);
        }
        SmartList smartList = modifiedChildren;
        if (smartList == null) {
            GradleTreeStructureProvider.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    @Nullable
    private static GradleProjectViewModuleNode getGradleModuleNode(@NotNull Project project, @NotNull ProjectViewModuleNode moduleNode, ViewSettings settings) {
        Module module;
        String moduleShortName;
        if (project == null) {
            GradleTreeStructureProvider.$$$reportNull$$$0(10);
        }
        if (moduleNode == null) {
            GradleTreeStructureProvider.$$$reportNull$$$0(11);
        }
        if ((moduleShortName = GradleTreeStructureProvider.getGradleModuleShortName(module = (Module)moduleNode.getValue())) == null) {
            return null;
        }
        return new GradleProjectViewModuleNode(project, module, settings, moduleShortName);
    }

    @Nullable
    private static GradleModuleDirectoryNode getGradleModuleNode(@NotNull Project project, @NotNull PsiDirectoryNode directoryNode, ViewSettings settings) {
        PsiDirectory psiDirectory;
        if (project == null) {
            GradleTreeStructureProvider.$$$reportNull$$$0(12);
        }
        if (directoryNode == null) {
            GradleTreeStructureProvider.$$$reportNull$$$0(13);
        }
        if ((psiDirectory = (PsiDirectory)directoryNode.getValue()) == null) {
            return null;
        }
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        if (!ProjectRootsUtil.isModuleContentRoot((VirtualFile)virtualFile, (Project)project)) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = fileIndex.getModuleForFile(virtualFile);
        String moduleShortName = GradleTreeStructureProvider.getGradleModuleShortName(module);
        if (moduleShortName == null) {
            return null;
        }
        return new GradleModuleDirectoryNode(project, psiDirectory, settings, module, moduleShortName, directoryNode.getFilter());
    }

    @Nullable
    private static String getGradleModuleShortName(Module module) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        if (GradleTreeStructureProvider.isSourceSetModule(module)) {
            return GradleProjectResolverUtil.getSourceSetName((Module)module);
        }
        String moduleShortName = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        boolean isRootModule = StringUtil.equals((CharSequence)ExternalSystemApiUtil.getExternalProjectPath((Module)module), (CharSequence)ExternalSystemApiUtil.getExternalRootProjectPath((Module)module));
        if (isRootModule || moduleShortName == null) {
            return moduleShortName;
        }
        moduleShortName = ModuleGrouper.instanceFor((Project)module.getProject()).getShortenedNameByFullModuleName(moduleShortName);
        return StringUtil.getShortName((String)moduleShortName, (char)':');
    }

    private static boolean isSourceSetModule(Module module) {
        return "sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectNodeChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProjectNodeChildren";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGradleModuleNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GradleProjectViewModuleNode
    extends ProjectViewModuleNode {
        @NotNull
        @NlsSafe
        private final String myModuleShortName;

        GradleProjectViewModuleNode(Project project, Module value, ViewSettings viewSettings, @NotNull String moduleShortName) {
            if (moduleShortName == null) {
                GradleProjectViewModuleNode.$$$reportNull$$$0(0);
            }
            super(project, value, viewSettings);
            this.myModuleShortName = moduleShortName;
        }

        public void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                GradleProjectViewModuleNode.$$$reportNull$$$0(1);
            }
            super.update(presentation2);
            presentation2.setPresentableText(this.myModuleShortName);
            presentation2.addText(this.myModuleShortName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }

        protected boolean showModuleNameInBold() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleShortName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider$GradleProjectViewModuleNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GradleModuleDirectoryNode
    extends PsiDirectoryNode {
        @NlsSafe
        private final String myModuleShortName;
        private final Module myModule;
        private final boolean appendModuleName;
        private final boolean isSourceSetModule;

        GradleModuleDirectoryNode(Project project, @NotNull PsiDirectory psiDirectory, ViewSettings settings, Module module, String moduleShortName, PsiFileSystemItemFilter filter) {
            if (psiDirectory == null) {
                GradleModuleDirectoryNode.$$$reportNull$$$0(0);
            }
            super(project, psiDirectory, settings, filter);
            this.myModuleShortName = moduleShortName;
            this.myModule = module;
            VirtualFile directoryFile = psiDirectory.getVirtualFile();
            this.appendModuleName = StringUtil.isNotEmpty((String)this.myModuleShortName) && !StringUtil.equalsIgnoreCase((CharSequence)this.myModuleShortName.replace("-", ""), (CharSequence)directoryFile.getName().replace("-", ""));
            this.isSourceSetModule = GradleTreeStructureProvider.isSourceSetModule(this.myModule);
        }

        protected boolean shouldShowModuleName() {
            return !this.appendModuleName && !this.isSourceSetModule || GradleModuleDirectoryNode.canRealModuleNameBeHidden();
        }

        protected void updateImpl(@NotNull PresentationData data) {
            List fragments;
            if (data == null) {
                GradleModuleDirectoryNode.$$$reportNull$$$0(1);
            }
            super.updateImpl(data);
            if (this.appendModuleName) {
                if (!GradleModuleDirectoryNode.canRealModuleNameBeHidden()) {
                    data.addText("[" + this.myModuleShortName + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
            } else if (this.isSourceSetModule && (fragments = data.getColoredText()).size() == 1) {
                PresentableNodeDescriptor.ColoredFragment fragment = (PresentableNodeDescriptor.ColoredFragment)fragments.iterator().next();
                data.clearText();
                data.addText(fragment.getText().trim(), SimpleTextAttributes.merge((SimpleTextAttributes)fragment.getAttributes(), (SimpleTextAttributes)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiDirectory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/gradle/projectView/GradleTreeStructureProvider$GradleModuleDirectoryNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

