/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ExceptionInfoCache {
    private final ConcurrentMap<String, ClassResolveInfo> myCache = ContainerUtil.createConcurrentSoftValueMap();
    private final Project myProject;
    private final GlobalSearchScope mySearchScope;

    public ExceptionInfoCache(GlobalSearchScope searchScope) {
        this.myProject = Objects.requireNonNull(searchScope.getProject());
        this.mySearchScope = searchScope;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ExceptionInfoCache.$$$reportNull$$$0(0);
        }
        return project;
    }

    private PsiClass @NotNull [] findClassesPreferringMyScope(String className) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(this.myProject);
        PsiClass[] result = psiFacade.findClasses(className, this.mySearchScope);
        PsiClass[] psiClassArray = result.length != 0 ? result : psiFacade.findClasses(className, GlobalSearchScope.allScope((Project)this.myProject));
        if (psiClassArray == null) {
            ExceptionInfoCache.$$$reportNull$$$0(1);
        }
        return psiClassArray;
    }

    ClassResolveInfo resolveClass(String className) {
        int dollarIndex;
        ClassResolveInfo cached = (ClassResolveInfo)this.myCache.get(className);
        if (cached != null) {
            return cached;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            return ClassResolveInfo.EMPTY;
        }
        PsiElement[] classes = this.findClassesPreferringMyScope(className);
        if (classes.length == 0 && (dollarIndex = className.indexOf(36)) >= 0) {
            classes = this.findClassesPreferringMyScope(className.substring(0, dollarIndex));
        }
        ClassResolveInfo result = ClassResolveInfo.create(this.myProject, classes);
        this.myCache.put(className, result);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/filters/ExceptionInfoCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesPreferringMyScope";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static class ClassResolveInfo {
        static final ClassResolveInfo EMPTY = new ClassResolveInfo(Collections.emptyMap(), false);
        final Map<VirtualFile, PsiElement> myClasses;
        final boolean myInLibrary;

        ClassResolveInfo(Map<VirtualFile, PsiElement> classes, boolean library) {
            this.myClasses = classes;
            this.myInLibrary = library;
        }

        @NotNull
        static ClassResolveInfo create(Project project, PsiElement[] elements) {
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
            LinkedHashMap<VirtualFile, PsiElement> result = new LinkedHashMap<VirtualFile, PsiElement>();
            boolean library = true;
            for (PsiElement element : elements) {
                PsiFile file = (element = element.getNavigationElement()).getContainingFile();
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile == null) continue;
                if (index.isInContent(virtualFile)) {
                    if (library) {
                        library = false;
                        result.clear();
                    }
                } else if (!library) continue;
                result.put(virtualFile, element);
            }
            return new ClassResolveInfo(result, library);
        }
    }
}

