/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineStateUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JdkCommandLineSetup;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCommandLineState
extends CommandLineState
implements JavaCommandLine,
TargetEnvironmentAwareRunProfileState {
    private static final Logger LOG = Logger.getInstance(JavaCommandLineState.class);
    private JavaParameters myParams;
    private TargetEnvironmentRequest myTargetEnvironmentRequest;
    private TargetedCommandLineBuilder myCommandLine;

    protected JavaCommandLineState(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            JavaCommandLineState.$$$reportNull$$$0(0);
        }
        super(environment);
    }

    @Override
    public JavaParameters getJavaParameters() throws ExecutionException {
        if (this.myParams == null) {
            this.myParams = (JavaParameters)((Object)ReadAction.compute(this::createJavaParameters));
        }
        return this.myParams;
    }

    public void clear() {
        this.myParams = null;
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler oSProcessHandler = JavaCommandLineStateUtil.startProcess(this.createCommandLine(), this.ansiColoringEnabled());
        if (oSProcessHandler == null) {
            JavaCommandLineState.$$$reportNull$$$0(1);
        }
        return oSProcessHandler;
    }

    protected boolean ansiColoringEnabled() {
        return true;
    }

    protected abstract JavaParameters createJavaParameters() throws ExecutionException;

    public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration configuration, @NotNull TargetEnvironmentAwareRunProfileState.TargetProgressIndicator targetProgressIndicator) throws ExecutionException {
        if (request == null) {
            JavaCommandLineState.$$$reportNull$$$0(2);
        }
        if (targetProgressIndicator == null) {
            JavaCommandLineState.$$$reportNull$$$0(3);
        }
        targetProgressIndicator.addSystemLine(ExecutionBundle.message((String)"progress.text.prepare.target.requirements", (Object[])new Object[0]));
        this.myTargetEnvironmentRequest = request;
        Ref commandLineRef = new Ref();
        Ref exceptionRef = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                commandLineRef.set((Object)this.createTargetedCommandLine(this.myTargetEnvironmentRequest, configuration));
            }
            catch (ExecutionException e) {
                exceptionRef.set((Object)e);
            }
        });
        if (!exceptionRef.isNull()) {
            throw (ExecutionException)((Object)exceptionRef.get());
        }
        this.myCommandLine = (TargetedCommandLineBuilder)commandLineRef.get();
    }

    public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetEnvironmentAwareRunProfileState.TargetProgressIndicator targetProgressIndicator) {
        if (environment == null) {
            JavaCommandLineState.$$$reportNull$$$0(4);
        }
        if (targetProgressIndicator == null) {
            JavaCommandLineState.$$$reportNull$$$0(5);
        }
        TargetedCommandLineBuilder targetedCommandLineBuilder = this.getTargetedCommandLine();
        Objects.requireNonNull((JdkCommandLineSetup)targetedCommandLineBuilder.getUserData(JdkUtil.COMMAND_LINE_SETUP_KEY)).provideEnvironment(environment, targetProgressIndicator);
    }

    @Nullable
    public synchronized TargetEnvironmentRequest getTargetEnvironmentRequest() {
        return this.myTargetEnvironmentRequest;
    }

    @NotNull
    protected synchronized TargetedCommandLineBuilder getTargetedCommandLine() {
        TargetedCommandLineBuilder targetedCommandLineBuilder;
        if (this.myCommandLine != null) {
            TargetedCommandLineBuilder targetedCommandLineBuilder2 = this.myCommandLine;
            if (targetedCommandLineBuilder2 == null) {
                JavaCommandLineState.$$$reportNull$$$0(6);
            }
            return targetedCommandLineBuilder2;
        }
        if (Experiments.getInstance().isFeatureEnabled("run.targets") && !(this.getEnvironment().getTargetEnvironmentFactory() instanceof LocalTargetEnvironmentFactory)) {
            LOG.error("Command line hasn't been built yet. Probably you need to run environment#getPreparedTargetEnvironment first, or it return the environment from the previous run session");
        }
        try {
            this.getEnvironment().prepareTargetEnvironment((RunProfileState)this, TargetEnvironmentAwareRunProfileState.TargetProgressIndicator.EMPTY);
            targetedCommandLineBuilder = this.myCommandLine;
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
        if (targetedCommandLineBuilder == null) {
            JavaCommandLineState.$$$reportNull$$$0(7);
        }
        return targetedCommandLineBuilder;
    }

    @NotNull
    protected TargetedCommandLineBuilder createTargetedCommandLine(@NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration configuration) throws ExecutionException {
        JavaParameters javaParameters;
        if (request == null) {
            JavaCommandLineState.$$$reportNull$$$0(8);
        }
        if (!(javaParameters = this.getJavaParameters()).isDynamicClasspath()) {
            javaParameters.setUseDynamicClasspath(this.getEnvironment().getProject());
        }
        TargetedCommandLineBuilder targetedCommandLineBuilder = javaParameters.toCommandLine(request, configuration);
        if (targetedCommandLineBuilder == null) {
            JavaCommandLineState.$$$reportNull$$$0(9);
        }
        return targetedCommandLineBuilder;
    }

    protected GeneralCommandLine createCommandLine() throws ExecutionException {
        LocalTargetEnvironmentFactory factory = new LocalTargetEnvironmentFactory();
        boolean redirectErrorStream = Registry.is((String)"run.processes.with.redirectedErrorStream", (boolean)false);
        TargetEnvironmentRequest request = factory.createRequest();
        TargetedCommandLineBuilder targetedCommandLineBuilder = this.createTargetedCommandLine(request, factory.getTargetConfiguration());
        LocalTargetEnvironment environment = factory.prepareRemoteEnvironment(request, TargetEnvironmentAwareRunProfileState.TargetProgressIndicator.EMPTY);
        Objects.requireNonNull((JdkCommandLineSetup)targetedCommandLineBuilder.getUserData(JdkUtil.COMMAND_LINE_SETUP_KEY)).provideEnvironment((TargetEnvironment)environment, TargetEnvironmentAwareRunProfileState.TargetProgressIndicator.EMPTY);
        return environment.createGeneralCommandLine(targetedCommandLineBuilder.build()).withRedirectErrorStream(redirectErrorStream);
    }

    public boolean shouldAddJavaProgramRunnerActions() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/JavaCommandLineState";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/JavaCommandLineState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetedCommandLine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetedCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareTargetEnvironmentRequest";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleCreatedTargetEnvironment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTargetedCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

