/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.DebuggerClassFilterProvider;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinStepAction;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProviderKt;

public class DebuggerSteppingHelper {
    public static DebugProcessImpl.ResumeCommand createStepOverCommand(final SuspendContextImpl suspendContext, final boolean ignoreBreakpoints, final SourcePosition sourcePosition2) {
        DebugProcessImpl debugProcess;
        DebugProcessImpl debugProcessImpl = debugProcess = suspendContext.getDebugProcess();
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.ResumeCommand(debugProcessImpl, suspendContext){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                Objects.requireNonNull(debugProcessImpl2);
                super(debugProcessImpl2, arg0);
            }

            public void contextAction() {
                Location location;
                StackFrameProxyImpl frameProxy = suspendContext.getFrameProxy();
                Location location2 = location = frameProxy == null ? null : SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
                if (location != null) {
                    KotlinStepAction action2 = KotlinSteppingCommandProviderKt.getStepOverAction(location, sourcePosition2, suspendContext, frameProxy);
                    DebuggerSteppingHelper.createStepRequest(suspendContext, this.getContextThread(), debugProcess.getVirtualMachineProxy().eventRequestManager(), -2, 3);
                    action2.apply(debugProcess, suspendContext, ignoreBreakpoints);
                    return;
                }
                debugProcess.createStepOutCommand(suspendContext).contextAction();
            }
        };
    }

    public static DebugProcessImpl.ResumeCommand createStepOverCommandForSuspendSwitch(SuspendContextImpl suspendContext) {
        DebugProcessImpl debugProcess;
        DebugProcessImpl debugProcessImpl = debugProcess = suspendContext.getDebugProcess();
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.StepOverCommand(debugProcessImpl, suspendContext, false, null, -1){
            {
                DebugProcessImpl debugProcessImpl = x0;
                Objects.requireNonNull(debugProcessImpl);
                super(debugProcessImpl, arg0, arg1, arg2, arg3);
            }

            @NotNull
            protected RequestHint getHint(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl stepThread) {
                RequestHint hint = new RequestHint(stepThread, suspendContext, -1, 2, this.myMethodFilter){

                    public int getNextStepDepth(SuspendContextImpl context) {
                        StackFrameProxyImpl frameProxy = context.getFrameProxy();
                        if (frameProxy != null && DebuggerUtilKt.isOnSuspensionPoint(frameProxy)) {
                            return 2;
                        }
                        return super.getNextStepDepth(context);
                    }
                };
                hint.setIgnoreFilters(suspendContext.getDebugProcess().getSession().shouldIgnoreSteppingFilters());
                RequestHint requestHint = hint;
                if (requestHint == null) {
                    2.$$$reportNull$$$0(0);
                }
                return requestHint;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/debugger/stepping/DebuggerSteppingHelper$2", "getHint"));
            }
        };
    }

    public static DebugProcessImpl.ResumeCommand createStepOutCommand(final SuspendContextImpl suspendContext, final boolean ignoreBreakpoints) {
        DebugProcessImpl debugProcess;
        DebugProcessImpl debugProcessImpl = debugProcess = suspendContext.getDebugProcess();
        Objects.requireNonNull(debugProcessImpl);
        return new DebugProcessImpl.ResumeCommand(debugProcessImpl, suspendContext){
            {
                DebugProcessImpl debugProcessImpl2 = x0;
                Objects.requireNonNull(debugProcessImpl2);
                super(debugProcessImpl2, arg0);
            }

            public void contextAction() {
                Location location;
                StackFrameProxyImpl frameProxy = suspendContext.getFrameProxy();
                Location location2 = location = frameProxy == null ? null : SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
                if (location != null) {
                    KotlinStepAction action2 = KotlinSteppingCommandProviderKt.getStepOutAction(location, frameProxy);
                    DebuggerSteppingHelper.createStepRequest(suspendContext, this.getContextThread(), debugProcess.getVirtualMachineProxy().eventRequestManager(), -2, 3);
                    action2.apply(debugProcess, suspendContext, ignoreBreakpoints);
                    return;
                }
                debugProcess.createStepOverCommand(suspendContext, ignoreBreakpoints).contextAction();
            }
        };
    }

    private static void createStepRequest(@NotNull SuspendContextImpl suspendContext, @Nullable ThreadReferenceProxyImpl stepThread, @NotNull EventRequestManager requestManager, int size, int depth) {
        if (suspendContext == null) {
            DebuggerSteppingHelper.$$$reportNull$$$0(0);
        }
        if (requestManager == null) {
            DebuggerSteppingHelper.$$$reportNull$$$0(1);
        }
        if (stepThread == null) {
            return;
        }
        try {
            String currentClassName;
            ThreadReference stepThreadReference = stepThread.getThreadReference();
            requestManager.deleteEventRequests(requestManager.stepRequests());
            StepRequest stepRequest = requestManager.createStepRequest(stepThreadReference, size, depth);
            List<ClassFilter> activeFilters = DebuggerSteppingHelper.getActiveFilters();
            if (!(activeFilters.isEmpty() || (currentClassName = DebuggerSteppingHelper.getCurrentClassName(stepThread)) != null && DebuggerUtilsEx.isFiltered((String)currentClassName, activeFilters))) {
                for (ClassFilter filter : activeFilters) {
                    stepRequest.addClassExclusionFilter(filter.getPattern());
                }
            }
            stepRequest.setSuspendPolicy(suspendContext.getSuspendPolicy() == 1 ? 1 : 2);
            stepRequest.enable();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    @NotNull
    private static List<ClassFilter> getActiveFilters() {
        DebuggerSettings settings = DebuggerSettings.getInstance();
        StreamEx stream = StreamEx.of((Collection)DebuggerClassFilterProvider.EP_NAME.getExtensionList()).flatCollection(DebuggerClassFilterProvider::getFilters);
        if (settings.TRACING_FILTERS_ENABLED) {
            stream = stream.prepend((Object[])settings.getSteppingFilters());
        }
        List list = ((StreamEx)stream.filter(ClassFilter::isEnabled)).toList();
        if (list == null) {
            DebuggerSteppingHelper.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    private static String getCurrentClassName(ThreadReferenceProxyImpl thread) {
        try {
            if (thread != null && thread.frameCount() > 0) {
                Location location;
                StackFrameProxyImpl stackFrame = thread.frame(0);
                Location location2 = location = stackFrame == null ? null : SafeUtilKt.safeLocation((StackFrameProxy)stackFrame);
                if (stackFrame != null) {
                    ReferenceType referenceType;
                    ReferenceType referenceType2 = referenceType = location == null ? null : location.declaringType();
                    if (referenceType != null) {
                        return referenceType.name();
                    }
                }
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/debugger/stepping/DebuggerSteppingHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/debugger/stepping/DebuggerSteppingHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStepRequest";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

