/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scripting.gradle.importing;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.FilePosition;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemEventDispatcher;
import com.intellij.openapi.project.Project;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scripting.gradle.importing.KotlinDslScriptModel;
import org.jetbrains.kotlin.idea.scripting.gradle.importing.KotlinGradleDslErrorReporter$WhenMappings;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/scripting/gradle/importing/KotlinGradleDslErrorReporter;", "", "project", "Lcom/intellij/openapi/project/Project;", "task", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;)V", "buildEventDispatcher", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemEventDispatcher;", "syncViewManager", "Lcom/intellij/build/SyncViewManager;", "reportError", "", "scriptFile", "Ljava/io/File;", "model", "Lorg/jetbrains/kotlin/idea/scripting/gradle/importing/KotlinDslScriptModel;", "kotlin.gradle.gradle-idea"})
public final class KotlinGradleDslErrorReporter {
    private final SyncViewManager syncViewManager;
    private final ExternalSystemEventDispatcher buildEventDispatcher;
    private final ExternalSystemTaskId task;

    public final void reportError(@NotNull File scriptFile, @NotNull KotlinDslScriptModel model) {
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Iterable $this$forEach$iv = model.getMessages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageEvent.Kind kind;
            KotlinDslScriptModel.Message it = (KotlinDslScriptModel.Message)element$iv;
            boolean bl = false;
            switch (KotlinGradleDslErrorReporter$WhenMappings.$EnumSwitchMapping$0[it.getSeverity().ordinal()]) {
                case 1: {
                    kind = MessageEvent.Kind.WARNING;
                    break;
                }
                case 2: {
                    kind = MessageEvent.Kind.ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            MessageEvent.Kind severity = kind;
            KotlinDslScriptModel.Position position = it.getPosition();
            if (position == null) {
                this.buildEventDispatcher.onEvent((Object)this.task, (BuildEvent)new MessageEventImpl((Object)this.task, severity, "Kotlin Build Script Errors", it.getText(), it.getDetails()));
                continue;
            }
            this.buildEventDispatcher.onEvent((Object)this.task, (BuildEvent)new FileMessageEventImpl((Object)this.task, severity, "Kotlin Build Script Errors", it.getText(), it.getDetails(), new FilePosition(scriptFile, position.getLine() - 1, position.getColumn())));
        }
    }

    public KotlinGradleDslErrorReporter(@NotNull Project project, @NotNull ExternalSystemTaskId task) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.task = task;
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(SyncViewManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        this.syncViewManager = (SyncViewManager)object;
        this.buildEventDispatcher = new ExternalSystemEventDispatcher(this.task, (BuildProgressListener)this.syncViewManager);
    }
}

