/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.klib;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.klib.KlibInfo;
import org.jetbrains.kotlin.idea.configuration.klib.KlibInfoProvider;
import org.jetbrains.kotlin.idea.configuration.klib.KlibInfoProvider$WhenMappings;
import org.jetbrains.kotlin.idea.configuration.klib.NativeDistributionCommonizedKlibInfo;
import org.jetbrains.kotlin.idea.configuration.klib.NativeDistributionKlibInfo;
import org.jetbrains.kotlin.konan.target.Distribution;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.TargetSupportException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002-.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0016\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u0019H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u001a\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0003J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u0007H\u0002J\u0016\u0010)\u001a\u0004\u0018\u00010&*\u00020\u00072\u0006\u0010*\u001a\u00020+H\u0002J\u000e\u0010,\u001a\u0004\u0018\u00010\u0019*\u00020&H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/klib/KlibInfoProvider;", "", "kotlinNativeHome", "Ljava/io/File;", "(Ljava/io/File;)V", "cachedProperties", "", "Ljava/nio/file/Path;", "Ljava/util/Properties;", "hostManager", "Lorg/jetbrains/kotlin/konan/target/HostManager;", "getHostManager", "()Lorg/jetbrains/kotlin/konan/target/HostManager;", "hostManager$delegate", "Lkotlin/Lazy;", "nativeDistributionLibrariesPath", "kotlin.jvm.PlatformType", "nativeDistributionLibrarySourceFiles", "", "getNativeDistributionLibrarySourceFiles", "()Ljava/util/List;", "nativeDistributionLibrarySourceFiles$delegate", "detectCommonizedTargets", "Lorg/jetbrains/kotlin/idea/configuration/klib/KlibInfoProvider$ResultWrapper;", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "libraryPath", "ownTarget", "detectOrigin", "Lorg/jetbrains/kotlin/idea/configuration/klib/KlibInfoProvider$Origin;", "detectTarget", "findManifestFile", "getKlibInfo", "Lorg/jetbrains/kotlin/idea/configuration/klib/KlibInfo;", "libraryFile", "getLibrarySourcesFromDistribution", "", "libraryName", "", "loadProperties", "propertiesPath", "getNameOrNull", "index", "", "toTargetOrNull", "Origin", "ResultWrapper", "kotlin.gradle.gradle-idea"})
public final class KlibInfoProvider {
    private final Path nativeDistributionLibrariesPath;
    private final Lazy hostManager$delegate;
    private final Lazy nativeDistributionLibrarySourceFiles$delegate;
    private final Map<Path, Properties> cachedProperties;

    private final HostManager getHostManager() {
        Lazy lazy = this.hostManager$delegate;
        KlibInfoProvider klibInfoProvider2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (HostManager)lazy.getValue();
    }

    private final List<File> getNativeDistributionLibrarySourceFiles() {
        Lazy lazy = this.nativeDistributionLibrarySourceFiles$delegate;
        KlibInfoProvider klibInfoProvider2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @Nullable
    public final KlibInfo getKlibInfo(@NotNull File libraryFile) {
        KlibInfo klibInfo;
        Path libraryPath;
        Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
        Path path = libraryPath = libraryFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"libraryPath");
        Origin origin = this.detectOrigin(path);
        if (origin == null) {
            return null;
        }
        Origin origin2 = origin;
        Path path2 = this.findManifestFile(libraryPath);
        if (path2 == null) {
            return null;
        }
        Path manifestFile = path2;
        Properties manifest = this.loadProperties(manifestFile);
        boolean bl = false;
        boolean bl2 = false;
        Properties $this$with = manifest;
        boolean bl3 = false;
        String string = $this$with.getProperty("short_name");
        if (string == null) {
            string = $this$with.getProperty("unique_name");
        }
        if (string == null) {
            return null;
        }
        String name = string;
        ResultWrapper<KonanTarget> resultWrapper = this.detectTarget(libraryPath);
        if (resultWrapper == null) {
            return null;
        }
        KonanTarget target = resultWrapper.getResult();
        switch (KlibInfoProvider$WhenMappings.$EnumSwitchMapping$0[origin2.ordinal()]) {
            case 1: {
                Collection<File> sourcePaths = target == null ? this.getLibrarySourcesFromDistribution(name) : (Collection<File>)CollectionsKt.emptyList();
                klibInfo = new NativeDistributionKlibInfo(libraryFile, sourcePaths, name, target);
                break;
            }
            case 2: {
                ResultWrapper<Set<KonanTarget>> resultWrapper2 = this.detectCommonizedTargets(libraryPath, target);
                if (resultWrapper2 == null) {
                    return null;
                }
                Set<KonanTarget> commonizedTargets = resultWrapper2.getResult();
                klibInfo = new NativeDistributionCommonizedKlibInfo(libraryFile, CollectionsKt.emptyList(), name, target, commonizedTargets);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return klibInfo;
    }

    private final Origin detectOrigin(Path libraryPath) {
        Origin origin;
        if (!libraryPath.startsWith(this.nativeDistributionLibrariesPath)) {
            origin = null;
        } else {
            Path path = this.nativeDistributionLibrariesPath;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"nativeDistributionLibrariesPath");
            origin = Intrinsics.areEqual((Object)this.getNameOrNull(libraryPath, path.getNameCount()), (Object)"commonized") ? Origin.NATIVE_DISTRIBUTION_COMMONIZED : Origin.NATIVE_DISTRIBUTION;
        }
        return origin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Path findManifestFile(Path libraryPath) {
        Path path;
        Path path2 = libraryPath.resolve("manifest");
        boolean bl = false;
        boolean bl2 = false;
        Path propertiesPath322 = path2;
        boolean bl3 = false;
        if (Files.isRegularFile(propertiesPath322, new LinkOption[0])) {
            return propertiesPath322;
        }
        if (!Files.isDirectory(libraryPath, new LinkOption[0])) {
            return null;
        }
        Closeable closeable = Files.newDirectoryStream(libraryPath);
        bl2 = false;
        boolean propertiesPath322 = false;
        Throwable propertiesPath322 = null;
        try {
            void $this$mapNotNullTo$iv$iv;
            Iterable stream = (DirectoryStream)closeable;
            boolean bl4 = false;
            DirectoryStream directoryStream = stream;
            Intrinsics.checkNotNullExpressionValue((Object)directoryStream, (String)"stream");
            Iterable $this$mapNotNull$iv = directoryStream;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Path path3;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                Path componentPath = (Path)element$iv$iv;
                boolean bl6 = false;
                Path candidate = componentPath.resolve("manifest");
                if ((Files.isRegularFile(candidate, new LinkOption[0]) ? candidate : null) == null) continue;
                path3 = path3;
                boolean bl7 = false;
                boolean bl8 = false;
                Path it$iv$iv = path3;
                boolean bl9 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            stream = (List)destination$iv$iv;
        }
        catch (Throwable stream) {
            propertiesPath322 = stream;
            throw stream;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)propertiesPath322);
        }
        Iterable candidates = stream;
        switch (candidates.size()) {
            case 0: {
                path = null;
                break;
            }
            case 1: {
                path = (Path)CollectionsKt.single(candidates);
                break;
            }
            default: {
                Object v2;
                Iterable $this$minByOrNull$iv = candidates;
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v2 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v2 = minElem$iv;
                    } else {
                        Path it = (Path)minElem$iv;
                        boolean bl10 = false;
                        Comparable minValue$iv = (Comparable)((Object)((Object)it.getName(it.getNameCount() - 2)).toString());
                        do {
                            Object e$iv = iterator$iv.next();
                            Path it2 = (Path)e$iv;
                            $i$a$-minByOrNull-KlibInfoProvider$findManifestFile$2 = false;
                            Comparable v$iv = (Comparable)((Object)((Object)it2.getName(it2.getNameCount() - 2)).toString());
                            if (minValue$iv.compareTo(v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v2 = minElem$iv;
                    }
                }
                Intrinsics.checkNotNull(v2);
                path = v2;
            }
        }
        return path;
    }

    private final Properties loadProperties(Path propertiesPath) {
        Properties properties = this.cachedProperties.computeIfAbsent(propertiesPath, new Function<Path, Properties>(propertiesPath){
            final /* synthetic */ Path $propertiesPath;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final Properties apply(@NotNull Path it) {
                void var2_2;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Properties properties = new Properties();
                try {
                    Closeable closeable = Files.newInputStream(this.$propertiesPath, new OpenOption[0]);
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        InputStream it2 = (InputStream)closeable;
                        boolean bl3 = false;
                        properties.load(it2);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return var2_2;
            }
            {
                this.$propertiesPath = path;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"cachedProperties.compute\u2026\n        properties\n    }");
        return properties;
    }

    private final ResultWrapper<KonanTarget> detectTarget(Path libraryPath) {
        if (libraryPath.getNameCount() < 3) {
            return null;
        }
        String parentDirName = ((Object)libraryPath.getName(libraryPath.getNameCount() - 2)).toString();
        if (Intrinsics.areEqual((Object)parentDirName, (Object)"common")) {
            return new ResultWrapper<Object>(null);
        }
        KonanTarget konanTarget = this.toTargetOrNull(parentDirName);
        if (konanTarget == null) {
            return null;
        }
        KonanTarget target = konanTarget;
        String grandParentDirName = ((Object)libraryPath.getName(libraryPath.getNameCount() - 3)).toString();
        return Intrinsics.areEqual((Object)grandParentDirName, (Object)"platform") ? new ResultWrapper<KonanTarget>(target) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final ResultWrapper<Set<KonanTarget>> detectCommonizedTargets(Path libraryPath, KonanTarget ownTarget) {
        void $this$mapNotNullTo$iv;
        if (libraryPath.getNameCount() < 4) {
            return null;
        }
        int additionalOffset = ownTarget == null ? 0 : 1;
        String commonizedLibsDirName = ((Object)libraryPath.getName(libraryPath.getNameCount() - 3 - additionalOffset)).toString();
        List rawTargets = CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)commonizedLibsDirName, (char[])new char[]{'-'}, (boolean)false, (int)0, (int)6, null), (int)1);
        Iterable iterable = rawTargets;
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            KonanTarget konanTarget;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            String it = (String)element$iv;
            boolean bl3 = false;
            if (this.toTargetOrNull(it) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            KonanTarget it$iv = konanTarget;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        Set targets = (Set)destination$iv;
        if (targets.isEmpty() || targets.size() != rawTargets.size() || ownTarget != null && !targets.contains(ownTarget)) {
            return null;
        }
        return new ResultWrapper<Set<KonanTarget>>(targets);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<File> getLibrarySourcesFromDistribution(String libraryName) {
        void $this$filterTo$iv$iv;
        Function1 nameFilter2 = Intrinsics.areEqual((Object)libraryName, (Object)"stdlib") ? (Function1)getLibrarySourcesFromDistribution.nameFilter.1.INSTANCE : (Function1)new Function1<String, Boolean>(libraryName){
            final /* synthetic */ String $libraryName;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.startsWith$default((String)it, (String)this.$libraryName, (boolean)false, (int)2, null);
            }
            {
                this.$libraryName = string;
                super(1);
            }
        };
        Iterable $this$filter$iv = this.getNativeDistributionLibrarySourceFiles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            if (!((Boolean)nameFilter2.invoke((Object)string)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final KonanTarget toTargetOrNull(String $this$toTargetOrNull) {
        KonanTarget konanTarget;
        try {
            konanTarget = this.getHostManager().targetByName($this$toTargetOrNull);
        }
        catch (TargetSupportException _) {
            konanTarget = null;
        }
        return konanTarget;
    }

    private final String getNameOrNull(Path $this$getNameOrNull, int index) {
        return index < 0 || index >= $this$getNameOrNull.getNameCount() ? null : ((Object)$this$getNameOrNull.getName(index)).toString();
    }

    public KlibInfoProvider(@NotNull File kotlinNativeHome) {
        Intrinsics.checkNotNullParameter((Object)kotlinNativeHome, (String)"kotlinNativeHome");
        this.nativeDistributionLibrariesPath = FilesKt.resolve((File)kotlinNativeHome, (String)"klib").toPath();
        this.hostManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HostManager>(kotlinNativeHome){
            final /* synthetic */ File $kotlinNativeHome;

            @NotNull
            public final HostManager invoke() {
                String string = this.$kotlinNativeHome.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinNativeHome.path");
                return new HostManager(new Distribution(string, false, null, 6, null), true);
            }
            {
                this.$kotlinNativeHome = file;
                super(0);
            }
        }));
        this.nativeDistributionLibrarySourceFiles$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends File>>(kotlinNativeHome){
            final /* synthetic */ File $kotlinNativeHome;

            @NotNull
            public final List<File> invoke() {
                File file = FilesKt.resolve((File)this.$kotlinNativeHome, (String)"sources");
                boolean bl = false;
                boolean bl2 = false;
                File it = file;
                boolean bl3 = false;
                Object object = it.isDirectory() ? file : null;
                if (object == null || (object = FilesKt.walkTopDown((File)object)) == null || (object = object.maxDepth(1)) == null || (object = SequencesKt.filter((Sequence)((Sequence)object), (Function1)nativeDistributionLibrarySourceFiles.2.INSTANCE)) == null || (object = SequencesKt.toList((Sequence)object)) == null) {
                    object = CollectionsKt.emptyList();
                }
                return object;
            }
            {
                this.$kotlinNativeHome = file;
                super(0);
            }
        }));
        boolean bl = false;
        this.cachedProperties = new LinkedHashMap();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/klib/KlibInfoProvider$Origin;", "", "(Ljava/lang/String;I)V", "NATIVE_DISTRIBUTION", "NATIVE_DISTRIBUTION_COMMONIZED", "kotlin.gradle.gradle-idea"})
    private static final class Origin
    extends Enum<Origin> {
        public static final /* enum */ Origin NATIVE_DISTRIBUTION;
        public static final /* enum */ Origin NATIVE_DISTRIBUTION_COMMONIZED;
        private static final /* synthetic */ Origin[] $VALUES;

        static {
            Origin[] originArray = new Origin[2];
            Origin[] originArray2 = originArray;
            originArray[0] = NATIVE_DISTRIBUTION = new Origin();
            originArray[1] = NATIVE_DISTRIBUTION_COMMONIZED = new Origin();
            $VALUES = originArray;
        }

        public static Origin[] values() {
            return (Origin[])$VALUES.clone();
        }

        public static Origin valueOf(String string) {
            return Enum.valueOf(Origin.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/klib/KlibInfoProvider$ResultWrapper;", "T", "", "result", "(Ljava/lang/Object;)V", "getResult", "()Ljava/lang/Object;", "Ljava/lang/Object;", "kotlin.gradle.gradle-idea"})
    private static final class ResultWrapper<T> {
        private final T result;

        public final T getResult() {
            return this.result;
        }

        public ResultWrapper(T result2) {
            this.result = result2;
        }
    }
}

