/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class MvcProjectWithoutLibraryNotificator
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            MvcProjectWithoutLibraryNotificator.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            Pair<Module, MvcFramework> pair = MvcProjectWithoutLibraryNotificator.findModuleWithoutLibrary(project);
            if (pair == null) {
                return;
            }
            MvcFramework framework = (MvcFramework)pair.second;
            final Module module = (Module)pair.first;
            String name = framework.getFrameworkName();
            final Map<String, Runnable> actions = framework.createConfigureActions(module);
            HtmlBuilder builder = new HtmlBuilder();
            builder.append(GroovyBundle.message("mvc.framework.0.module.1.has.no.sdk", name, module.getName()));
            if (!actions.isEmpty()) {
                builder.br();
            }
            for (String actionName : actions.keySet()) {
                builder.appendLink(actionName, actionName).append(" ");
            }
            String message = builder.wrapWithHtmlBody().toString();
            new Notification(name + ".Configure", GroovyBundle.message("mvc.framework.0.sdk.not.found.title", name), message, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (module.isDisposed()) {
                        return;
                    }
                    Runnable runnable = (Runnable)actions.get(e.getDescription());
                    assert (runnable != null);
                    runnable.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/groovy/mvc/MvcProjectWithoutLibraryNotificator$1";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).notify(project);
        }).inSmartMode(project).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Nullable
    private static Pair<Module, MvcFramework> findModuleWithoutLibrary(Project project) {
        MvcFramework[] frameworks = (MvcFramework[])MvcFramework.EP_NAME.getExtensions();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (MvcFramework framework : frameworks) {
                if (!framework.hasFrameworkStructure(module) || framework.hasFrameworkJar(module) || VfsUtil.findRelativeFile((VirtualFile)framework.findAppRoot(module), (String[])new String[]{"application.properties"}) == null) continue;
                return Pair.create((Object)module, (Object)framework);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/mvc/MvcProjectWithoutLibraryNotificator", "runActivity"));
    }
}

