/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.PrintStream;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.Terminal;
import net.rubygrapefruit.platform.TerminalSize;
import net.rubygrapefruit.platform.internal.AbstractTerminal;

public class WrapperTerminal
extends AbstractTerminal {
    private final AbstractTerminal terminal;
    private final PrintStream stream;
    private final Object lock = new Object();

    public WrapperTerminal(PrintStream stream, AbstractTerminal terminal) {
        this.stream = stream;
        this.terminal = terminal;
    }

    protected void init() {
        this.stream.flush();
        this.terminal.init();
    }

    public String toString() {
        return this.terminal.toString();
    }

    public TerminalSize getTerminalSize() throws NativeException {
        return this.terminal.getTerminalSize();
    }

    public boolean supportsColor() {
        return this.terminal.supportsColor();
    }

    public boolean supportsCursorMotion() {
        return this.terminal.supportsCursorMotion();
    }

    public boolean supportsTextAttributes() {
        return this.terminal.supportsTextAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal normal() throws NativeException {
        this.stream.flush();
        Object object = this.lock;
        synchronized (object) {
            this.terminal.normal();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal bold() throws NativeException {
        this.stream.flush();
        Object object = this.lock;
        synchronized (object) {
            this.terminal.bold();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal reset() throws NativeException {
        this.stream.flush();
        Object object = this.lock;
        synchronized (object) {
            this.terminal.reset();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal foreground(Terminal.Color color) throws NativeException {
        this.stream.flush();
        Object object = this.lock;
        synchronized (object) {
            this.terminal.foreground(color);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal cursorLeft(int count) throws NativeException {
        this.stream.flush();
        Object object = this.lock;
        synchronized (object) {
            this.terminal.cursorLeft(count);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal cursorRight(int count) throws NativeException {
        this.stream.flush();
        Object object = this.lock;
        synchronized (object) {
            this.terminal.cursorRight(count);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal cursorUp(int count) throws NativeException {
        this.stream.flush();
        Object object = this.lock;
        synchronized (object) {
            this.terminal.cursorUp(count);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal cursorDown(int count) throws NativeException {
        this.stream.flush();
        Object object = this.lock;
        synchronized (object) {
            this.terminal.cursorDown(count);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal cursorStartOfLine() throws NativeException {
        this.stream.flush();
        Object object = this.lock;
        synchronized (object) {
            this.terminal.cursorStartOfLine();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Terminal clearToEndOfLine() throws NativeException {
        this.stream.flush();
        Object object = this.lock;
        synchronized (object) {
            this.terminal.clearToEndOfLine();
        }
        return this;
    }
}

