/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.collapsing.FragmentGenerator;
import com.intellij.vcs.log.graph.impl.facade.GraphChanges;
import com.intellij.vcs.log.graph.impl.facade.GraphChangesUtil;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.visible.LinearFragmentGenerator;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CollapsedActionManager {
    private static final ActionCase LINEAR_COLLAPSE_CASE = new ActionCase(){

        @Override
        @Nullable
        public LinearGraphController.LinearGraphAnswer performAction(@NotNull ActionContext context) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (CollapsedActionManager.isForDelegateGraph(context)) {
                return null;
            }
            GraphElement affectedGraphElement = context.getAffectedGraphElement();
            if (affectedGraphElement == null) {
                return null;
            }
            LinearFragmentGenerator compiledLinearFragmentGenerator = context.myCompiledFragmentGenerators.linearFragmentGenerator;
            FragmentGenerator compiledFragmentGenerator = context.myCompiledFragmentGenerators.fragmentGenerator;
            if (context.getActionType() == GraphAction.Type.MOUSE_OVER) {
                LinearFragmentGenerator.GraphFragment fragment = compiledLinearFragmentGenerator.getPartLongFragment(affectedGraphElement);
                if (fragment == null) {
                    return null;
                }
                Set<Integer> middleCompiledNodes = compiledFragmentGenerator.getMiddleNodes(fragment.upNodeIndex, fragment.downNodeIndex, false);
                return LinearGraphUtils.createSelectedAnswer(context.getCompiledGraph(), middleCompiledNodes);
            }
            LinearFragmentGenerator.GraphFragment fragment = compiledLinearFragmentGenerator.getLongFragment(affectedGraphElement);
            if (fragment == null) {
                return null;
            }
            Set<Integer> middleCompiledNodes = compiledFragmentGenerator.getMiddleNodes(fragment.upNodeIndex, fragment.downNodeIndex, true);
            HashSet dottedCompiledEdges = new HashSet();
            for (Integer middleNodeIndex : middleCompiledNodes) {
                dottedCompiledEdges.addAll(ContainerUtil.filter(context.getCompiledGraph().getAdjacentEdges(middleNodeIndex, EdgeFilter.NORMAL_ALL), edge -> edge.getType() == GraphEdgeType.DOTTED));
            }
            int upNodeIndex = context.convertToDelegateNodeIndex(fragment.upNodeIndex);
            int downNodeIndex = context.convertToDelegateNodeIndex(fragment.downNodeIndex);
            Set<Integer> middleNodes = context.convertToDelegateNodeIndex(middleCompiledNodes);
            Set dottedEdges = ContainerUtil.map2Set(dottedCompiledEdges, edge -> context.convertToDelegateEdge((GraphEdge)edge));
            CollapsedGraph.Modification modification = context.myCollapsedGraph.startModification();
            for (GraphEdge edge2 : dottedEdges) {
                modification.removeEdge(edge2);
            }
            for (Integer middleNode : middleNodes) {
                modification.hideNode(middleNode);
            }
            modification.createEdge(new GraphEdge(upNodeIndex, downNodeIndex, null, GraphEdgeType.DOTTED));
            modification.apply();
            return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.SOME_CHANGES);
        }

        @Override
        @NotNull
        public Set<GraphAction.Type> supportedActionTypes() {
            Set<GraphAction.Type> set = Set.of(GraphAction.Type.MOUSE_CLICK, GraphAction.Type.MOUSE_OVER);
            if (set == null) {
                1.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/CollapsedActionManager$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/CollapsedActionManager$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "supportedActionTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "performAction";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final ActionCase EXPAND_ALL = new ActionCase(){

        @Override
        @NotNull
        public LinearGraphController.LinearGraphAnswer performAction(@NotNull ActionContext context) {
            if (context == null) {
                2.$$$reportNull$$$0(0);
            }
            CollapsedGraph.Modification modification = context.myCollapsedGraph.startModification();
            modification.removeAdditionalEdges();
            modification.resetNodesVisibility();
            return new DeferredGraphAnswer(GraphChangesUtil.SOME_CHANGES, modification);
        }

        @Override
        @NotNull
        public Set<GraphAction.Type> supportedActionTypes() {
            Set<GraphAction.Type> set = Collections.singleton(GraphAction.Type.BUTTON_EXPAND);
            if (set == null) {
                2.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/CollapsedActionManager$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/CollapsedActionManager$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "supportedActionTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "performAction";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final ActionCase COLLAPSE_ALL = new ActionCase(){

        @Override
        @NotNull
        public LinearGraphController.LinearGraphAnswer performAction(@NotNull ActionContext context) {
            if (context == null) {
                3.$$$reportNull$$$0(0);
            }
            CollapsedGraph.Modification modification = context.myCollapsedGraph.startModification();
            modification.removeAdditionalEdges();
            modification.resetNodesVisibility();
            LinearGraph delegateGraph = context.getDelegatedGraph();
            for (int nodeIndex = 0; nodeIndex < delegateGraph.nodesCount(); ++nodeIndex) {
                LinearFragmentGenerator.GraphFragment fragment;
                if (modification.isNodeHidden(nodeIndex) || (fragment = context.myDelegatedFragmentGenerators.linearFragmentGenerator.getLongDownFragment(nodeIndex)) == null) continue;
                Set<Integer> middleNodes = context.myDelegatedFragmentGenerators.fragmentGenerator.getMiddleNodes(fragment.upNodeIndex, fragment.downNodeIndex, true);
                for (Integer nodeIndexForHide : middleNodes) {
                    modification.hideNode(nodeIndexForHide);
                }
                modification.createEdge(new GraphEdge(fragment.upNodeIndex, fragment.downNodeIndex, null, GraphEdgeType.DOTTED));
            }
            return new DeferredGraphAnswer(GraphChangesUtil.SOME_CHANGES, modification);
        }

        @Override
        @NotNull
        public Set<GraphAction.Type> supportedActionTypes() {
            Set<GraphAction.Type> set = Collections.singleton(GraphAction.Type.BUTTON_COLLAPSE);
            if (set == null) {
                3.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/CollapsedActionManager$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/CollapsedActionManager$3";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "supportedActionTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "performAction";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final ActionCase LINEAR_EXPAND_CASE = new ActionCase(){

        @Override
        @Nullable
        public LinearGraphController.LinearGraphAnswer performAction(@NotNull ActionContext context) {
            if (context == null) {
                4.$$$reportNull$$$0(0);
            }
            if (CollapsedActionManager.isForDelegateGraph(context)) {
                return null;
            }
            GraphEdge dottedEdge = CollapsedActionManager.getDottedEdge(context.getAffectedGraphElement(), context.getCompiledGraph());
            if (dottedEdge != null) {
                int upNodeIndex = context.convertToDelegateNodeIndex(CollapsedActionManager.assertInt(dottedEdge.getUpNodeIndex()));
                int downNodeIndex = context.convertToDelegateNodeIndex(CollapsedActionManager.assertInt(dottedEdge.getDownNodeIndex()));
                if (context.getActionType() == GraphAction.Type.MOUSE_OVER) {
                    return LinearGraphUtils.createSelectedAnswer(context.getDelegatedGraph(), Set.of(Integer.valueOf(upNodeIndex), Integer.valueOf(downNodeIndex)));
                }
                Set<Integer> middleNodes = context.myDelegatedFragmentGenerators.fragmentGenerator.getMiddleNodes(upNodeIndex, downNodeIndex, true);
                CollapsedGraph.Modification modification = context.myCollapsedGraph.startModification();
                for (Integer middleNode : middleNodes) {
                    modification.showNode(middleNode);
                }
                modification.removeEdge(new GraphEdge(upNodeIndex, downNodeIndex, null, GraphEdgeType.DOTTED));
                modification.apply();
                return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.SOME_CHANGES);
            }
            return null;
        }

        @Override
        @NotNull
        public Set<GraphAction.Type> supportedActionTypes() {
            Set<GraphAction.Type> set = Set.of(GraphAction.Type.MOUSE_CLICK, GraphAction.Type.MOUSE_OVER);
            if (set == null) {
                4.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/CollapsedActionManager$4";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/CollapsedActionManager$4";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "supportedActionTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "performAction";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final List<ActionCase> FILTER_ACTION_CASES = Arrays.asList(COLLAPSE_ALL, EXPAND_ALL, LINEAR_EXPAND_CASE, LINEAR_COLLAPSE_CASE);

    @Nullable
    public static LinearGraphController.LinearGraphAnswer performAction(@NotNull CollapsedController graphController, @NotNull LinearGraphController.LinearGraphAction action) {
        if (graphController == null) {
            CollapsedActionManager.$$$reportNull$$$0(0);
        }
        if (action == null) {
            CollapsedActionManager.$$$reportNull$$$0(1);
        }
        ActionContext context = new ActionContext(graphController.getCollapsedGraph(), graphController.getPermanentGraphInfo(), action);
        for (ActionCase actionCase : FILTER_ACTION_CASES) {
            LinearGraphController.LinearGraphAnswer graphAnswer;
            if (!actionCase.supportedActionTypes().contains(context.getActionType()) || (graphAnswer = actionCase.performAction(context)) == null) continue;
            return graphAnswer;
        }
        return null;
    }

    public static void expandNodes(@NotNull CollapsedGraph collapsedGraph, Set<Integer> nodesToShow) {
        if (collapsedGraph == null) {
            CollapsedActionManager.$$$reportNull$$$0(2);
        }
        FragmentGenerator generator = new FragmentGenerator(LinearGraphUtils.asLiteLinearGraph(collapsedGraph.getDelegatedGraph()), (Condition<? super Integer>)((Condition)nodeIndex -> collapsedGraph.isNodeVisible((int)nodeIndex)));
        CollapsedGraph.Modification modification = collapsedGraph.startModification();
        for (Integer nodeToShow : nodesToShow) {
            FragmentGenerator.GreenFragment fragment;
            if (modification.isNodeShown(nodeToShow) || (fragment = generator.getGreenFragmentForCollapse(nodeToShow, Integer.MAX_VALUE)).getUpRedNode() == null || fragment.getDownRedNode() == null || fragment.getUpRedNode().equals(fragment.getDownRedNode())) continue;
            for (Integer n : fragment.getMiddleGreenNodes()) {
                modification.showNode(n);
            }
            modification.removeEdge(GraphEdge.createNormalEdge(fragment.getUpRedNode(), fragment.getDownRedNode(), GraphEdgeType.DOTTED));
        }
        modification.apply();
    }

    private static boolean isForDelegateGraph(@NotNull ActionContext context) {
        int downNodeIndex;
        int upNodeIndex;
        GraphElement affectedGraphElement;
        if (context == null) {
            CollapsedActionManager.$$$reportNull$$$0(3);
        }
        if ((affectedGraphElement = context.getAffectedGraphElement()) == null) {
            return false;
        }
        GraphEdge dottedEdge = CollapsedActionManager.getDottedEdge(context.getAffectedGraphElement(), context.getCompiledGraph());
        return dottedEdge != null && !context.myCollapsedGraph.isMyCollapsedEdge(upNodeIndex = context.convertToDelegateNodeIndex(CollapsedActionManager.assertInt(dottedEdge.getUpNodeIndex())), downNodeIndex = context.convertToDelegateNodeIndex(CollapsedActionManager.assertInt(dottedEdge.getDownNodeIndex())));
    }

    private CollapsedActionManager() {
    }

    private static int assertInt(@Nullable Integer value) {
        assert (value != null);
        return value;
    }

    @Nullable
    private static GraphEdge getDottedEdge(@Nullable GraphElement graphElement, @NotNull LinearGraph graph) {
        if (graph == null) {
            CollapsedActionManager.$$$reportNull$$$0(4);
        }
        if (graphElement == null) {
            return null;
        }
        if (graphElement instanceof GraphEdge && ((GraphEdge)graphElement).getType() == GraphEdgeType.DOTTED) {
            return (GraphEdge)graphElement;
        }
        if (graphElement instanceof GraphNode) {
            GraphNode node = (GraphNode)graphElement;
            for (GraphEdge edge : graph.getAdjacentEdges(node.getNodeIndex(), EdgeFilter.NORMAL_ALL)) {
                if (edge.getType() != GraphEdgeType.DOTTED) continue;
                return edge;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphController";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collapsedGraph";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/CollapsedActionManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "performAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "expandNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isForDelegateGraph";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDottedEdge";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DeferredGraphAnswer
    extends LinearGraphController.LinearGraphAnswer {
        @NotNull
        private final CollapsedGraph.Modification myModification;

        DeferredGraphAnswer(@Nullable GraphChanges<Integer> graphChanges, @NotNull CollapsedGraph.Modification modification) {
            if (modification == null) {
                DeferredGraphAnswer.$$$reportNull$$$0(0);
            }
            super(graphChanges);
            this.myModification = modification;
        }

        @Override
        @Nullable
        public Runnable getGraphUpdater() {
            return () -> this.myModification.apply();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modification", "com/intellij/vcs/log/graph/collapsing/CollapsedActionManager$DeferredGraphAnswer", "<init>"));
        }
    }

    private static final class FragmentGenerators {
        @NotNull
        private final FragmentGenerator fragmentGenerator;
        @NotNull
        private final LinearFragmentGenerator linearFragmentGenerator;

        private FragmentGenerators(@NotNull LinearGraph linearGraph, @NotNull PermanentGraphInfo<?> permanentGraphInfo, @NotNull UnsignedBitSet matchedNodeId) {
            if (linearGraph == null) {
                FragmentGenerators.$$$reportNull$$$0(0);
            }
            if (permanentGraphInfo == null) {
                FragmentGenerators.$$$reportNull$$$0(1);
            }
            if (matchedNodeId == null) {
                FragmentGenerators.$$$reportNull$$$0(2);
            }
            this.fragmentGenerator = new FragmentGenerator(LinearGraphUtils.asLiteLinearGraph(linearGraph), (Condition<? super Integer>)((Condition)nodeIndex -> matchedNodeId.get(linearGraph.getNodeId((int)nodeIndex))));
            Set<Integer> branchNodeIndexes = LinearGraphUtils.convertIdsToNodeIndexes(linearGraph, permanentGraphInfo.getBranchNodeIds());
            this.linearFragmentGenerator = new LinearFragmentGenerator(LinearGraphUtils.asLiteLinearGraph(linearGraph), branchNodeIndexes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "linearGraph";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "permanentGraphInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "matchedNodeId";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/graph/collapsing/CollapsedActionManager$FragmentGenerators";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ActionContext {
        @NotNull
        private final CollapsedGraph myCollapsedGraph;
        @NotNull
        private final LinearGraphController.LinearGraphAction myGraphAction;
        @NotNull
        private final FragmentGenerators myDelegatedFragmentGenerators;
        @NotNull
        private final FragmentGenerators myCompiledFragmentGenerators;

        private ActionContext(@NotNull CollapsedGraph collapsedGraph, @NotNull PermanentGraphInfo permanentGraphInfo, @NotNull LinearGraphController.LinearGraphAction graphAction) {
            if (collapsedGraph == null) {
                ActionContext.$$$reportNull$$$0(0);
            }
            if (permanentGraphInfo == null) {
                ActionContext.$$$reportNull$$$0(1);
            }
            if (graphAction == null) {
                ActionContext.$$$reportNull$$$0(2);
            }
            this.myCollapsedGraph = collapsedGraph;
            this.myGraphAction = graphAction;
            this.myDelegatedFragmentGenerators = new FragmentGenerators(collapsedGraph.getDelegatedGraph(), permanentGraphInfo, collapsedGraph.getMatchedNodeId());
            this.myCompiledFragmentGenerators = new FragmentGenerators(collapsedGraph.getCompiledGraph(), permanentGraphInfo, collapsedGraph.getMatchedNodeId());
        }

        @NotNull
        GraphAction.Type getActionType() {
            GraphAction.Type type = this.myGraphAction.getType();
            if (type == null) {
                ActionContext.$$$reportNull$$$0(3);
            }
            return type;
        }

        @Nullable
        GraphElement getAffectedGraphElement() {
            return this.myGraphAction.getAffectedElement() == null ? null : this.myGraphAction.getAffectedElement().getGraphElement();
        }

        @NotNull
        LinearGraph getDelegatedGraph() {
            LinearGraph linearGraph = this.myCollapsedGraph.getDelegatedGraph();
            if (linearGraph == null) {
                ActionContext.$$$reportNull$$$0(4);
            }
            return linearGraph;
        }

        @NotNull
        LinearGraph getCompiledGraph() {
            LinearGraph linearGraph = this.myCollapsedGraph.getCompiledGraph();
            if (linearGraph == null) {
                ActionContext.$$$reportNull$$$0(5);
            }
            return linearGraph;
        }

        int convertToDelegateNodeIndex(int compiledNodeIndex) {
            return this.myCollapsedGraph.convertToDelegateNodeIndex(compiledNodeIndex);
        }

        @NotNull
        Set<Integer> convertToDelegateNodeIndex(@NotNull Collection<Integer> compiledNodeIndexes) {
            if (compiledNodeIndexes == null) {
                ActionContext.$$$reportNull$$$0(6);
            }
            Set set = ContainerUtil.map2Set(compiledNodeIndexes, nodeIndex -> this.convertToDelegateNodeIndex((int)nodeIndex));
            if (set == null) {
                ActionContext.$$$reportNull$$$0(7);
            }
            return set;
        }

        @NotNull
        GraphEdge convertToDelegateEdge(@NotNull GraphEdge compiledEdge) {
            if (compiledEdge == null) {
                ActionContext.$$$reportNull$$$0(8);
            }
            Integer upNodeIndex = null;
            Integer downNodeIndex = null;
            if (compiledEdge.getUpNodeIndex() != null) {
                upNodeIndex = this.convertToDelegateNodeIndex(compiledEdge.getUpNodeIndex());
            }
            if (compiledEdge.getDownNodeIndex() != null) {
                downNodeIndex = this.convertToDelegateNodeIndex(compiledEdge.getDownNodeIndex());
            }
            return new GraphEdge(upNodeIndex, downNodeIndex, compiledEdge.getTargetId(), compiledEdge.getType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collapsedGraph";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "permanentGraphInfo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphAction";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/graph/collapsing/CollapsedActionManager$ActionContext";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compiledNodeIndexes";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compiledEdge";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/graph/collapsing/CollapsedActionManager$ActionContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegatedGraph";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompiledGraph";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToDelegateNodeIndex";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToDelegateNodeIndex";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToDelegateEdge";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface ActionCase {
        @Nullable
        public LinearGraphController.LinearGraphAnswer performAction(@NotNull ActionContext var1);

        @NotNull
        public Set<GraphAction.Type> supportedActionTypes();
    }
}

