/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictConfigurable;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictResolution;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.InplaceButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public final class ChangelistConflictNotificationPanel
extends EditorNotificationPanel {
    private final ChangeList myChangeList;
    private final VirtualFile myFile;
    private final ChangelistConflictTracker myTracker;

    @Nullable
    public static ChangelistConflictNotificationPanel create(ChangelistConflictTracker tracker, VirtualFile file) {
        ChangeListManager manager = tracker.getChangeListManager();
        Change change = manager.getChange(file);
        if (change == null) {
            return null;
        }
        LocalChangeList changeList = manager.getChangeList(change);
        if (changeList == null) {
            return null;
        }
        return new ChangelistConflictNotificationPanel(tracker, file, changeList);
    }

    private ChangelistConflictNotificationPanel(final ChangelistConflictTracker tracker, VirtualFile file, LocalChangeList changeList) {
        this.myTracker = tracker;
        this.myFile = file;
        ChangeListManager manager = tracker.getChangeListManager();
        this.myChangeList = changeList;
        this.myLabel.setText(VcsBundle.message((String)"changes.file.from.non.active.changelist.is.modified", (Object[])new Object[0]));
        this.createActionLabel(VcsBundle.message((String)"link.label.move.changes", (Object[])new Object[0]), () -> ChangelistConflictResolution.MOVE.resolveConflict(this.myTracker.getProject(), this.myChangeList.getChanges(), this.myFile)).setToolTipText(VcsBundle.message((String)"changes.move.changes.to.active.change.list.name", (Object[])new Object[]{manager.getDefaultChangeList().getName()}));
        this.createActionLabel(VcsBundle.message((String)"link.label.switch.changelist", (Object[])new Object[0]), () -> {
            Change change = this.myTracker.getChangeListManager().getChange(this.myFile);
            if (change == null) {
                Messages.showInfoMessage((String)VcsBundle.message((String)"dialog.message.no.changes.for.this.file", (Object[])new Object[0]), (String)VcsBundle.message((String)"dialog.title.message", (Object[])new Object[0]));
            } else {
                ChangelistConflictResolution.SWITCH.resolveConflict(this.myTracker.getProject(), Collections.singletonList(change), null);
            }
        }).setToolTipText(VcsBundle.message((String)"changes.set.active.changelist.to.change.list.name", (Object[])new Object[]{this.myChangeList.getName()}));
        this.createActionLabel(VcsBundle.message((String)"link.label.ignore", (Object[])new Object[0]), () -> this.myTracker.ignoreConflict(this.myFile, true)).setToolTipText(VcsBundle.message((String)"changes.hide.this.notification", (Object[])new Object[0]));
        this.myLinksPanel.add((Component)new InplaceButton(VcsBundle.message((String)"tooltip.show.options.dialog", (Object[])new Object[0]), AllIcons.General.Settings, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSettingsUtil.getInstance().editConfigurable(ChangelistConflictNotificationPanel.this.myTracker.getProject(), (Configurable)new ChangelistConflictConfigurable(tracker));
            }
        }));
    }
}

