/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.JavaBeanDescriptor;
import org.fest.util.Collections;
import org.fest.util.Introspection;
import org.fest.util.IntrospectionError;
import org.fest.util.Lists;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

final class PropertySupport {
    private static final String SEPARATOR = ".";
    private static final PropertySupport INSTANCE = new PropertySupport();
    private final JavaBeanDescriptor javaBeanDescriptor;

    private PropertySupport() {
        this(new JavaBeanDescriptor());
    }

    PropertySupport(@Nonnull JavaBeanDescriptor javaBeanDescriptor) {
        this.javaBeanDescriptor = javaBeanDescriptor;
    }

    @Nonnull
    static PropertySupport instance() {
        return INSTANCE;
    }

    @Nonnull
    List<Object> propertyValues(@Nonnull String propertyName, @Nullable Collection<?> target) {
        if (Collections.isNullOrEmpty(target)) {
            return Lists.emptyList();
        }
        List nonNullElements = Collections.nonNullElementsIn(target);
        if (this.isNestedProperty(propertyName)) {
            String firstProperty = this.firstPropertyIfNested(propertyName);
            List<Object> firstPropertyValues = this.propertyValues(firstProperty, nonNullElements);
            return this.propertyValues(this.removeFirstPropertyIfNested(propertyName), firstPropertyValues);
        }
        return this.simplePropertyValues(propertyName, nonNullElements);
    }

    @Nonnull
    private List<Object> simplePropertyValues(@Nonnull String propertyName, @Nonnull Collection<?> target) {
        ArrayList propertyValues = Lists.newArrayList();
        for (Object e : target) {
            if (e == null) continue;
            propertyValues.add(this.propertyValue(propertyName, e));
        }
        return propertyValues;
    }

    boolean isNestedProperty(String propertyName) {
        Preconditions.checkNotNull((Object)propertyName);
        return propertyName.contains(SEPARATOR) && !propertyName.startsWith(SEPARATOR) && !propertyName.endsWith(SEPARATOR);
    }

    @Nonnull
    String removeFirstPropertyIfNested(@Nonnull String propertyName) {
        if (!this.isNestedProperty(propertyName)) {
            return "";
        }
        return (String)Preconditions.checkNotNull((Object)propertyName.substring(propertyName.indexOf(SEPARATOR) + 1));
    }

    @Nonnull
    String firstPropertyIfNested(@Nonnull String propertyName) {
        if (!this.isNestedProperty(propertyName)) {
            return propertyName;
        }
        return (String)Preconditions.checkNotNull((Object)propertyName.substring(0, propertyName.indexOf(SEPARATOR)));
    }

    @Nullable
    private Object propertyValue(@Nonnull String propertyName, @Nonnull Object target) {
        PropertyDescriptor descriptor = Introspection.getProperty((String)propertyName, (Object)target);
        return this.propertyValue(descriptor, propertyName, target);
    }

    @Nullable
    @VisibleForTesting
    Object propertyValue(@Nonnull PropertyDescriptor descriptor, @Nonnull String propertyName, @Nonnull Object target) {
        try {
            return this.javaBeanDescriptor.invokeReadMethod(descriptor, target);
        }
        catch (Exception e) {
            throw new IntrospectionError("Unable to obtain the value in property " + Strings.quote((String)propertyName), (Throwable)e);
        }
    }
}

