/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.incremental.UtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.ParameterTypeConversion;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.KotlinResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.LambdaKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionCandidateKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.SamConversionDescription;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SubKotlinCallArgument;
import org.jetbrains.kotlin.resolve.sam.SamConversionOracle;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0010\u001a\u00020\u00042\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\nH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/SamTypeConversions;", "Lorg/jetbrains/kotlin/resolve/calls/components/ParameterTypeConversion;", "()V", "conversionDefinitelyNotNeeded", "", "candidate", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinResolutionCandidate;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "expectedParameterType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "conversionIsNeededAfterSubtypingCheck", "conversionIsNeededBeforeSubtypingCheck", "convertParameterType", "parameter", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "hasNonAnalyzedLambdaAsReturnType", "subResolvedAtoms", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "type", "isJavaParameterCanBeConverted", "needCompatibilityResolveForSAM", "typeToConvert", "resolution"})
public final class SamTypeConversions
implements ParameterTypeConversion {
    public static final SamTypeConversions INSTANCE;

    @Override
    public boolean conversionDefinitelyNotNeeded(@NotNull KotlinResolutionCandidate candidate2, @NotNull KotlinCallArgument argument, @NotNull UnwrappedType expectedParameterType) {
        boolean generatingAdditionalSamCandidateIsEnabled;
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)expectedParameterType, (String)"expectedParameterType");
        KotlinCallComponents callComponents = candidate2.getCallComponents();
        boolean bl = generatingAdditionalSamCandidateIsEnabled = !callComponents.getLanguageVersionSettings().supportsFeature(LanguageFeature.SamConversionPerArgument) && !callComponents.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitVarargAsArrayAfterSamArgument);
        if (generatingAdditionalSamCandidateIsEnabled) {
            return true;
        }
        if (TypeUtilsKt.isNothing(expectedParameterType)) {
            return true;
        }
        if (FunctionTypesKt.isFunctionType(expectedParameterType)) {
            return true;
        }
        SamConversionOracle samConversionOracle = callComponents.getSamConversionOracle();
        if (!callComponents.getLanguageVersionSettings().supportsFeature(LanguageFeature.SamConversionForKotlinFunctions) && !samConversionOracle.shouldRunSamConversionForFunction(candidate2.getResolvedCall().getCandidateDescriptor())) {
            return true;
        }
        ClassifierDescriptor declarationDescriptor = expectedParameterType.getConstructor().getDeclarationDescriptor();
        return declarationDescriptor instanceof ClassDescriptor && ((ClassDescriptor)declarationDescriptor).isDefinitelyNotSamInterface();
    }

    @Override
    public boolean conversionIsNeededBeforeSubtypingCheck(@NotNull KotlinCallArgument argument) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        KotlinCallArgument kotlinCallArgument = argument;
        if (kotlinCallArgument instanceof SubKotlinCallArgument) {
            UnwrappedType stableType = ArgumentsUtilsKt.getStableType(((SubKotlinCallArgument)argument).getReceiver());
            if (FunctionTypesKt.isFunctionType(stableType)) {
                return true;
            }
            bl = this.hasNonAnalyzedLambdaAsReturnType(((SubKotlinCallArgument)argument).getCallResult().getSubResolvedAtoms(), stableType);
        } else {
            bl = kotlinCallArgument instanceof SimpleKotlinCallArgument ? FunctionTypesKt.isFunctionType(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument).getReceiver())) : kotlinCallArgument instanceof LambdaKotlinCallArgument || kotlinCallArgument instanceof CallableReferenceKotlinCallArgument;
        }
        return bl;
    }

    private final boolean hasNonAnalyzedLambdaAsReturnType(List<? extends ResolvedAtom> subResolvedAtoms, UnwrappedType type2) {
        List<? extends ResolvedAtom> list2 = subResolvedAtoms;
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResolvedAtom it = (ResolvedAtom)element$iv;
                boolean bl = false;
                if (it instanceof LambdaWithTypeVariableAsExpectedTypeAtom && Intrinsics.areEqual((Object)((LambdaWithTypeVariableAsExpectedTypeAtom)it).getExpectedType().getConstructor(), (Object)type2.getConstructor())) {
                    return true;
                }
                boolean hasNonAnalyzedLambda = INSTANCE.hasNonAnalyzedLambdaAsReturnType(it.getSubResolvedAtoms(), type2);
                if (!hasNonAnalyzedLambda) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean conversionIsNeededAfterSubtypingCheck(@NotNull KotlinCallArgument argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return argument instanceof SimpleKotlinCallArgument && FunctionTypesKt.isFunctionTypeOrSubtype(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument).getReceiver()));
    }

    @Override
    @Nullable
    public UnwrappedType convertParameterType(@NotNull KotlinResolutionCandidate candidate2, @NotNull KotlinCallArgument argument, @NotNull ParameterDescriptor parameter, @NotNull UnwrappedType expectedParameterType) {
        ClassifierDescriptor samDescriptor;
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)expectedParameterType, (String)"expectedParameterType");
        KotlinCallComponents callComponents = candidate2.getCallComponents();
        ParameterDescriptor parameterDescriptor = parameter.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)parameterDescriptor, (String)"parameter.original");
        UnwrappedType originalExpectedType = ArgumentsUtilsKt.getExpectedType(argument, parameterDescriptor, callComponents.getLanguageVersionSettings());
        UnwrappedType unwrappedType = SamConversionResolverImplKt.getFunctionTypeForPossibleSamType(callComponents.getSamConversionResolver(), expectedParameterType, callComponents.getSamConversionOracle());
        if (unwrappedType == null) {
            return null;
        }
        UnwrappedType convertedTypeByCandidate = unwrappedType;
        UnwrappedType convertedTypeByOriginal = Intrinsics.areEqual((Object)expectedParameterType.getConstructor(), (Object)originalExpectedType.getConstructor()) ? SamConversionResolverImplKt.getFunctionTypeForPossibleSamType(callComponents.getSamConversionResolver(), originalExpectedType, callComponents.getSamConversionOracle()) : convertedTypeByCandidate;
        UnwrappedType unwrappedType2 = convertedTypeByOriginal;
        boolean bl = Intrinsics.areEqual((Object)convertedTypeByCandidate.getConstructor(), (Object)(unwrappedType2 != null ? unwrappedType2.getConstructor() : null));
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "If original type is SAM type, then candidate should have same type constructor and corresponding function type\n" + "originalExpectType: " + originalExpectedType + ", candidateExpectType: " + expectedParameterType + '\n' + "functionTypeByOriginal: " + convertedTypeByOriginal + ", functionTypeByCandidate: " + convertedTypeByCandidate;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        MutableResolvedCallAtom mutableResolvedCallAtom = candidate2.getResolvedCall();
        UnwrappedType unwrappedType3 = convertedTypeByOriginal;
        Intrinsics.checkNotNull((Object)unwrappedType3);
        mutableResolvedCallAtom.registerArgumentWithSamConversion(argument, new SamConversionDescription(unwrappedType3, convertedTypeByCandidate));
        if (this.needCompatibilityResolveForSAM(candidate2, expectedParameterType)) {
            ResolutionCandidateKt.markCandidateForCompatibilityResolve(candidate2);
        }
        if ((samDescriptor = originalExpectedType.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
            UtilsKt.record(callComponents.getLookupTracker(), candidate2.getScopeTower().getLocation(), (ClassDescriptor)samDescriptor, SamConversionResolverKt.getSAM_LOOKUP_NAME());
        }
        return convertedTypeByCandidate;
    }

    private final boolean needCompatibilityResolveForSAM(KotlinResolutionCandidate candidate2, UnwrappedType typeToConvert) {
        ClassifierDescriptor descriptor2 = typeToConvert.getConstructor().getDeclarationDescriptor();
        if (descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).isFun()) {
            return false;
        }
        return !candidate2.getCallComponents().getSamConversionOracle().isJavaApplicableCandidate(candidate2.getResolvedCall().getCandidateDescriptor());
    }

    public final boolean isJavaParameterCanBeConverted(@NotNull KotlinResolutionCandidate candidate2, @NotNull UnwrappedType expectedParameterType) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)expectedParameterType, (String)"expectedParameterType");
        KotlinCallComponents callComponents = candidate2.getCallComponents();
        SamConversionOracle samConversionOracle = callComponents.getSamConversionOracle();
        if (!samConversionOracle.isJavaApplicableCandidate(candidate2.getResolvedCall().getCandidateDescriptor())) {
            return false;
        }
        ClassifierDescriptor declarationDescriptor = expectedParameterType.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor && ((ClassDescriptor)declarationDescriptor).isDefinitelyNotSamInterface()) {
            return false;
        }
        UnwrappedType convertedType = SamConversionResolverImplKt.getFunctionTypeForPossibleSamType(callComponents.getSamConversionResolver(), expectedParameterType, callComponents.getSamConversionOracle());
        return convertedType != null;
    }

    private SamTypeConversions() {
    }

    static {
        SamTypeConversions samTypeConversions;
        INSTANCE = samTypeConversions = new SamTypeConversions();
    }
}

