/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.TaskExecutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.DeprecatedMethodException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ProcessWaitFor {
    private static final Logger LOG = Logger.getInstance(ProcessWaitFor.class);
    private final Future<?> myWaitForThreadFuture;
    private final BlockingQueue<Consumer<? super Integer>> myTerminationCallback;
    private volatile boolean myDetached;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public ProcessWaitFor(@NotNull Process process, @NotNull TaskExecutor executor) {
        if (process == null) {
            ProcessWaitFor.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            ProcessWaitFor.$$$reportNull$$$0(1);
        }
        this(process, executor, "");
        DeprecatedMethodException.report("Use ProcessWaitFor(Process, TaskExecutor, String) instead");
    }

    public ProcessWaitFor(@NotNull Process process, @NotNull TaskExecutor executor, @NotNull String presentableName) {
        if (process == null) {
            ProcessWaitFor.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            ProcessWaitFor.$$$reportNull$$$0(3);
        }
        if (presentableName == null) {
            ProcessWaitFor.$$$reportNull$$$0(4);
        }
        this.myTerminationCallback = new ArrayBlockingQueue<Consumer<? super Integer>>(1);
        this.myWaitForThreadFuture = executor.executeTask(() -> {
            String threadName = StringUtil.isEmptyOrSpaces(presentableName) ? Thread.currentThread().getName() : presentableName;
            ConcurrencyUtil.runUnderThreadName(threadName, () -> {
                int exitCode = 0;
                try {
                    while (!this.myDetached) {
                        try {
                            exitCode = process.waitFor();
                            break;
                        }
                        catch (InterruptedException e) {
                            if (this.myDetached) continue;
                            LOG.debug(e);
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                    throw e;
                }
                finally {
                    if (!this.myDetached) {
                        try {
                            this.myTerminationCallback.take().consume((Integer)exitCode);
                        }
                        catch (InterruptedException e) {
                            LOG.info(e);
                        }
                    }
                }
            });
        });
    }

    public void detach() {
        this.myDetached = true;
        this.myWaitForThreadFuture.cancel(true);
    }

    public void setTerminationCallback(@NotNull Consumer<? super Integer> r) {
        if (r == null) {
            ProcessWaitFor.$$$reportNull$$$0(5);
        }
        this.myTerminationCallback.offer(r);
    }

    public void waitFor() throws InterruptedException {
        try {
            this.myWaitForThreadFuture.get();
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean waitFor(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        if (timeUnit == null) {
            ProcessWaitFor.$$$reportNull$$$0(6);
        }
        try {
            void unit;
            this.myWaitForThreadFuture.get(timeout, (TimeUnit)unit);
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
        catch (CancellationException | TimeoutException exception) {
            // empty catch block
        }
        return this.myWaitForThreadFuture.isDone();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/process/ProcessWaitFor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setTerminationCallback";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "waitFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

