/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.LoadingState;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class StartUpMeasurer {
    static final AtomicReference<LoadingState> currentState = new AtomicReference<LoadingState>(LoadingState.BOOTSTRAP);
    public static final long MEASURE_THRESHOLD = TimeUnit.MILLISECONDS.toNanos(10L);
    public static boolean measuringPluginStartupCosts = true;
    private static long startTime = System.nanoTime();
    private static final ConcurrentLinkedQueue<ActivityImpl> items = new ConcurrentLinkedQueue();
    private static boolean isEnabled = true;
    @ApiStatus.Internal
    public static final Map<String, Object2LongMap<String>> pluginCostMap = new HashMap<String, Object2LongMap<String>>();

    public static void stopPluginCostMeasurement() {
        measuringPluginStartupCosts = false;
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    @TestOnly
    public static void disable() {
        isEnabled = false;
    }

    public static long getCurrentTime() {
        return System.nanoTime();
    }

    public static long getCurrentTimeIfEnabled() {
        return isEnabled ? System.nanoTime() : -1L;
    }

    public static long sinceStart() {
        return TimeUnit.NANOSECONDS.toMillis(StartUpMeasurer.getCurrentTime() - startTime);
    }

    public static void addInstantEvent(@NonNls @NotNull String name) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(0);
        }
        if (!isEnabled) {
            return;
        }
        ActivityImpl activity = new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), null, null);
        activity.setEnd(-1L);
        StartUpMeasurer.addActivity(activity);
    }

    @NotNull
    public static Activity startActivity(@NonNls @NotNull String name) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(1);
        }
        return StartUpMeasurer.startActivity(name, ActivityCategory.APP_INIT);
    }

    @NotNull
    public static Activity startActivity(@NonNls @NotNull String name, @NotNull ActivityCategory category) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(2);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(3);
        }
        return StartUpMeasurer.startActivity(name, category, null);
    }

    @NotNull
    public static Activity startActivity(@NonNls @NotNull String name, @NotNull ActivityCategory category, @Nullable String pluginId) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(4);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(5);
        }
        return new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), null, pluginId, category);
    }

    @NotNull
    public static Activity startMainActivity(@NonNls @NotNull String name) {
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(6);
        }
        return new ActivityImpl(name, StartUpMeasurer.getCurrentTime(), null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static long addCompletedActivity(long start, @NotNull Class<?> clazz, @NotNull ActivityCategory category, @Nullable String string) {
        void pluginId;
        if (clazz == null) {
            StartUpMeasurer.$$$reportNull$$$0(7);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(8);
        }
        return StartUpMeasurer.addCompletedActivity(start, clazz, category, (String)pluginId, -1L);
    }

    /*
     * WARNING - void declaration
     */
    public static long addCompletedActivity(long start, @NotNull Class<?> clazz, @NotNull ActivityCategory category, @Nullable String pluginId, long l) {
        void threshold;
        if (clazz == null) {
            StartUpMeasurer.$$$reportNull$$$0(9);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(10);
        }
        if (!isEnabled) {
            return -1L;
        }
        long end = StartUpMeasurer.getCurrentTime();
        long duration = end - start;
        if (duration <= threshold) {
            return duration;
        }
        StartUpMeasurer.addCompletedActivity(start, end, clazz.getName(), category, pluginId);
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    public static long addCompletedActivity(long start, @NonNls @NotNull String name, @NotNull ActivityCategory category, String string) {
        void pluginId;
        long end;
        long duration;
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(11);
        }
        if (category == null) {
            StartUpMeasurer.$$$reportNull$$$0(12);
        }
        if ((duration = (end = StartUpMeasurer.getCurrentTime()) - start) <= MEASURE_THRESHOLD) {
            return duration;
        }
        StartUpMeasurer.addCompletedActivity(start, end, name, category, (String)pluginId);
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    public static void addCompletedActivity(long start, long end, @NonNls @NotNull String name, @NotNull ActivityCategory activityCategory, String string) {
        void category;
        void pluginId;
        if (name == null) {
            StartUpMeasurer.$$$reportNull$$$0(13);
        }
        if (activityCategory == null) {
            StartUpMeasurer.$$$reportNull$$$0(14);
        }
        if (!isEnabled) {
            return;
        }
        ActivityImpl item = new ActivityImpl(name, start, null, (String)pluginId, (ActivityCategory)category);
        item.setEnd(end);
        StartUpMeasurer.addActivity(item);
    }

    public static void setCurrentState(@NotNull LoadingState state) {
        BiConsumer<? super String, ? super Throwable> errorHandler;
        LoadingState old;
        if (state == null) {
            StartUpMeasurer.$$$reportNull$$$0(15);
        }
        if ((old = currentState.getAndSet(state)).compareTo(state) > 0 && (errorHandler = LoadingState.getErrorHandler()) != null) {
            errorHandler.accept("New state " + (Object)((Object)state) + " cannot precede old " + (Object)((Object)old), new Throwable());
        }
        StartUpMeasurer.stateSet(state);
    }

    public static void compareAndSetCurrentState(@NotNull LoadingState expectedState, @NotNull LoadingState newState) {
        if (expectedState == null) {
            StartUpMeasurer.$$$reportNull$$$0(16);
        }
        if (newState == null) {
            StartUpMeasurer.$$$reportNull$$$0(17);
        }
        if (currentState.compareAndSet(expectedState, newState)) {
            StartUpMeasurer.stateSet(newState);
        }
    }

    private static void stateSet(@NotNull LoadingState state) {
        if (state == null) {
            StartUpMeasurer.$$$reportNull$$$0(18);
        }
        StartUpMeasurer.addInstantEvent(state.displayName);
    }

    @ApiStatus.Internal
    public static void processAndClear(boolean isContinueToCollect, @NotNull Consumer<? super ActivityImpl> consumer) {
        ActivityImpl item;
        if (consumer == null) {
            StartUpMeasurer.$$$reportNull$$$0(19);
        }
        isEnabled = isContinueToCollect;
        while ((item = items.poll()) != null) {
            consumer.accept(item);
        }
    }

    @ApiStatus.Internal
    public static long getStartTime() {
        return startTime;
    }

    static void addActivity(@NotNull ActivityImpl activity) {
        if (activity == null) {
            StartUpMeasurer.$$$reportNull$$$0(20);
        }
        if (isEnabled) {
            items.add(activity);
        }
    }

    @ApiStatus.Internal
    public static void addTimings(@NotNull LinkedHashMap<String, Long> timings, @NotNull String groupName) {
        if (timings == null) {
            StartUpMeasurer.$$$reportNull$$$0(21);
        }
        if (groupName == null) {
            StartUpMeasurer.$$$reportNull$$$0(22);
        }
        if (!items.isEmpty()) {
            throw new IllegalStateException("addTimings must be not called if some events were already added using API");
        }
        if (timings.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<String, Long>> entries = new ArrayList<Map.Entry<String, Long>>(timings.entrySet());
        ActivityImpl parent = new ActivityImpl(groupName, (Long)((Map.Entry)entries.get(0)).getValue(), null, null);
        parent.setEnd(StartUpMeasurer.getCurrentTime());
        for (int i = 0; i < entries.size(); ++i) {
            long start = (Long)((Map.Entry)entries.get(i)).getValue();
            if (start < startTime) {
                startTime = start;
            }
            ActivityImpl activity = new ActivityImpl((String)((Map.Entry)entries.get(i)).getKey(), start, parent, null);
            activity.setEnd(i == entries.size() - 1 ? parent.getEnd() : ((Long)((Map.Entry)entries.get(i + 1)).getValue()).longValue());
            items.add(activity);
        }
        items.add(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void addPluginCost(@NonNls @NotNull String pluginId, @NonNls @NotNull String phase, long time) {
        if (pluginId == null) {
            StartUpMeasurer.$$$reportNull$$$0(23);
        }
        if (phase == null) {
            StartUpMeasurer.$$$reportNull$$$0(24);
        }
        if (!StartUpMeasurer.isMeasuringPluginStartupCosts()) {
            return;
        }
        Map<String, Object2LongMap<String>> map = pluginCostMap;
        synchronized (map) {
            StartUpMeasurer.doAddPluginCost(pluginId, phase, time, pluginCostMap);
        }
    }

    public static boolean isMeasuringPluginStartupCosts() {
        return measuringPluginStartupCosts;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static void doAddPluginCost(@NonNls @NotNull String pluginId, @NonNls @NotNull String phase, long time, @NotNull Map<String, Object2LongMap<String>> map) {
        long oldCost;
        void pluginCostMap;
        Object2LongMap costPerPhaseMap;
        if (pluginId == null) {
            StartUpMeasurer.$$$reportNull$$$0(25);
        }
        if (phase == null) {
            StartUpMeasurer.$$$reportNull$$$0(26);
        }
        if (map == null) {
            StartUpMeasurer.$$$reportNull$$$0(27);
        }
        if ((costPerPhaseMap = (Object2LongMap)pluginCostMap.get(pluginId)) == null) {
            costPerPhaseMap = new Object2LongOpenHashMap();
            costPerPhaseMap.defaultReturnValue(-1L);
            pluginCostMap.put(pluginId, costPerPhaseMap);
        }
        if ((oldCost = costPerPhaseMap.getLong((Object)phase)) == -1L) {
            oldCost = 0L;
        }
        costPerPhaseMap.put((Object)phase, oldCost + time);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedState";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timings";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginCostMap";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/StartUpMeasurer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addInstantEvent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startActivity";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "startMainActivity";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletedActivity";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrentState";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "compareAndSetCurrentState";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "stateSet";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "processAndClear";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "addActivity";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "addTimings";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "addPluginCost";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "doAddPluginCost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Activities {
        public static final String INIT_APP = "app initialization";
        public static final String PLACE_ON_EVENT_QUEUE = "place on event queue";
        public static final String REGISTER_COMPONENTS_SUFFIX = "component registration";
        public static final String CREATE_COMPONENTS_SUFFIX = "component creation";
        public static final String PROJECT_DUMB_POST_START_UP_ACTIVITIES = "project post-startup dumb-aware activities";
        public static final String EDITOR_RESTORING = "editor restoring";
        public static final String EDITOR_RESTORING_TILL_PAINT = "editor restoring till paint";
    }
}

