/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.text;

import java.awt.Component;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;

public abstract class TextReader<T extends Component> {
    @Nonnull
    public abstract Class<T> supportedComponent();

    @RunsInCurrentThread
    public final boolean containsText(@Nonnull Component c, @Nonnull String text) {
        this.checkCorrectType(c);
        Component casted = (Component)this.supportedComponent().cast(c);
        return this.checkContainsText(casted, text);
    }

    private void checkCorrectType(Component c) {
        Class<T> type = this.supportedComponent();
        if (!type.isAssignableFrom(c.getClass())) {
            String msg = String.format("Expecting component of type %s but got %s", type.getName(), c.getClass().getName());
            throw new IllegalArgumentException(msg);
        }
    }

    @RunsInCurrentThread
    protected abstract boolean checkContainsText(@Nonnull T var1, @Nonnull String var2);
}

