/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.keystroke;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.KeyStroke;
import org.fest.util.Maps;

class KeyStrokeMapCollection {
    private final Map<Character, KeyStroke> charToKeyStroke = Maps.newHashMap();
    private final Map<KeyStroke, Character> keyStrokeToChar = Maps.newHashMap();

    KeyStrokeMapCollection() {
    }

    void add(@Nonnull Character character, @Nonnull KeyStroke keyStroke) {
        this.charToKeyStroke.put(character, keyStroke);
        this.keyStrokeToChar.put(keyStroke, character);
    }

    void clear() {
        this.charToKeyStroke.clear();
        this.keyStrokeToChar.clear();
    }

    boolean isEmpty() {
        return this.charToKeyStroke.isEmpty() && this.keyStrokeToChar.isEmpty();
    }

    @Nullable
    KeyStroke keyStrokeFor(char character) {
        return this.charToKeyStroke.get(Character.valueOf(character));
    }

    @Nullable
    Character charFor(KeyStroke keyStroke) {
        return this.keyStrokeToChar.get(keyStroke);
    }
}

