/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.awt.AWT;

final class JListCellCenterQuery {
    @Nonnull
    @RunsInCurrentThread
    static Point cellCenter(@Nonnull JList list, @Nonnull Rectangle cellBounds) {
        Point cellCenter = AWT.centerOf(cellBounds);
        int listVisibleWidth = list.getVisibleRect().width;
        if (cellCenter.x < listVisibleWidth) {
            return cellCenter;
        }
        Point listCenter = AWT.centerOfVisibleRect(list);
        return new Point(listCenter.x, cellCenter.y);
    }

    private JListCellCenterQuery() {
    }
}

