/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.activity;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.AppExecutorUtil;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.Version;
import de.plushnikov.intellij.plugin.provider.LombokProcessorProvider;
import de.plushnikov.intellij.plugin.settings.ProjectSettings;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;

public class LombokProjectValidatorActivity
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            LombokProjectValidatorActivity.$$$reportNull$$$0(0);
        }
        LombokProcessorProvider lombokProcessorProvider = LombokProcessorProvider.getInstance(project);
        ReadAction.nonBlocking(() -> {
            if (project.isDisposed()) {
                return null;
            }
            boolean hasLombokLibrary = LombokProjectValidatorActivity.hasLombokLibrary(project);
            if (hasLombokLibrary && ProjectSettings.isEnabled(project, "LombokPluginIS_LOMBOK_VERSION_CHECK_Enabled", false)) {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                for (Module module : moduleManager.getModules()) {
                    String lombokVersion = Version.parseLombokVersion(LombokProjectValidatorActivity.findLombokEntry(ModuleRootManager.getInstance((Module)module)));
                    if (null == lombokVersion || Version.compareVersionString(lombokVersion, "1.18.16") >= 0) continue;
                    return LombokProjectValidatorActivity.getNotificationGroup().createNotification(LombokBundle.message("config.warn.dependency.outdated.title", new Object[0]), LombokBundle.message("config.warn.dependency.outdated.message", project.getName(), module.getName(), lombokVersion, "1.18.16"), NotificationType.WARNING, NotificationListener.URL_OPENING_LISTENER);
                }
            }
            if (hasLombokLibrary && ProjectSettings.isEnabled(project, "LombokPluginIS_ANNOTATION_PROCESSING_CHECK_Enabled", true) && !LombokProjectValidatorActivity.hasAnnotationProcessorsEnabled(project)) {
                return LombokProjectValidatorActivity.getNotificationGroup().createNotification(LombokBundle.message("config.warn.annotation-processing.disabled.title", new Object[0]), LombokBundle.message("config.warn.annotation-processing.disabled.message", project.getName()), NotificationType.ERROR, (not, e) -> {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        LombokProjectValidatorActivity.enableAnnotations(project);
                        not.expire();
                    }
                });
            }
            return null;
        }).expireWith((Disposable)lombokProcessorProvider).finishOnUiThread(ModalityState.NON_MODAL, notification -> {
            if (notification != null) {
                Notifications.Bus.notify((Notification)notification, (Project)project);
                Disposer.register((Disposable)lombokProcessorProvider, () -> notification.expire());
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    private static NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Lombok plugin");
        if (notificationGroup == null) {
            LombokProjectValidatorActivity.$$$reportNull$$$0(1);
        }
        return notificationGroup;
    }

    private static void enableAnnotations(Project project) {
        CompilerConfigurationImpl compilerConfiguration = LombokProjectValidatorActivity.getCompilerConfiguration(project);
        compilerConfiguration.getDefaultProcessorProfile().setEnabled(true);
        compilerConfiguration.getModuleProcessorProfiles().forEach(pp -> pp.setEnabled(true));
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(LombokBundle.message("popup.content.java.annotation.processing.has.been.enabled", new Object[0]), MessageType.INFO, null).setFadeoutTime(3000L).createBalloon().show(RelativePoint.getNorthEastOf((JComponent)statusBar.getComponent()), Balloon.Position.atRight);
    }

    private static CompilerConfigurationImpl getCompilerConfiguration(Project project) {
        return (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
    }

    private static boolean hasAnnotationProcessorsEnabled(Project project) {
        CompilerConfigurationImpl compilerConfiguration = LombokProjectValidatorActivity.getCompilerConfiguration(project);
        return compilerConfiguration.getDefaultProcessorProfile().isEnabled() && compilerConfiguration.getModuleProcessorProfiles().stream().allMatch(AnnotationProcessingConfiguration::isEnabled);
    }

    public static boolean hasLombokLibrary(Project project) {
        return CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            PsiPackage aPackage = (PsiPackage)ReadAction.compute(() -> JavaPsiFacade.getInstance((Project)project).findPackage("lombok.experimental"));
            return new CachedValueProvider.Result((Object)aPackage, new Object[]{ProjectRootManager.getInstance((Project)project)});
        }) != null;
    }

    public static boolean isVersionLessThan1_18_16(Project project) {
        if (LombokProjectValidatorActivity.hasLombokLibrary(project)) {
            return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
                Boolean isVersionLessThan = (Boolean)ReadAction.compute(() -> LombokProjectValidatorActivity.isVersionLessThan1_18_16_Internal(project));
                return new CachedValueProvider.Result((Object)isVersionLessThan, new Object[]{ProjectRootManager.getInstance((Project)project)});
            });
        }
        return false;
    }

    private static boolean isVersionLessThan1_18_16_Internal(@NotNull Project project) {
        List entries;
        PsiDirectory[] directories;
        PsiPackage aPackage;
        if (project == null) {
            LombokProjectValidatorActivity.$$$reportNull$$$0(2);
        }
        if ((aPackage = JavaPsiFacade.getInstance((Project)project).findPackage("lombok.experimental")) != null && (directories = aPackage.getDirectories()).length > 0 && !(entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(directories[0].getVirtualFile())).isEmpty()) {
            return Version.isLessThan((OrderEntry)entries.get(0), "1.18.16");
        }
        return false;
    }

    @Nullable
    private static OrderEntry findLombokEntry(@NotNull ModuleRootManager moduleRootManager) {
        OrderEntry[] orderEntries;
        if (moduleRootManager == null) {
            LombokProjectValidatorActivity.$$$reportNull$$$0(3);
        }
        for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
            if (!orderEntry.getPresentableName().contains("lombok")) continue;
            return orderEntry;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/activity/LombokProjectValidatorActivity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRootManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/activity/LombokProjectValidatorActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isVersionLessThan1_18_16_Internal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findLombokEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

