/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.sorting;

import com.intellij.application.options.CodeCompletionOptions;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.MLCompletionBundle;
import com.intellij.completion.ml.experiment.ExperimentInfo;
import com.intellij.completion.ml.experiment.ExperimentStatus;
import com.intellij.completion.ml.settings.CompletionMLRankingSettings;
import com.intellij.completion.ml.settings.MLCompletionSettingsCollector;
import com.intellij.completion.ml.storage.LookupStorage;
import com.intellij.completion.ml.storage.MutableLookupStorage;
import com.intellij.completion.ml.tracker.LookupTracker;
import com.intellij.completion.ml.util.LookupExtensionsKt;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.IconManager;
import com.intellij.ui.RowIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.IconUtil;
import icons.CompletionMlRankingIcons;
import java.awt.Component;
import java.awt.Graphics;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/completion/ml/sorting/PositionDiffArrowInitializer;", "Lcom/intellij/completion/ml/tracker/LookupTracker;", "()V", "iconWithRightMargin", "Lcom/intellij/util/IconUtil$IconSizeWrapper;", "icon", "Ljavax/swing/Icon;", "margin", "", "lookupCreated", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "storage", "Lcom/intellij/completion/ml/storage/MutableLookupStorage;", "shouldShowDiff", "", "lookupStorage", "Lcom/intellij/completion/ml/storage/LookupStorage;", "ArrowDecoratedIcon", "ArrowsDisabledNotification", "ArrowsOpinionNotification", "Companion", "intellij.completionMlRanking"})
public final class PositionDiffArrowInitializer
extends LookupTracker {
    private static final int DIFF_ICON_RIGHT_MARGIN = 4;
    private static final String SHOW_ARROWS_NOTIFICATION_REGISTRY = "completion.ml.show.arrows.notification";
    private static final String ARROWS_NOTIFICATION_SHOWN_KEY = "completion.ml.arrows.notification.shown";
    private static final int ARROWS_NOTIFICATION_AFTER_SESSIONS = 50;
    private static final Key<AtomicInteger> POSITION_DIFF_KEY;
    private static final Key<Boolean> POSITION_CHANGED_KEY;
    private static final Icon EMPTY_DIFF_ICON;
    private static final AtomicInteger sessionsWithArrowsCounter;
    public static final Companion Companion;

    @Override
    protected void lookupCreated(@NotNull LookupImpl lookup, @NotNull MutableLookupStorage storage) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (!this.shouldShowDiff(storage)) {
            return;
        }
        lookup.addPresentationCustomizer(new LookupCellRenderer.ItemPresentationCustomizer(this, lookup){
            final /* synthetic */ PositionDiffArrowInitializer this$0;
            final /* synthetic */ LookupImpl $lookup;

            @NotNull
            public LookupElementPresentation customizePresentation(@NotNull LookupElement item, @NotNull LookupElementPresentation presentation) {
                Icon icon;
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
                Boolean positionChanged = (Boolean)this.$lookup.getUserData(PositionDiffArrowInitializer.access$getPOSITION_CHANGED_KEY$cp());
                if (positionChanged == null || !positionChanged.booleanValue()) {
                    return presentation;
                }
                LookupElementPresentation newPresentation = new LookupElementPresentation();
                newPresentation.copyFrom(presentation);
                AtomicInteger atomicInteger = (AtomicInteger)item.getUserData(PositionDiffArrowInitializer.access$getPOSITION_DIFF_KEY$cp());
                Integer diff = atomicInteger != null ? Integer.valueOf(atomicInteger.get()) : null;
                if (diff == null || diff == 0) {
                    icon = PositionDiffArrowInitializer.access$getEMPTY_DIFF_ICON$cp();
                } else if (diff < 0) {
                    Icon icon2 = CompletionMlRankingIcons.ProposalUp;
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"CompletionMlRankingIcons.ProposalUp");
                } else {
                    Icon icon3 = CompletionMlRankingIcons.ProposalDown;
                    icon = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"CompletionMlRankingIcons.ProposalDown");
                }
                Icon diffIcon = icon;
                IconUtil.IconSizeWrapper diffIconWithMargin = PositionDiffArrowInitializer.iconWithRightMargin$default(this.this$0, diffIcon, 0, 2, null);
                newPresentation.setIcon((Icon)((Object)new ArrowDecoratedIcon((Icon)diffIconWithMargin, newPresentation.getIcon())));
                return newPresentation;
            }
            {
                this.this$0 = this$0;
                this.$lookup = $captured_local_variable$1;
            }
        });
    }

    private final boolean shouldShowDiff(LookupStorage lookupStorage) {
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
        CompletionMLRankingSettings mlRankingSettings = completionMLRankingSettings;
        return lookupStorage.getModel() != null && mlRankingSettings.isShowDiffEnabled();
    }

    private final IconUtil.IconSizeWrapper iconWithRightMargin(Icon icon, int margin) {
        return new IconUtil.IconSizeWrapper(icon, margin, icon, icon.getIconWidth() + margin, icon.getIconHeight()){
            final /* synthetic */ Icon $icon;
            final /* synthetic */ int $margin;

            protected void paintIcon(@Nullable Icon icon, @Nullable Component c, @Nullable Graphics g, int x, int y) {
                if (icon == null) {
                    return;
                }
                icon.paintIcon(c, g, x, y);
            }
            {
                this.$icon = $captured_local_variable$0;
                this.$margin = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        };
    }

    static /* synthetic */ IconUtil.IconSizeWrapper iconWithRightMargin$default(PositionDiffArrowInitializer positionDiffArrowInitializer, Icon icon, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 4;
        }
        return positionDiffArrowInitializer.iconWithRightMargin(icon, n);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"PositionDiffArrowInitializer.POSITION_DIFF_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<AtomicInteger\u2026lizer.POSITION_DIFF_KEY\")");
        POSITION_DIFF_KEY = key;
        Key key2 = Key.create((String)"PositionDiffArrowInitializer.POSITION_CHANGED_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create<Boolean>(\"Pos\u2026er.POSITION_CHANGED_KEY\")");
        POSITION_CHANGED_KEY = key2;
        Icon icon = IconManager.getInstance().createEmptyIcon(CompletionMlRankingIcons.ProposalUp);
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"IconManager.getInstance(\u2026lRankingIcons.ProposalUp)");
        EMPTY_DIFF_ICON = icon;
        sessionsWithArrowsCounter = new AtomicInteger();
    }

    public static final /* synthetic */ Icon access$getEMPTY_DIFF_ICON$cp() {
        return EMPTY_DIFF_ICON;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/completion/ml/sorting/PositionDiffArrowInitializer$ArrowDecoratedIcon;", "Lcom/intellij/ui/RowIcon;", "Lcom/intellij/codeInsight/lookup/impl/LookupCellRenderer$IconDecorator;", "arrowIcon", "Ljavax/swing/Icon;", "baseIcon", "(Ljavax/swing/Icon;Ljavax/swing/Icon;)V", "getDelegate", "withDelegate", "icon", "intellij.completionMlRanking"})
    public static final class ArrowDecoratedIcon
    extends RowIcon
    implements LookupCellRenderer.IconDecorator {
        private final Icon arrowIcon;
        private final Icon baseIcon;

        @Nullable
        public Icon getDelegate() {
            return this.baseIcon;
        }

        @NotNull
        public LookupCellRenderer.IconDecorator withDelegate(@Nullable Icon icon) {
            return new ArrowDecoratedIcon(this.arrowIcon, icon);
        }

        public ArrowDecoratedIcon(@NotNull Icon arrowIcon, @Nullable Icon baseIcon) {
            Intrinsics.checkNotNullParameter((Object)arrowIcon, (String)"arrowIcon");
            super(2, RowIcon.Alignment.CENTER);
            this.arrowIcon = arrowIcon;
            this.baseIcon = baseIcon;
            super.setIcon(this.arrowIcon, 0);
            super.setIcon(this.baseIcon, 1);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/completion/ml/sorting/PositionDiffArrowInitializer$ArrowsOpinionNotification;", "Lcom/intellij/notification/Notification;", "()V", "intellij.completionMlRanking"})
    private static final class ArrowsOpinionNotification
    extends Notification {
        public ArrowsOpinionNotification() {
            super(MLCompletionBundle.message("ml.completion.notification.groupId", new Object[0]), MLCompletionBundle.message("ml.completion.notification.title", new Object[0]), MLCompletionBundle.message("ml.completion.notification.decorating.opinion.content", new Object[0]), NotificationType.INFORMATION);
            this.addAction((AnAction)new NotificationAction(MLCompletionBundle.message("ml.completion.notification.decorating.opinion.like", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    MLCompletionSettingsCollector.Companion.decorationOpinionProvided(MLCompletionSettingsCollector.DecorationOpinion.LIKE);
                    notification.expire();
                }
            });
            this.addAction((AnAction)new NotificationAction(MLCompletionBundle.message("ml.completion.notification.decorating.opinion.dislike", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    MLCompletionSettingsCollector.Companion.decorationOpinionProvided(MLCompletionSettingsCollector.DecorationOpinion.DISLIKE);
                    CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
                    completionMLRankingSettings.setShowDiffEnabled(false);
                    notification.expire();
                    new ArrowsDisabledNotification().notify(null);
                }
            });
            this.addAction((AnAction)new NotificationAction(MLCompletionBundle.message("ml.completion.notification.decorating.opinion.neutral", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    MLCompletionSettingsCollector.Companion.decorationOpinionProvided(MLCompletionSettingsCollector.DecorationOpinion.NEUTRAL);
                    notification.expire();
                }
            });
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/completion/ml/sorting/PositionDiffArrowInitializer$ArrowsDisabledNotification;", "Lcom/intellij/notification/Notification;", "()V", "intellij.completionMlRanking"})
    private static final class ArrowsDisabledNotification
    extends Notification {
        public ArrowsDisabledNotification() {
            super(MLCompletionBundle.message("ml.completion.notification.groupId", new Object[0]), MLCompletionBundle.message("ml.completion.notification.title", new Object[0]), MLCompletionBundle.message("ml.completion.notification.decorating.disabled.content", ShowSettingsUtil.getSettingsMenuName()), NotificationType.INFORMATION);
            this.addAction((AnAction)new NotificationAction(MLCompletionBundle.message("ml.completion.notification.decorating.disabled.configure", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    ShowSettingsUtil.getInstance().showSettingsDialog(null, CodeCompletionOptions.class);
                    notification.expire();
                }
            });
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rJ\b\u0010\u001c\u001a\u00020\rH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00100\u00100\f\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/completion/ml/sorting/PositionDiffArrowInitializer$Companion;", "", "()V", "ARROWS_NOTIFICATION_AFTER_SESSIONS", "", "ARROWS_NOTIFICATION_SHOWN_KEY", "", "DIFF_ICON_RIGHT_MARGIN", "EMPTY_DIFF_ICON", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "POSITION_CHANGED_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "POSITION_DIFF_KEY", "Ljava/util/concurrent/atomic/AtomicInteger;", "SHOW_ARROWS_NOTIFICATION_REGISTRY", "sessionsWithArrowsCounter", "itemPositionChanged", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "diffValue", "markAsReordered", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "value", "shouldShowArrowsNotification", "showArrowsNotificationIfNeeded", "language", "Lcom/intellij/lang/Language;", "intellij.completionMlRanking"})
    public static final class Companion {
        public final void markAsReordered(@NotNull LookupImpl lookup, boolean value) {
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            Boolean changed = (Boolean)lookup.getUserData(POSITION_CHANGED_KEY);
            if (changed == null) {
                lookup.putUserData(POSITION_CHANGED_KEY, (Object)value);
                Language language = LookupExtensionsKt.language(lookup);
                if (value && language != null) {
                    this.showArrowsNotificationIfNeeded(language);
                }
            }
        }

        public final void itemPositionChanged(@NotNull LookupElement element, int diffValue) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            AtomicInteger atomicInteger = (AtomicInteger)element.getUserData(POSITION_DIFF_KEY);
            if (atomicInteger == null) {
                AtomicInteger atomicInteger2 = new AtomicInteger();
                boolean bl = false;
                boolean bl2 = false;
                AtomicInteger $this$apply = atomicInteger2;
                boolean bl3 = false;
                element.putUserData(POSITION_DIFF_KEY, (Object)$this$apply);
                atomicInteger = atomicInteger2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)atomicInteger, (String)"element.getUserData(POSI\u2026OSITION_DIFF_KEY, this) }");
            AtomicInteger diff = atomicInteger;
            diff.set(diffValue);
        }

        private final boolean shouldShowArrowsNotification() {
            return Registry.is((String)PositionDiffArrowInitializer.SHOW_ARROWS_NOTIFICATION_REGISTRY, (boolean)true);
        }

        private final void showArrowsNotificationIfNeeded(Language language) {
            int sessionsCount;
            ExperimentInfo experimentInfo = ExperimentStatus.Companion.getInstance().forLanguage(language);
            if (experimentInfo.getInExperiment()) {
                return;
            }
            PropertiesComponent properties = PropertiesComponent.getInstance();
            CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
            CompletionMLRankingSettings mlRankingSettings = completionMLRankingSettings;
            if (mlRankingSettings.isShowDiffEnabled() && this.shouldShowArrowsNotification() && !properties.getBoolean(PositionDiffArrowInitializer.ARROWS_NOTIFICATION_SHOWN_KEY) && (sessionsCount = sessionsWithArrowsCounter.incrementAndGet()) == 50) {
                properties.setValue(PositionDiffArrowInitializer.ARROWS_NOTIFICATION_SHOWN_KEY, true);
                new ArrowsOpinionNotification().notify(null);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

