/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.bcpg;

import java.io.IOException;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.BCPGInputStream;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.InputStreamPacket;
import org.gradle.internal.impldep.org.bouncycastle.util.Arrays;
import org.gradle.internal.impldep.org.bouncycastle.util.Strings;

public class LiteralDataPacket
extends InputStreamPacket {
    int format;
    byte[] fileName;
    long modDate;

    LiteralDataPacket(BCPGInputStream bCPGInputStream) throws IOException {
        super(bCPGInputStream);
        this.format = bCPGInputStream.read();
        int n = bCPGInputStream.read();
        this.fileName = new byte[n];
        for (int i = 0; i != this.fileName.length; ++i) {
            int n2 = bCPGInputStream.read();
            if (n2 < 0) {
                throw new IOException("literal data truncated in header");
            }
            this.fileName[i] = (byte)n2;
        }
        this.modDate = (long)bCPGInputStream.read() << 24 | (long)(bCPGInputStream.read() << 16) | (long)(bCPGInputStream.read() << 8) | (long)bCPGInputStream.read();
        if (this.modDate < 0L) {
            throw new IOException("literal data truncated in header");
        }
    }

    public int getFormat() {
        return this.format;
    }

    public long getModificationTime() {
        return this.modDate * 1000L;
    }

    public String getFileName() {
        return Strings.fromUTF8ByteArray(this.fileName);
    }

    public byte[] getRawFileName() {
        return Arrays.clone(this.fileName);
    }
}

