/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.repository.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.maven.repository.internal.RemoteSnapshotMetadata;
import org.gradle.internal.impldep.org.sonatype.aether.ConfigurationProperties;
import org.gradle.internal.impldep.org.sonatype.aether.RepositorySystemSession;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact;
import org.gradle.internal.impldep.org.sonatype.aether.deployment.DeployRequest;
import org.gradle.internal.impldep.org.sonatype.aether.impl.MetadataGenerator;
import org.gradle.internal.impldep.org.sonatype.aether.metadata.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteSnapshotMetadataGenerator
implements MetadataGenerator {
    private final Map<Object, RemoteSnapshotMetadata> snapshots;
    private final boolean legacyFormat;

    public RemoteSnapshotMetadataGenerator(RepositorySystemSession session, DeployRequest request) {
        this.legacyFormat = ConfigurationProperties.get(session.getConfigProperties(), "maven.metadata.legacy", false);
        this.snapshots = new LinkedHashMap<Object, RemoteSnapshotMetadata>();
        for (Metadata metadata : request.getMetadata()) {
            if (!(metadata instanceof RemoteSnapshotMetadata)) continue;
            RemoteSnapshotMetadata snapshotMetadata = (RemoteSnapshotMetadata)metadata;
            this.snapshots.put(snapshotMetadata.getKey(), snapshotMetadata);
        }
    }

    @Override
    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!artifact.isSnapshot()) continue;
            Object key = RemoteSnapshotMetadata.getKey(artifact);
            RemoteSnapshotMetadata snapshotMetadata = this.snapshots.get(key);
            if (snapshotMetadata == null) {
                snapshotMetadata = new RemoteSnapshotMetadata(artifact, this.legacyFormat);
                this.snapshots.put(key, snapshotMetadata);
            }
            snapshotMetadata.bind(artifact);
        }
        return this.snapshots.values();
    }

    @Override
    public Artifact transformArtifact(Artifact artifact) {
        Object key;
        RemoteSnapshotMetadata snapshotMetadata;
        if (artifact.isSnapshot() && artifact.getVersion().equals(artifact.getBaseVersion()) && (snapshotMetadata = this.snapshots.get(key = RemoteSnapshotMetadata.getKey(artifact))) != null) {
            artifact = artifact.setVersion(snapshotMetadata.getExpandedVersion(artifact));
        }
        return artifact;
    }

    @Override
    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        return Collections.emptyList();
    }
}

