/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.esotericsoftware.kryo.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.util.Util;
import org.gradle.internal.impldep.com.esotericsoftware.minlog.Log;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsafeUtil {
    private static final Unsafe _unsafe;
    public static final long byteArrayBaseOffset;
    public static final long floatArrayBaseOffset;
    public static final long doubleArrayBaseOffset;
    public static final long intArrayBaseOffset;
    public static final long longArrayBaseOffset;
    public static final long shortArrayBaseOffset;
    public static final long charArrayBaseOffset;
    static Constructor<? extends ByteBuffer> directByteBufferConstr;

    public static final Unsafe unsafe() {
        return _unsafe;
    }

    public static Field[] sortFieldsByOffset(List<Field> allFields) {
        Field[] allFieldsArray = allFields.toArray(new Field[0]);
        Comparator<Field> fieldOffsetComparator = new Comparator<Field>(){

            @Override
            public int compare(Field f1, Field f2) {
                long offset2;
                long offset1 = UnsafeUtil.unsafe().objectFieldOffset(f1);
                if (offset1 < (offset2 = UnsafeUtil.unsafe().objectFieldOffset(f2))) {
                    return -1;
                }
                if (offset1 == offset2) {
                    return 0;
                }
                return 1;
            }
        };
        Arrays.sort(allFieldsArray, fieldOffsetComparator);
        for (Field f : allFields) {
            if (!Log.TRACE) continue;
            Log.trace("kryo", "Field '" + f.getName() + "' at offset " + UnsafeUtil.unsafe().objectFieldOffset(f));
        }
        return allFieldsArray;
    }

    public static final ByteBuffer getDirectBufferAt(long address, int size) {
        if (directByteBufferConstr == null) {
            return null;
        }
        try {
            return directByteBufferConstr.newInstance(address, size, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot allocate ByteBuffer at a given address: " + address, e);
        }
    }

    public static void releaseBuffer(ByteBuffer niobuffer) {
        if (niobuffer != null && niobuffer.isDirect()) {
            Cleaner cleaner = ((DirectBuffer)((Object)niobuffer)).cleaner();
            if (cleaner != null) {
                cleaner.clean();
            }
            niobuffer = null;
        }
    }

    static {
        long tmpCharArrayBaseOffset;
        long tmpShortArrayBaseOffset;
        long tmpLongArrayBaseOffset;
        long tmpIntArrayBaseOffset;
        long tmpDoubleArrayBaseOffset;
        long tmpFloatArrayBaseOffset;
        long tmpByteArrayBaseOffset;
        Unsafe tmpUnsafe;
        block7: {
            tmpUnsafe = null;
            tmpByteArrayBaseOffset = 0L;
            tmpFloatArrayBaseOffset = 0L;
            tmpDoubleArrayBaseOffset = 0L;
            tmpIntArrayBaseOffset = 0L;
            tmpLongArrayBaseOffset = 0L;
            tmpShortArrayBaseOffset = 0L;
            tmpCharArrayBaseOffset = 0L;
            try {
                if (!Util.isAndroid) {
                    Field field = Unsafe.class.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    tmpUnsafe = (Unsafe)field.get(null);
                    tmpByteArrayBaseOffset = tmpUnsafe.arrayBaseOffset(byte[].class);
                    tmpCharArrayBaseOffset = tmpUnsafe.arrayBaseOffset(char[].class);
                    tmpShortArrayBaseOffset = tmpUnsafe.arrayBaseOffset(short[].class);
                    tmpIntArrayBaseOffset = tmpUnsafe.arrayBaseOffset(int[].class);
                    tmpFloatArrayBaseOffset = tmpUnsafe.arrayBaseOffset(float[].class);
                    tmpLongArrayBaseOffset = tmpUnsafe.arrayBaseOffset(long[].class);
                    tmpDoubleArrayBaseOffset = tmpUnsafe.arrayBaseOffset(double[].class);
                } else if (Log.TRACE) {
                    Log.trace("kryo", "Running on Android platform. Use of sun.misc.Unsafe should be disabled");
                }
            }
            catch (Exception e) {
                if (!Log.TRACE) break block7;
                Log.trace("kryo", "sun.misc.Unsafe is not accessible or not available. Use of sun.misc.Unsafe should be disabled");
            }
        }
        byteArrayBaseOffset = tmpByteArrayBaseOffset;
        charArrayBaseOffset = tmpCharArrayBaseOffset;
        shortArrayBaseOffset = tmpShortArrayBaseOffset;
        intArrayBaseOffset = tmpIntArrayBaseOffset;
        floatArrayBaseOffset = tmpFloatArrayBaseOffset;
        longArrayBaseOffset = tmpLongArrayBaseOffset;
        doubleArrayBaseOffset = tmpDoubleArrayBaseOffset;
        _unsafe = tmpUnsafe;
        ByteBuffer buf = ByteBuffer.allocateDirect(1);
        try {
            directByteBufferConstr = buf.getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class);
            directByteBufferConstr.setAccessible(true);
        }
        catch (Exception e) {
            directByteBufferConstr = null;
        }
    }
}

