/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.s3;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.gradle.internal.impldep.com.amazonaws.AmazonServiceException;
import org.gradle.internal.impldep.com.amazonaws.ClientConfiguration;
import org.gradle.internal.impldep.com.amazonaws.SdkClientException;
import org.gradle.internal.impldep.com.amazonaws.annotation.SdkInternalApi;
import org.gradle.internal.impldep.com.amazonaws.auth.AWSCredentials;
import org.gradle.internal.impldep.com.amazonaws.auth.AWSCredentialsProvider;
import org.gradle.internal.impldep.com.amazonaws.auth.AnonymousAWSCredentials;
import org.gradle.internal.impldep.com.amazonaws.internal.StaticCredentialsProvider;
import org.gradle.internal.impldep.com.amazonaws.metrics.RequestMetricCollector;
import org.gradle.internal.impldep.com.amazonaws.regions.Region;
import org.gradle.internal.impldep.com.amazonaws.services.kms.AWSKMS;
import org.gradle.internal.impldep.com.amazonaws.services.kms.AWSKMSClient;
import org.gradle.internal.impldep.com.amazonaws.services.s3.AmazonS3Client;
import org.gradle.internal.impldep.com.amazonaws.services.s3.AmazonS3Encryption;
import org.gradle.internal.impldep.com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import org.gradle.internal.impldep.com.amazonaws.services.s3.AmazonS3EncryptionClientParams;
import org.gradle.internal.impldep.com.amazonaws.services.s3.UploadObjectObserver;
import org.gradle.internal.impldep.com.amazonaws.services.s3.internal.MultiFileOutputStream;
import org.gradle.internal.impldep.com.amazonaws.services.s3.internal.S3Direct;
import org.gradle.internal.impldep.com.amazonaws.services.s3.internal.crypto.CryptoModuleDispatcher;
import org.gradle.internal.impldep.com.amazonaws.services.s3.internal.crypto.S3CryptoModule;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.CopyPartRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.CopyPartResult;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.CryptoConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.DeleteObjectRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.EncryptedInitiateMultipartUploadRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.EncryptionMaterials;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.GetObjectRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.InstructionFileId;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ObjectMetadata;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.PartETag;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.PutInstructionFileRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.PutObjectRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.PutObjectResult;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.S3Object;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.S3ObjectId;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.UploadObjectRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.UploadPartRequest;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.UploadPartResult;
import org.gradle.internal.impldep.com.amazonaws.util.VersionInfoUtils;

public class AmazonS3EncryptionClient
extends AmazonS3Client
implements AmazonS3Encryption {
    public static final String USER_AGENT = AmazonS3EncryptionClient.class.getName() + "/" + VersionInfoUtils.getVersion();
    private final S3CryptoModule<?> crypto;
    private final AWSKMS kms;
    private final boolean isKMSClientInternal;

    @Deprecated
    public AmazonS3EncryptionClient(EncryptionMaterials encryptionMaterials) {
        this(new StaticEncryptionMaterialsProvider(encryptionMaterials));
    }

    @Deprecated
    public AmazonS3EncryptionClient(EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(new AnonymousAWSCredentials()), encryptionMaterialsProvider, configFactory.getConfig(), new CryptoConfiguration());
    }

    @Deprecated
    public AmazonS3EncryptionClient(EncryptionMaterials encryptionMaterials, CryptoConfiguration cryptoConfig) {
        this(new StaticEncryptionMaterialsProvider(encryptionMaterials), cryptoConfig);
    }

    @Deprecated
    public AmazonS3EncryptionClient(EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(new AnonymousAWSCredentials()), encryptionMaterialsProvider, configFactory.getConfig(), cryptoConfig);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentials credentials, EncryptionMaterials encryptionMaterials) {
        this(credentials, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials));
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentials credentials, EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this(credentials, encryptionMaterialsProvider, configFactory.getConfig(), new CryptoConfiguration());
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider) {
        this(credentialsProvider, encryptionMaterialsProvider, configFactory.getConfig(), new CryptoConfiguration());
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentials credentials, EncryptionMaterials encryptionMaterials, CryptoConfiguration cryptoConfig) {
        this(credentials, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials), cryptoConfig);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentials credentials, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        this(credentials, encryptionMaterialsProvider, configFactory.getConfig(), cryptoConfig);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        this(credentialsProvider, encryptionMaterialsProvider, configFactory.getConfig(), cryptoConfig);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentials credentials, EncryptionMaterials encryptionMaterials, ClientConfiguration clientConfig, CryptoConfiguration cryptoConfig) {
        this(credentials, (EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials), clientConfig, cryptoConfig);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentials credentials, EncryptionMaterialsProvider encryptionMaterialsProvider, ClientConfiguration clientConfig, CryptoConfiguration cryptoConfig) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(credentials), encryptionMaterialsProvider, clientConfig, cryptoConfig);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, ClientConfiguration clientConfig, CryptoConfiguration cryptoConfig) {
        this(credentialsProvider, kekMaterialsProvider, clientConfig, cryptoConfig, null);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, ClientConfiguration clientConfig, CryptoConfiguration cryptoConfig, RequestMetricCollector requestMetricCollector) {
        this(null, credentialsProvider, kekMaterialsProvider, clientConfig, cryptoConfig, requestMetricCollector);
    }

    @Deprecated
    public AmazonS3EncryptionClient(AWSKMSClient kms, AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, ClientConfiguration clientConfig, CryptoConfiguration cryptoConfig, RequestMetricCollector requestMetricCollector) {
        super(credentialsProvider, clientConfig, requestMetricCollector);
        this.assertParameterNotNull(kekMaterialsProvider, "EncryptionMaterialsProvider parameter must not be null.");
        this.assertParameterNotNull(cryptoConfig, "CryptoConfiguration parameter must not be null.");
        this.isKMSClientInternal = kms == null;
        this.kms = this.isKMSClientInternal ? this.newAWSKMSClient(credentialsProvider, clientConfig, cryptoConfig, requestMetricCollector) : kms;
        this.crypto = new CryptoModuleDispatcher(this.kms, new S3DirectImpl(), credentialsProvider, kekMaterialsProvider, cryptoConfig);
    }

    @SdkInternalApi
    AmazonS3EncryptionClient(AmazonS3EncryptionClientParams params) {
        super(params);
        this.assertParameterNotNull(params.getEncryptionMaterials(), "EncryptionMaterialsProvider parameter must not be null.");
        this.assertParameterNotNull(params.getCryptoConfiguration(), "CryptoConfiguration parameter must not be null.");
        this.isKMSClientInternal = params.getKmsClient() == null;
        this.kms = this.isKMSClientInternal ? this.newAWSKMSClient(params.getClientParams().getCredentialsProvider(), params.getClientParams().getClientConfiguration(), params.getCryptoConfiguration(), params.getClientParams().getRequestMetricCollector()) : params.getKmsClient();
        this.crypto = new CryptoModuleDispatcher(this.kms, new S3DirectImpl(), params.getClientParams().getCredentialsProvider(), params.getEncryptionMaterials(), params.getCryptoConfiguration());
    }

    public static AmazonS3EncryptionClientBuilder encryptionBuilder() {
        return AmazonS3EncryptionClientBuilder.standard();
    }

    private AWSKMSClient newAWSKMSClient(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfig, CryptoConfiguration cryptoConfig, RequestMetricCollector requestMetricCollector) {
        AWSKMSClient kmsClient = new AWSKMSClient(credentialsProvider, clientConfig, requestMetricCollector);
        Region kmsRegion = cryptoConfig.getAwsKmsRegion();
        if (kmsRegion != null) {
            kmsClient.setRegion(kmsRegion);
        }
        return kmsClient;
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest req) {
        return this.crypto.putObjectSecurely(req.clone());
    }

    @Override
    public S3Object getObject(GetObjectRequest req) {
        return this.crypto.getObjectSecurely(req);
    }

    @Override
    public ObjectMetadata getObject(GetObjectRequest req, File dest) {
        return this.crypto.getObjectSecurely(req, dest);
    }

    @Override
    public void deleteObject(DeleteObjectRequest req) {
        req.getRequestClientOptions().appendUserAgent(USER_AGENT);
        super.deleteObject(req);
        InstructionFileId ifid = new S3ObjectId(req.getBucketName(), req.getKey()).instructionFileId();
        DeleteObjectRequest instructionDeleteRequest = (DeleteObjectRequest)req.clone();
        instructionDeleteRequest.withBucketName(ifid.getBucket()).withKey(ifid.getKey());
        super.deleteObject(instructionDeleteRequest);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest req) {
        return this.crypto.completeMultipartUploadSecurely(req);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest req) {
        boolean isCreateEncryptionMaterial = true;
        if (req instanceof EncryptedInitiateMultipartUploadRequest) {
            EncryptedInitiateMultipartUploadRequest cryptoReq = (EncryptedInitiateMultipartUploadRequest)req;
            isCreateEncryptionMaterial = cryptoReq.isCreateEncryptionMaterial();
        }
        return isCreateEncryptionMaterial ? this.crypto.initiateMultipartUploadSecurely(req) : super.initiateMultipartUpload(req);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws SdkClientException, AmazonServiceException {
        return this.crypto.uploadPartSecurely(uploadPartRequest);
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
        return this.crypto.copyPartSecurely(copyPartRequest);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest req) {
        this.crypto.abortMultipartUploadSecurely(req);
    }

    public PutObjectResult putInstructionFile(PutInstructionFileRequest req) {
        return this.crypto.putInstructionFileSecurely(req);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.isKMSClientInternal) {
            this.kms.shutdown();
        }
    }

    @Override
    public CompleteMultipartUploadResult uploadObject(UploadObjectRequest req) throws IOException, InterruptedException, ExecutionException {
        UploadObjectObserver observer;
        boolean defaultExecutorService;
        ExecutorService es = req.getExecutorService();
        boolean bl = defaultExecutorService = es == null;
        if (es == null) {
            es = Executors.newFixedThreadPool(this.clientConfiguration.getMaxConnections());
        }
        if ((observer = req.getUploadObjectObserver()) == null) {
            observer = new UploadObjectObserver();
        }
        observer.init(req, new S3DirectImpl(), this, es);
        String uploadId = observer.onUploadInitiation(req);
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        MultiFileOutputStream mfos = req.getMultiFileOutputStream();
        if (mfos == null) {
            mfos = new MultiFileOutputStream();
        }
        try {
            mfos.init(observer, req.getPartSize(), req.getDiskLimit());
            this.crypto.putLocalObjectSecurely(req, uploadId, mfos);
            for (Future<UploadPartResult> future : observer.getFutures()) {
                UploadPartResult partResult = future.get();
                partETags.add(new PartETag(partResult.getPartNumber(), partResult.getETag()));
            }
        }
        catch (IOException ex) {
            throw this.onAbort(observer, ex);
        }
        catch (InterruptedException ex) {
            throw this.onAbort(observer, ex);
        }
        catch (ExecutionException ex) {
            throw this.onAbort(observer, ex);
        }
        catch (RuntimeException ex) {
            throw this.onAbort(observer, ex);
        }
        catch (Error ex) {
            throw this.onAbort(observer, ex);
        }
        finally {
            if (defaultExecutorService) {
                es.shutdownNow();
            }
            mfos.cleanup();
        }
        return observer.onCompletion(partETags);
    }

    private <T extends Throwable> T onAbort(UploadObjectObserver observer, T t) {
        observer.onAbort();
        return t;
    }

    private final class S3DirectImpl
    extends S3Direct {
        private S3DirectImpl() {
        }

        @Override
        public PutObjectResult putObject(PutObjectRequest req) {
            return AmazonS3EncryptionClient.super.putObject(req);
        }

        @Override
        public S3Object getObject(GetObjectRequest req) {
            return AmazonS3EncryptionClient.super.getObject(req);
        }

        @Override
        public ObjectMetadata getObject(GetObjectRequest req, File dest) {
            return AmazonS3EncryptionClient.super.getObject(req, dest);
        }

        @Override
        public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest req) {
            return AmazonS3EncryptionClient.super.completeMultipartUpload(req);
        }

        @Override
        public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest req) {
            return AmazonS3EncryptionClient.super.initiateMultipartUpload(req);
        }

        @Override
        public UploadPartResult uploadPart(UploadPartRequest req) throws SdkClientException, AmazonServiceException {
            return AmazonS3EncryptionClient.super.uploadPart(req);
        }

        @Override
        public CopyPartResult copyPart(CopyPartRequest req) {
            return AmazonS3EncryptionClient.super.copyPart(req);
        }

        @Override
        public void abortMultipartUpload(AbortMultipartUploadRequest req) {
            AmazonS3EncryptionClient.super.abortMultipartUpload(req);
        }
    }
}

