/*
 * Decompiled with CFR 0.152.
 */
package training.learn.interfaces;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.commands.kotlin.TaskTestContext;
import training.learn.interfaces.LessonType;
import training.learn.interfaces.Module;
import training.learn.lesson.LessonListener;
import training.learn.lesson.LessonState;
import training.learn.lesson.LessonStateManager;
import training.learn.lesson.kimpl.LessonProperties;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0013H\u0016J\u0010\u00100\u001a\u00020.2\u0006\u00101\u001a\u000202H\u0017J\b\u00103\u001a\u00020.H\u0016J\b\u00104\u001a\u00020.H\u0016J\b\u00105\u001a\u00020.H\u0016J\b\u00106\u001a\u00020.H\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\u00070\u0003\u00a2\u0006\u0002\b\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0005R\u0012\u0010\u000f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0005R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\u00070\u0003\u00a2\u0006\u0002\b\u001fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0005R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u00067"}, d2={"Ltraining/learn/interfaces/Lesson;", "", "existedFile", "", "getExistedFile", "()Ljava/lang/String;", "fileName", "getFileName", "helpLinks", "", "getHelpLinks", "()Ljava/util/Map;", "id", "Lorg/jetbrains/annotations/NonNls;", "getId", "lang", "getLang", "lessonListeners", "", "Ltraining/learn/lesson/LessonListener;", "getLessonListeners", "()Ljava/util/List;", "lessonType", "Ltraining/learn/interfaces/LessonType;", "getLessonType", "()Ltraining/learn/interfaces/LessonType;", "module", "Ltraining/learn/interfaces/Module;", "getModule", "()Ltraining/learn/interfaces/Module;", "name", "Lorg/jetbrains/annotations/Nls;", "getName", "passed", "", "getPassed", "()Z", "properties", "Ltraining/learn/lesson/kimpl/LessonProperties;", "getProperties", "()Ltraining/learn/lesson/kimpl/LessonProperties;", "testScriptProperties", "Ltraining/commands/kotlin/TaskTestContext$TestScriptProperties;", "getTestScriptProperties", "()Ltraining/commands/kotlin/TaskTestContext$TestScriptProperties;", "addLessonListener", "", "lessonListener", "cleanup", "project", "Lcom/intellij/openapi/project/Project;", "onPass", "onStart", "onStop", "pass", "intellij.featuresTrainer"})
public interface Lesson {
    @NotNull
    public String getName();

    @NotNull
    public String getId();

    @NotNull
    public String getFileName();

    @NotNull
    public Module getModule();

    @NotNull
    public LessonType getLessonType();

    public boolean getPassed();

    @NotNull
    public String getLang();

    @NotNull
    public List<LessonListener> getLessonListeners();

    @Nullable
    public String getExistedFile();

    public void addLessonListener(@NotNull LessonListener var1);

    public void onStart();

    public void onPass();

    public void onStop();

    @RequiresBackgroundThread
    public void cleanup(@NotNull Project var1);

    public void pass();

    @NotNull
    public Map<String, String> getHelpLinks();

    @NotNull
    public TaskTestContext.TestScriptProperties getTestScriptProperties();

    @NotNull
    public LessonProperties getProperties();

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static String getFileName(@NotNull Lesson $this) {
            StringBuilder stringBuilder = new StringBuilder().append($this.getModule().getSanitizedName()).append(".");
            Language language = UtilsKt.findLanguageByID($this.getLang());
            Intrinsics.checkNotNull((Object)language);
            LanguageFileType languageFileType = language.getAssociatedFileType();
            Intrinsics.checkNotNull((Object)languageFileType);
            Intrinsics.checkNotNullExpressionValue((Object)languageFileType, (String)"findLanguageByID(lang)!!.associatedFileType!!");
            return stringBuilder.append(languageFileType.getDefaultExtension()).toString();
        }

        @NotNull
        public static LessonType getLessonType(@NotNull Lesson $this) {
            return $this.getModule().getModuleType();
        }

        public static boolean getPassed(@NotNull Lesson $this) {
            return LessonStateManager.INSTANCE.getStateFromBase($this.getId()) == LessonState.PASSED;
        }

        @Nullable
        public static String getExistedFile(@NotNull Lesson $this) {
            return null;
        }

        public static void addLessonListener(@NotNull Lesson $this, @NotNull LessonListener lessonListener) {
            Intrinsics.checkNotNullParameter((Object)lessonListener, (String)"lessonListener");
            $this.getLessonListeners().add(lessonListener);
        }

        public static void onStart(@NotNull Lesson $this) {
            Iterable $this$forEach$iv = $this.getLessonListeners();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LessonListener it = (LessonListener)element$iv;
                boolean bl = false;
                it.lessonStarted($this);
            }
        }

        public static void onPass(@NotNull Lesson $this) {
            Iterable $this$forEach$iv = $this.getLessonListeners();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LessonListener it = (LessonListener)element$iv;
                boolean bl = false;
                it.lessonPassed($this);
            }
        }

        public static void onStop(@NotNull Lesson $this) {
            Iterable $this$forEach$iv = $this.getLessonListeners();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LessonListener it = (LessonListener)element$iv;
                boolean bl = false;
                it.lessonStopped($this);
            }
        }

        @RequiresBackgroundThread
        public static void cleanup(@NotNull Lesson $this, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        }

        public static void pass(@NotNull Lesson $this) {
            LessonStateManager.INSTANCE.setPassed($this);
            $this.onPass();
        }

        @NotNull
        public static Map<String, String> getHelpLinks(@NotNull Lesson $this) {
            return MapsKt.emptyMap();
        }

        @NotNull
        public static TaskTestContext.TestScriptProperties getTestScriptProperties(@NotNull Lesson $this) {
            return new TaskTestContext.TestScriptProperties(0, 1, null);
        }

        @NotNull
        public static LessonProperties getProperties(@NotNull Lesson $this) {
            return new LessonProperties(false, false, false, 7, null);
        }
    }
}

