/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.BootstrapBundle;
import com.intellij.ide.BootstrapClassLoaderUtil;
import com.intellij.ide.WindowsCommandLineProcessor;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.lang.JavaVersion;
import java.awt.AWTError;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class Main {
    public static final int NO_GRAPHICS = 1;
    public static final int RESTART_FAILED = 2;
    public static final int STARTUP_EXCEPTION = 3;
    public static final int JDK_CHECK_FAILED = 4;
    public static final int DIR_CHECK_FAILED = 5;
    public static final int INSTANCE_CHECK_FAILED = 6;
    public static final int LICENSE_ERROR = 7;
    public static final int PLUGIN_ERROR = 8;
    public static final int OUT_OF_MEMORY = 9;
    public static final int UNSUPPORTED_JAVA_VERSION = 10;
    public static final int PRIVACY_POLICY_REJECTION = 11;
    public static final int INSTALLATION_CORRUPTED = 12;
    public static final int ACTIVATE_WRONG_TOKEN_CODE = 13;
    public static final int ACTIVATE_NOT_INITIALIZED = 14;
    public static final int ACTIVATE_ERROR = 15;
    public static final int ACTIVATE_DISPOSING = 16;
    public static final String FORCE_PLUGIN_UPDATES = "idea.force.plugin.updates";
    private static final String AWT_HEADLESS = "java.awt.headless";
    private static final String PLATFORM_PREFIX_PROPERTY = "idea.platform.prefix";
    private static final String[] NO_ARGS = new String[0];
    private static final List<@NonNls String> HEADLESS_COMMANDS = Arrays.asList("ant", "duplocate", "dump-shared-index", "traverseUI", "buildAppcodeCache", "format", "keymap", "update", "inspections", "intentions", "rdserver-headless", "thinClient-headless");
    private static final List<@NonNls String> GUI_COMMANDS = Arrays.asList("diff", "merge");
    private static boolean isHeadless;
    private static boolean isCommandLine;
    private static boolean hasGraphics;
    private static boolean isLightEdit;

    private Main() {
    }

    public static void main(String[] args) {
        LinkedHashMap<@NonNls String, Long> startupTimings = new LinkedHashMap<String, Long>(6);
        startupTimings.put("startup begin", System.nanoTime());
        if (args.length == 1 && "%f".equals(args[0])) {
            args = NO_ARGS;
        }
        if (args.length == 1 && args[0].startsWith("jetbrains://")) {
            JetBrainsProtocolHandler.processJetBrainsLauncherParameters((String)args[0]);
            args = NO_ARGS;
        }
        Main.setFlags(args);
        if (!Main.isHeadless() && !Main.checkGraphics()) {
            System.exit(1);
        }
        try {
            if (!System.getProperty("java.version", "").startsWith("11.") && JavaVersion.current().feature < 11) {
                String baseName = System.getProperty(PLATFORM_PREFIX_PROPERTY, "idea").replace("AndroidStudio", "studio").replace("Edu", "");
                if (baseName.startsWith("Py")) {
                    baseName = "pycharm";
                } else if (baseName.equals("Ruby")) {
                    baseName = "rubymine";
                }
                @Nls StringBuilder message = new StringBuilder(BootstrapBundle.message("bootstrap.error.message.unsupported.jre", 11)).append('\n');
                int min = message.length();
                String javaHome = System.getProperty("java.home");
                if (javaHome.endsWith(File.separatorChar + "jre")) {
                    javaHome = javaHome.substring(0, javaHome.length() - 4);
                }
                boolean win = System.getProperty("os.name", "").startsWith("Windows");
                boolean x64 = "amd64".equals(System.getProperty("os.arch"));
                String envVar = baseName.toUpperCase(Locale.ENGLISH) + "_JDK" + (win && x64 ? "_64" : "");
                String envValue = System.getenv(envVar);
                if (envValue != null && Files.isSameFile(Paths.get(envValue, new String[0]), Paths.get(javaHome, new String[0]))) {
                    message.append(BootstrapBundle.message("bootstrap.error.message.unsupported.jre.env", envVar));
                } else {
                    String configPath = PathManager.getDefaultConfigPathFor((String)System.getProperty("idea.paths.selector", ""));
                    String suffix = win ? (x64 ? "64.exe" : ".exe") : "";
                    Path file = Paths.get(configPath, baseName.toLowerCase(Locale.ENGLISH) + suffix + ".jdk");
                    try {
                        Path jdkPath = Paths.get(new String(Files.readAllBytes(file), Charset.defaultCharset()), new String[0]);
                        if (Files.isSameFile(jdkPath, Paths.get(javaHome, new String[0]))) {
                            message.append(BootstrapBundle.message("bootstrap.error.message.unsupported.jre.file", file));
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (message.length() == min) {
                    message.append(BootstrapBundle.message("bootstrap.error.message.unsupported.jre.other", Main.supportUrl()));
                }
                message.append("\n\n").append(BootstrapBundle.message("bootstrap.error.message.jre.details", Main.jreDetails()));
                Main.showMessage(BootstrapBundle.message("bootstrap.error.title.unsupported.jre", new Object[0]), message.toString(), true);
                System.exit(10);
            }
            Main.bootstrap(args, startupTimings);
        }
        catch (Throwable t) {
            Main.showMessage(BootstrapBundle.message("bootstrap.error.title.start.failed", new Object[0]), t);
            System.exit(3);
        }
    }

    private static void bootstrap(String[] args, LinkedHashMap<@NonNls String, Long> startupTimings) throws Exception {
        boolean configImportNeeded;
        startupTimings.put("properties loading", System.nanoTime());
        PathManager.loadProperties();
        String configPath = PathManager.getConfigPath();
        boolean bl = configImportNeeded = !Main.isHeadless() && !Files.exists(Paths.get(configPath, new String[0]), new LinkOption[0]);
        if (!configImportNeeded) {
            Main.installPluginUpdates();
        }
        startupTimings.put("classloader init", System.nanoTime());
        ClassLoader newClassLoader = BootstrapClassLoaderUtil.initClassLoader();
        Thread.currentThread().setContextClassLoader(newClassLoader);
        startupTimings.put("MainRunner search", System.nanoTime());
        Class<?> klass = Class.forName("com.intellij.ide.plugins.MainRunner", true, newClassLoader);
        WindowsCommandLineProcessor.ourMainRunnerClass = klass;
        Method startMethod = klass.getMethod("start", String.class, String[].class, LinkedHashMap.class);
        startMethod.setAccessible(true);
        startMethod.invoke(null, Main.class.getName() + "Impl", args, startupTimings);
    }

    private static void installPluginUpdates() {
        if (Main.isCommandLine() && !Boolean.getBoolean(FORCE_PLUGIN_UPDATES)) {
            return;
        }
        try {
            StartupActionScriptManager.executeActionScript();
        }
        catch (IOException e) {
            Main.showMessage(BootstrapBundle.message("bootstrap.error.title.plugin.installation.error", new Object[0]), BootstrapBundle.message("bootstrap.error.message.plugin.installation.error", e.getMessage()), false);
        }
    }

    public static boolean isHeadless() {
        return isHeadless;
    }

    public static boolean isCommandLine() {
        return isCommandLine;
    }

    public static boolean isLightEdit() {
        return isLightEdit;
    }

    public static void setFlags(String @NotNull [] args) {
        if (args == null) {
            Main.$$$reportNull$$$0(0);
        }
        boolean bl = isCommandLine = (isHeadless = Main.isHeadless(args)) || args.length > 0 && GUI_COMMANDS.contains(args[0]);
        if (isHeadless) {
            System.setProperty(AWT_HEADLESS, Boolean.TRUE.toString());
        }
        isLightEdit = "LightEdit".equals(System.getProperty(PLATFORM_PREFIX_PROPERTY)) || !isCommandLine && Main.isFileAfterOptions(args);
    }

    private static boolean isFileAfterOptions(String @NotNull [] args) {
        if (args == null) {
            Main.$$$reportNull$$$0(1);
        }
        for (String arg : args) {
            if (!arg.startsWith("-")) {
                try {
                    Path path = Paths.get(arg, new String[0]);
                    return Files.isRegularFile(path, new LinkOption[0]) || !Files.exists(path, new LinkOption[0]);
                }
                catch (Throwable t) {
                    return false;
                }
            }
            if (!arg.equals("-l") && !arg.equals("--line") && !arg.equals("-c") && !arg.equals("--column")) continue;
            return true;
        }
        return false;
    }

    @TestOnly
    public static void setHeadlessInTestMode(boolean isHeadless) {
        Main.isHeadless = isHeadless;
        isCommandLine = true;
        isLightEdit = false;
    }

    public static boolean isHeadless(String @NotNull [] args) {
        if (args == null) {
            Main.$$$reportNull$$$0(2);
        }
        if (Boolean.getBoolean(AWT_HEADLESS)) {
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        String firstArg = args[0];
        return HEADLESS_COMMANDS.contains(firstArg) || firstArg.length() < 20 && firstArg.endsWith("inspect");
    }

    private static boolean checkGraphics() {
        if (GraphicsEnvironment.isHeadless()) {
            Main.showMessage(BootstrapBundle.message("bootstrap.error.title.startup.error", new Object[0]), BootstrapBundle.message("bootstrap.error.message.no.graphics.environment", new Object[0]), true);
            return false;
        }
        return true;
    }

    public static void showMessage(@Nls(capitalization=Nls.Capitalization.Title) String title, Throwable t) {
        @Nls(capitalization=Nls.Capitalization.Sentence) StringWriter message = new StringWriter();
        AWTError awtError = Main.findGraphicsError(t);
        if (awtError != null) {
            message.append(BootstrapBundle.message("bootstrap.error.message.failed.to.initialize.graphics.environment", new Object[0]));
            message.append("\n\n");
            hasGraphics = false;
            t = awtError;
        } else {
            message.append(BootstrapBundle.message("bootstrap.error.message.internal.error.please.refer.to.0", Main.supportUrl()));
            message.append("\n\n");
        }
        t.printStackTrace(new PrintWriter(message));
        message.append("\n-----\n").append(BootstrapBundle.message("bootstrap.error.message.jre.details", Main.jreDetails()));
        Main.showMessage(title, message.toString(), true);
    }

    private static AWTError findGraphicsError(Throwable t) {
        while (t != null) {
            if (t instanceof AWTError) {
                return (AWTError)t;
            }
            t = t.getCause();
        }
        return null;
    }

    @NlsSafe
    private static String jreDetails() {
        Properties sp = System.getProperties();
        String jre = sp.getProperty("java.runtime.version", sp.getProperty("java.version", "(unknown)"));
        String vendor = sp.getProperty("java.vendor", "(unknown vendor)");
        String arch = sp.getProperty("os.arch", "(unknown arch)");
        String home = sp.getProperty("java.home", "(unknown java.home)");
        return jre + ' ' + arch + " (" + vendor + ")\n" + home;
    }

    @NlsSafe
    private static String supportUrl() {
        boolean studio = "AndroidStudio".equalsIgnoreCase(System.getProperty(PLATFORM_PREFIX_PROPERTY));
        return studio ? "https://code.google.com/p/android/issues" : "https://jb.gg/ide/critical-startup-errors";
    }

    public static void showMessage(@Nls(capitalization=Nls.Capitalization.Title) String title, @Nls(capitalization=Nls.Capitalization.Sentence) String message, boolean error) {
        boolean headless;
        PrintStream stream = error ? System.err : System.out;
        stream.println();
        stream.println(title);
        stream.println(message);
        boolean bl = headless = !hasGraphics || Main.isCommandLine() || GraphicsEnvironment.isHeadless();
        if (headless) {
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            JTextPane textPane = new JTextPane();
            textPane.setEditable(false);
            textPane.setText(message.replaceAll("\t", "    "));
            textPane.setBackground(UIManager.getColor("Panel.background"));
            textPane.setCaretPosition(0);
            JScrollPane scrollPane = new JScrollPane(textPane, 20, 30);
            scrollPane.setBorder(null);
            int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height / 2;
            int maxWidth = Toolkit.getDefaultToolkit().getScreenSize().width / 2;
            Dimension component = scrollPane.getPreferredSize();
            if (component.height > maxHeight || component.width > maxWidth) {
                scrollPane.setPreferredSize(new Dimension(Math.min(maxWidth, component.width), Math.min(maxHeight, component.height)));
            }
            int type = error ? 0 : 2;
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), scrollPane, title, type);
        }
        catch (Throwable t) {
            stream.println();
            stream.println(BootstrapBundle.message("bootstrap.error.title.ui.exception.occurred.on.an.attempt.to.show.the.above.message", new Object[0]));
            t.printStackTrace(stream);
        }
    }

    static {
        hasGraphics = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "args";
        objectArray2[1] = "com/intellij/idea/Main";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setFlags";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileAfterOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isHeadless";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

