/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;

public class JavaSourceRootDescriptor
extends BuildRootDescriptor {
    @NotNull
    public final File root;
    @NotNull
    public final ModuleBuildTarget target;
    public final boolean isGeneratedSources;
    public final boolean isTemp;
    private final String myPackagePrefix;
    private final Set<File> myExcludes;

    public JavaSourceRootDescriptor(@NotNull File root, @NotNull ModuleBuildTarget target, boolean isGenerated, boolean isTemp, @NotNull String packagePrefix, @NotNull Set<File> excludes) {
        if (root == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(0);
        }
        if (target == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(1);
        }
        if (packagePrefix == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(2);
        }
        if (excludes == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(3);
        }
        this.root = root;
        this.target = target;
        this.isGeneratedSources = isGenerated;
        this.isTemp = isTemp;
        this.myPackagePrefix = packagePrefix;
        this.myExcludes = excludes;
    }

    public String toString() {
        return "RootDescriptor{target='" + this.target + '\'' + ", root=" + this.root + ", generated=" + this.isGeneratedSources + '}';
    }

    @Override
    @NotNull
    public Set<File> getExcludedRoots() {
        Set<File> set = this.myExcludes;
        if (set == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public String getPackagePrefix() {
        String string = this.myPackagePrefix;
        if (string == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public String getRootId() {
        return FileUtil.toSystemIndependentName((String)this.root.getPath());
    }

    @Override
    public File getRootFile() {
        return this.root;
    }

    public ModuleBuildTarget getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public FileFilter createFileFilter() {
        JpsCompilerExcludes excludes = JpsJavaExtensionService.getInstance().getCompilerConfiguration(this.target.getModule().getProject()).getCompilerExcludes();
        FileFilter baseFilter = BuilderRegistry.getInstance().getModuleBuilderFileFilter();
        FileFilter fileFilter = file -> baseFilter.accept(file) && !excludes.isExcluded(file);
        if (fileFilter == null) {
            JavaSourceRootDescriptor.$$$reportNull$$$0(6);
        }
        return fileFilter;
    }

    @Override
    public boolean isGenerated() {
        return this.isGeneratedSources;
    }

    @Override
    public boolean canUseFileCache() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/java/JavaSourceRootDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/java/JavaSourceRootDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagePrefix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

