/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.testFramework.JavaProjectTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.util.Consumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaModuleTestCase
extends JavaProjectTestCase {
    protected final Collection<Module> myModulesToDispose = new ArrayList<Module>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myModulesToDispose.clear();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (!this.myModulesToDispose.isEmpty()) {
                WriteAction.run(() -> {
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
                    for (Module module : this.myModulesToDispose) {
                        try {
                            String moduleName = module.getName();
                            if (moduleManager.findModuleByName(moduleName) == null) continue;
                            moduleManager.disposeModule(module);
                        }
                        catch (Throwable e) {
                            this.addSuppressedException(e);
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            this.myModulesToDispose.clear();
            super.tearDown();
        }
    }

    @NotNull
    protected Module createModule(@NotNull Path moduleFile) {
        if (moduleFile == null) {
            JavaModuleTestCase.$$$reportNull$$$0(0);
        }
        Module module = this.createModule(moduleFile, StdModuleTypes.JAVA);
        if (module == null) {
            JavaModuleTestCase.$$$reportNull$$$0(1);
        }
        return module;
    }

    @NotNull
    protected Module createModule(@NotNull Path moduleFile, @NotNull ModuleType<?> moduleType) {
        if (moduleFile == null) {
            JavaModuleTestCase.$$$reportNull$$$0(2);
        }
        if (moduleType == null) {
            JavaModuleTestCase.$$$reportNull$$$0(3);
        }
        Module module = (Module)WriteAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).newModule(moduleFile, moduleType.getId()));
        this.myModulesToDispose.add(module);
        Module module2 = module;
        if (module2 == null) {
            JavaModuleTestCase.$$$reportNull$$$0(4);
        }
        return module2;
    }

    @NotNull
    protected Module createModule(@NotNull String path, @NotNull ModuleType<?> moduleType) {
        if (path == null) {
            JavaModuleTestCase.$$$reportNull$$$0(5);
        }
        if (moduleType == null) {
            JavaModuleTestCase.$$$reportNull$$$0(6);
        }
        Module module = (Module)WriteAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).newModule(path, moduleType.getId()));
        this.myModulesToDispose.add(module);
        Module module2 = module;
        if (module2 == null) {
            JavaModuleTestCase.$$$reportNull$$$0(7);
        }
        return module2;
    }

    @NotNull
    protected Module loadModule(@NotNull VirtualFile file) {
        if (file == null) {
            JavaModuleTestCase.$$$reportNull$$$0(8);
        }
        return this.loadModule(file.toNioPath());
    }

    @NotNull
    protected final Module loadModule(@NotNull Path modulePath) {
        Module module;
        if (modulePath == null) {
            JavaModuleTestCase.$$$reportNull$$$0(9);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        try {
            module = (Module)ApplicationManager.getApplication().runWriteAction(() -> moduleManager.loadModule(modulePath));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.myModulesToDispose.add(module);
        Module module2 = module;
        if (module2 == null) {
            JavaModuleTestCase.$$$reportNull$$$0(10);
        }
        return module2;
    }

    @Nullable
    protected Module loadAllModulesUnder(@NotNull VirtualFile rootDir) {
        if (rootDir == null) {
            JavaModuleTestCase.$$$reportNull$$$0(11);
        }
        return this.loadAllModulesUnder(rootDir, null);
    }

    @Nullable
    protected Module loadAllModulesUnder(@NotNull VirtualFile rootDir, final @Nullable Consumer<? super Module> moduleConsumer) {
        if (rootDir == null) {
            JavaModuleTestCase.$$$reportNull$$$0(12);
        }
        final Ref result = Ref.create();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)rootDir, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file.isDirectory() && file.getName().endsWith(".iml")) {
                    Module module = JavaModuleTestCase.this.loadModule(file);
                    if (moduleConsumer != null) {
                        moduleConsumer.consume((Object)module);
                    }
                    result.setIfNull((Object)module);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/JavaModuleTestCase$1", "visitFile"));
            }
        });
        return (Module)result.get();
    }

    @NotNull
    protected final Module createModuleFromTestData(@NotNull String dirInTestData, @NotNull String newModuleFileName, @NotNull ModuleType<?> moduleType, boolean addSourceRoot) throws IOException {
        if (dirInTestData == null) {
            JavaModuleTestCase.$$$reportNull$$$0(13);
        }
        if (newModuleFileName == null) {
            JavaModuleTestCase.$$$reportNull$$$0(14);
        }
        if (moduleType == null) {
            JavaModuleTestCase.$$$reportNull$$$0(15);
        }
        VirtualFile moduleDir = this.getTempDir().createVirtualDir();
        FileUtil.copyDir((File)new File(dirInTestData), (File)moduleDir.toNioPath().toFile());
        moduleDir.refresh(false, true);
        Module module = this.createModule(moduleDir.toNioPath().resolve(newModuleFileName), moduleType);
        if (addSourceRoot) {
            PsiTestUtil.addSourceContentToRoots((Module)module, (VirtualFile)moduleDir);
        } else {
            PsiTestUtil.addContentRoot((Module)module, (VirtualFile)moduleDir);
        }
        Module module2 = module;
        if (module2 == null) {
            JavaModuleTestCase.$$$reportNull$$$0(16);
        }
        return module2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/JavaModuleTestCase";
                break;
            }
            case 3: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirInTestData";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModuleFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/JavaModuleTestCase";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModule";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleFromTestData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadModule";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadAllModulesUnder";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createModuleFromTestData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

