/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.decompose;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.DominatorEngine;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.DominatorTreeExceptionFilter;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.FastFixedSetFactory;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class FastExtendedPostdominanceHelper {
    private List<Statement> lstReversePostOrderList;
    private HashMap<Integer, FastFixedSetFactory.FastFixedSet<Integer>> mapSupportPoints = new HashMap();
    private final HashMap<Integer, FastFixedSetFactory.FastFixedSet<Integer>> mapExtPostdominators = new HashMap();
    private Statement statement;
    private FastFixedSetFactory<Integer> factory;

    public HashMap<Integer, Set<Integer>> getExtendedPostdominators(Statement statement) {
        this.statement = statement;
        HashSet<Integer> set = new HashSet<Integer>();
        for (Statement st : statement.getStats()) {
            set.add(st.id);
        }
        this.factory = new FastFixedSetFactory(set);
        this.lstReversePostOrderList = statement.getReversePostOrderList();
        this.calcDefaultReachableSets();
        this.removeErroneousNodes();
        DominatorTreeExceptionFilter filter = new DominatorTreeExceptionFilter(statement);
        filter.initialize();
        this.filterOnExceptionRanges(filter);
        this.filterOnDominance(filter);
        Set<Map.Entry<Integer, FastFixedSetFactory.FastFixedSet<Integer>>> entries = this.mapExtPostdominators.entrySet();
        HashMap<Integer, Set<Integer>> res = new HashMap<Integer, Set<Integer>>(entries.size());
        for (Map.Entry<Integer, FastFixedSetFactory.FastFixedSet<Integer>> entry : entries) {
            res.put(entry.getKey(), entry.getValue().toPlainSet());
        }
        return res;
    }

    private void filterOnDominance(DominatorTreeExceptionFilter filter) {
        DominatorEngine engine = filter.getDomEngine();
        for (Integer head : new HashSet<Integer>(this.mapExtPostdominators.keySet())) {
            FastFixedSetFactory.FastFixedSet<Integer> setPostdoms = this.mapExtPostdominators.get(head);
            LinkedList<Statement> stack = new LinkedList<Statement>();
            LinkedList stackPath = new LinkedList();
            stack.add(this.statement.getStats().getWithKey(head));
            stackPath.add(this.factory.spawnEmptySet());
            HashSet<Statement> setVisited = new HashSet<Statement>();
            setVisited.add((Statement)stack.getFirst());
            while (!stack.isEmpty()) {
                Statement stat = (Statement)stack.removeFirst();
                FastFixedSetFactory.FastFixedSet path = (FastFixedSetFactory.FastFixedSet)stackPath.removeFirst();
                if (setPostdoms.contains(stat.id)) {
                    path.add(stat.id);
                }
                if (path.contains(setPostdoms)) continue;
                if (!engine.isDominator(stat.id, head)) {
                    setPostdoms.complement(path);
                    continue;
                }
                for (StatEdge edge : stat.getSuccessorEdges(1)) {
                    Statement edge_destination = edge.getDestination();
                    if (setVisited.contains(edge_destination)) continue;
                    stack.add(edge_destination);
                    stackPath.add(path.getCopy());
                    setVisited.add(edge_destination);
                }
            }
            if (!setPostdoms.isEmpty()) continue;
            this.mapExtPostdominators.remove(head);
        }
    }

    private void filterOnExceptionRanges(DominatorTreeExceptionFilter filter) {
        for (Integer head : new HashSet<Integer>(this.mapExtPostdominators.keySet())) {
            FastFixedSetFactory.FastFixedSet<Integer> set = this.mapExtPostdominators.get(head);
            Iterator<Integer> it = set.iterator();
            while (it.hasNext()) {
                if (filter.acceptStatementPair(head, it.next())) continue;
                it.remove();
            }
            if (!set.isEmpty()) continue;
            this.mapExtPostdominators.remove(head);
        }
    }

    private void removeErroneousNodes() {
        this.mapSupportPoints = new HashMap();
        this.calcReachabilitySuppPoints(1);
        this.iterateReachability((node, mapSets) -> {
            Integer nodeid = node.id;
            FastFixedSetFactory.FastFixedSet setReachability = (FastFixedSetFactory.FastFixedSet)mapSets.get(nodeid);
            ArrayList<FastFixedSetFactory.FastFixedSet<Integer>> lstPredSets = new ArrayList<FastFixedSetFactory.FastFixedSet<Integer>>();
            for (StatEdge prededge : node.getPredecessorEdges(1)) {
                FastFixedSetFactory.FastFixedSet<Integer> setPred = (FastFixedSetFactory.FastFixedSet<Integer>)mapSets.get(prededge.getSource().id);
                if (setPred == null) {
                    setPred = this.mapSupportPoints.get(prededge.getSource().id);
                }
                lstPredSets.add(setPred);
            }
            for (Integer id : setReachability) {
                FastFixedSetFactory.FastFixedSet<Integer> setReachabilityCopy = setReachability.getCopy();
                FastFixedSetFactory.FastFixedSet<Integer> setIntersection = this.factory.spawnEmptySet();
                boolean isIntersectionInitialized = false;
                for (FastFixedSetFactory.FastFixedSet fastFixedSet : lstPredSets) {
                    if (!fastFixedSet.contains(id)) continue;
                    if (!isIntersectionInitialized) {
                        setIntersection.union(fastFixedSet);
                        isIntersectionInitialized = true;
                        continue;
                    }
                    setIntersection.intersection(fastFixedSet);
                }
                if (nodeid.intValue() != id.intValue()) {
                    setIntersection.add(nodeid);
                } else {
                    setIntersection.remove(nodeid);
                }
                setReachabilityCopy.complement(setIntersection);
                this.mapExtPostdominators.get(id).complement(setReachabilityCopy);
            }
            return false;
        }, 1);
        FastFixedSetFactory.FastFixedSet<Integer> setHandlers = this.factory.spawnEmptySet();
        boolean handlerfound = false;
        for (Statement statement : this.statement.getStats()) {
            if (!statement.getPredecessorEdges(0x40000000).isEmpty() || statement.getPredecessorEdges(2).isEmpty()) continue;
            setHandlers.add(statement.id);
            handlerfound = true;
        }
        if (handlerfound) {
            for (FastFixedSetFactory.FastFixedSet fastFixedSet : this.mapExtPostdominators.values()) {
                fastFixedSet.complement(setHandlers);
            }
        }
    }

    private void calcDefaultReachableSets() {
        int edgetype = 3;
        this.calcReachabilitySuppPoints(edgetype);
        for (Statement stat : this.statement.getStats()) {
            this.mapExtPostdominators.put(stat.id, this.factory.spawnEmptySet());
        }
        this.iterateReachability((node, mapSets) -> {
            Integer nodeid = node.id;
            FastFixedSetFactory.FastFixedSet setReachability = (FastFixedSetFactory.FastFixedSet)mapSets.get(nodeid);
            for (Integer id : setReachability) {
                this.mapExtPostdominators.get(id).add(nodeid);
            }
            return false;
        }, edgetype);
    }

    private void calcReachabilitySuppPoints(int edgetype) {
        this.iterateReachability((node, mapSets) -> {
            for (StatEdge sucedge : node.getAllSuccessorEdges()) {
                FastFixedSetFactory.FastFixedSet setReachability;
                if ((sucedge.getType() & edgetype) == 0 || !mapSets.containsKey(sucedge.getDestination().id) || InterpreterUtil.equalObjects(setReachability = (FastFixedSetFactory.FastFixedSet)mapSets.get(node.id), this.mapSupportPoints.get(node.id))) continue;
                this.mapSupportPoints.put(node.id, setReachability);
                return true;
            }
            return false;
        }, edgetype);
    }

    private void iterateReachability(IReachabilityAction action, int edgetype) {
        boolean iterate;
        do {
            iterate = false;
            HashMap<Integer, FastFixedSetFactory.FastFixedSet<Integer>> mapSets = new HashMap<Integer, FastFixedSetFactory.FastFixedSet<Integer>>();
            for (Statement stat : this.lstReversePostOrderList) {
                Statement pred;
                FastFixedSetFactory.FastFixedSet<Integer> set = this.factory.spawnEmptySet();
                set.add(stat.id);
                for (StatEdge prededge : stat.getAllPredecessorEdges()) {
                    if ((prededge.getType() & edgetype) == 0) continue;
                    pred = prededge.getSource();
                    FastFixedSetFactory.FastFixedSet<Integer> setPred = mapSets.get(pred.id);
                    if (setPred == null) {
                        setPred = this.mapSupportPoints.get(pred.id);
                    }
                    if (setPred == null) continue;
                    set.union(setPred);
                }
                mapSets.put(stat.id, set);
                if (action != null) {
                    iterate |= action.action(stat, mapSets);
                }
                for (StatEdge prededge : stat.getAllPredecessorEdges()) {
                    if ((prededge.getType() & edgetype) == 0) continue;
                    pred = prededge.getSource();
                    if (!mapSets.containsKey(pred.id)) continue;
                    boolean remstat = true;
                    for (StatEdge sucedge : pred.getAllSuccessorEdges()) {
                        if ((sucedge.getType() & edgetype) == 0 || mapSets.containsKey(sucedge.getDestination().id)) continue;
                        remstat = false;
                        break;
                    }
                    if (!remstat) continue;
                    mapSets.put(pred.id, null);
                }
            }
        } while (iterate);
    }

    private static interface IReachabilityAction {
        public boolean action(Statement var1, HashMap<Integer, FastFixedSetFactory.FastFixedSet<Integer>> var2);
    }
}

