/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.run;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.intellij.lang.xpath.xslt.run.XsltRunConfiguration;
import org.intellij.lang.xpath.xslt.run.XsltRunnerExtension;
import org.intellij.plugins.xpathView.XPathBundle;
import org.intellij.plugins.xslt.run.rt.XSLTMain;
import org.jetbrains.annotations.NotNull;

public class XsltCommandLineState
extends CommandLineState {
    public static final Key<XsltCommandLineState> STATE = Key.create((String)"STATE");
    private final XsltRunConfiguration myXsltRunConfiguration;
    private final boolean myIsDebugger;
    private int myPort;
    private UserDataHolder myExtensionData;

    public XsltCommandLineState(XsltRunConfiguration xsltRunConfiguration, ExecutionEnvironment environment) {
        super(environment);
        this.myXsltRunConfiguration = xsltRunConfiguration;
        this.myIsDebugger = "Debug".equals(environment.getExecutor().getId());
    }

    public boolean isDebugger() {
        return this.myIsDebugger;
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler osProcessHandler = this.createJavaParameters().createOSProcessHandler();
        osProcessHandler.putUserData(STATE, (Object)this);
        osProcessHandler.addProcessListener((ProcessListener)new MyProcessAdapter());
        List<XsltRunnerExtension> extensions = XsltRunnerExtension.getExtensions(this.myXsltRunConfiguration, this.myIsDebugger);
        for (XsltRunnerExtension extension : extensions) {
            osProcessHandler.addProcessListener(extension.createProcessListener(this.myXsltRunConfiguration.getProject(), this.myExtensionData));
        }
        OSProcessHandler oSProcessHandler = osProcessHandler;
        if (oSProcessHandler == null) {
            XsltCommandLineState.$$$reportNull$$$0(0);
        }
        return oSProcessHandler;
    }

    protected SimpleJavaParameters createJavaParameters() throws ExecutionException {
        Module module;
        Sdk jdk = this.myXsltRunConfiguration.getEffectiveJDK();
        if (jdk == null) {
            throw CantRunException.noJdkConfigured();
        }
        SimpleJavaParameters parameters = new SimpleJavaParameters();
        parameters.setJdk(jdk);
        if (this.myXsltRunConfiguration.getJdkChoice() == XsltRunConfiguration.JdkChoice.FROM_MODULE && (module = this.myXsltRunConfiguration.getEffectiveModule()) != null) {
            OrderEnumerator.orderEntries((Module)module).productionOnly().recursively().classes().collectPaths(parameters.getClassPath());
        }
        ParametersList vmParameters = parameters.getVMParametersList();
        vmParameters.addParametersString(this.myXsltRunConfiguration.myVmArguments);
        if (XsltRunConfiguration.isEmpty(this.myXsltRunConfiguration.getXsltFile())) {
            throw new CantRunException(XPathBundle.message("dialog.message.no.xslt.file.selected", new Object[0]));
        }
        vmParameters.defineProperty("xslt.file", this.myXsltRunConfiguration.getXsltFile());
        if (XsltRunConfiguration.isEmpty(this.myXsltRunConfiguration.getXmlInputFile())) {
            throw new CantRunException(XPathBundle.message("dialog.message.no.xml.input.file.selected", new Object[0]));
        }
        vmParameters.defineProperty("xslt.input", this.myXsltRunConfiguration.getXmlInputFile());
        XsltRunConfiguration.OutputType outputType = this.myXsltRunConfiguration.getOutputType();
        if (outputType == XsltRunConfiguration.OutputType.CONSOLE) {
            this.myPort = NetUtils.tryToFindAvailableSocketPort((int)this.myXsltRunConfiguration.myRunnerPort);
            vmParameters.defineProperty("xslt.listen-port", String.valueOf(this.myPort));
        }
        if (this.myXsltRunConfiguration.isSaveToFile()) {
            vmParameters.defineProperty("xslt.output", this.myXsltRunConfiguration.myOutputFile);
        }
        for (Pair<String, String> pair : this.myXsltRunConfiguration.getParameters()) {
            String name = (String)pair.getFirst();
            String value = (String)pair.getSecond();
            if (XsltRunConfiguration.isEmpty(name) || value == null) continue;
            vmParameters.defineProperty("xslt.param." + name, value);
        }
        vmParameters.defineProperty("xslt.smart-error-handling", String.valueOf(this.myXsltRunConfiguration.mySmartErrorHandling));
        PluginId pluginId = PluginManagerCore.getPluginByClassName((String)((Object)((Object)this)).getClass().getName());
        if (pluginId != null) {
            IdeaPluginDescriptor descriptor = PluginManagerCore.getPlugin((PluginId)pluginId);
            assert (descriptor != null);
            Path rtPath = descriptor.getPluginPath().resolve("lib/rt/xslt-rt.jar");
            if (!Files.exists(rtPath, new LinkOption[0])) {
                throw new CantRunException(XPathBundle.message("dialog.message.runtime.classes.not.found.at", rtPath));
            }
            parameters.getClassPath().addTail(rtPath.toAbsolutePath().toString());
        } else {
            String rtPath = PathManager.getJarPathForClass(XSLTMain.class);
            if (rtPath == null) {
                throw new CantRunException(XPathBundle.message("dialog.message.cannot.find.runtime.classes.on.classpath", new Object[0]));
            }
            parameters.getClassPath().addTail(rtPath);
            parameters.getVMParametersList().prepend("-ea");
        }
        parameters.setMainClass("org.intellij.plugins.xslt.run.rt.XSLTRunner");
        if (XsltRunConfiguration.isEmpty(this.myXsltRunConfiguration.myWorkingDirectory)) {
            parameters.setWorkingDirectory(new File(this.myXsltRunConfiguration.getXsltFile()).getParentFile());
        } else {
            parameters.setWorkingDirectory(XsltCommandLineState.expandPath(this.myXsltRunConfiguration.myWorkingDirectory, this.myXsltRunConfiguration.getEffectiveModule(), this.myXsltRunConfiguration.getProject()));
        }
        this.myExtensionData = new UserDataHolderBase();
        List<XsltRunnerExtension> extensions = XsltRunnerExtension.getExtensions(this.myXsltRunConfiguration, this.myIsDebugger);
        for (XsltRunnerExtension extension : extensions) {
            extension.patchParameters(parameters, this.myXsltRunConfiguration, this.myExtensionData);
        }
        parameters.setUseDynamicClasspath(this.myXsltRunConfiguration.getProject());
        return parameters;
    }

    protected static String expandPath(String path, Module module, Project project) {
        path = PathMacroManager.getInstance((ComponentManager)project).expandPath(path);
        if (module != null) {
            path = PathMacroManager.getInstance((ComponentManager)module).expandPath(path);
        }
        return path;
    }

    public int getPort() {
        return this.myPort;
    }

    public UserDataHolder getExtensionData() {
        return this.myExtensionData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/run/XsltCommandLineState", "startProcess"));
    }

    private class MyProcessAdapter
    extends ProcessAdapter {
        private MyProcessAdapter() {
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                MyProcessAdapter.$$$reportNull$$$0(0);
            }
            if (XsltCommandLineState.this.myXsltRunConfiguration.isSaveToFile()) {
                ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                    if (event.getExitCode() == 0) {
                        VirtualFile file;
                        if (XsltCommandLineState.this.myXsltRunConfiguration.myOpenInBrowser) {
                            BrowserUtil.browse((String)XsltCommandLineState.this.myXsltRunConfiguration.myOutputFile);
                        }
                        if (XsltCommandLineState.this.myXsltRunConfiguration.myOpenOutputFile && (file = LocalFileSystem.getInstance().refreshAndFindFileByPath(XsltCommandLineState.this.myXsltRunConfiguration.myOutputFile)) != null) {
                            file.refresh(false, false);
                            PsiNavigationSupport.getInstance().createNavigatable(XsltCommandLineState.this.myXsltRunConfiguration.getProject(), file, -1).navigate(true);
                            return;
                        }
                        VirtualFileManager.getInstance().asyncRefresh(null);
                    }
                }));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/lang/xpath/xslt/run/XsltCommandLineState$MyProcessAdapter", "processTerminated"));
        }
    }
}

