/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclarationModifierList;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertLateinitPropertyToNotNullDelegateFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "type", "", "(Lorg/jetbrains/kotlin/psi/KtProperty;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class ConvertLateinitPropertyToNotNullDelegateFix
extends KotlinQuickFixAction<KtProperty> {
    private final String type;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return KotlinBundle.message("convert.to.notnull.delegate", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtProperty ktProperty = (KtProperty)this.getElement();
        if (ktProperty == null) {
            return;
        }
        KtProperty property2 = ktProperty;
        KtTypeReference ktTypeReference = property2.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"property.typeReference ?: return");
        KtTypeReference typeReference = ktTypeReference;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)property2), (boolean)false, (int)2, null);
        property2.removeModifier(KtTokens.LATEINIT_KEYWORD);
        KtPropertyDelegate propertyDelegate = psiFactory.createPropertyDelegate(psiFactory.createExpression("kotlin.properties.Delegates.notNull<" + this.type + ">()"));
        property2.addAfter((PsiElement)propertyDelegate, (PsiElement)typeReference);
        property2.setTypeReference((KtTypeReference)null);
        ShortenReferences.process$default((ShortenReferences)ShortenReferences.DEFAULT, (KtElement)((KtElement)property2), null, (int)2, null);
    }

    public ConvertLateinitPropertyToNotNullDelegateFix(@NotNull KtProperty property2, @NotNull String type2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        super((PsiElement)property2);
        this.type = type2;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertLateinitPropertyToNotNullDelegateFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected KotlinQuickFixAction<KtProperty> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiElement psiElement3 = psiElement2.getParent();
            if (!(psiElement3 instanceof KtDeclarationModifierList)) {
                psiElement3 = null;
            }
            KtDeclarationModifierList ktDeclarationModifierList = (KtDeclarationModifierList)psiElement3;
            if (ktDeclarationModifierList == null) {
                return null;
            }
            KtDeclarationModifierList modifierList = ktDeclarationModifierList;
            PsiElement psiElement4 = modifierList.getParent();
            if (!(psiElement4 instanceof KtProperty)) {
                psiElement4 = null;
            }
            KtProperty ktProperty = (KtProperty)psiElement4;
            if (ktProperty == null) {
                return null;
            }
            KtProperty property2 = ktProperty;
            if (!property2.hasModifier(KtTokens.LATEINIT_KEYWORD) || !property2.isVar() || property2.hasInitializer()) {
                return null;
            }
            KtTypeReference ktTypeReference = property2.getTypeReference();
            if (ktTypeReference == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"property.typeReference ?: return null");
            KtTypeReference typeReference = ktTypeReference;
            KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)((KtElement)property2), (BodyResolveMode)BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference);
            if (kotlinType == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"property.analyze(BodyRes\u2026Reference] ?: return null");
            KotlinType type2 = kotlinType;
            if (!KotlinBuiltIns.isPrimitiveType((KotlinType)type2)) {
                return null;
            }
            return new ConvertLateinitPropertyToNotNullDelegateFix(property2, type2.toString());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

