/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.TestDataPath;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.GotoTestDataAction;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class TestDataLineMarkerProvider
extends RunLineMarkerContributor {
    public static final String TEST_DATA_PATH_ANNOTATION_QUALIFIED_NAME = TestDataPath.class.getCanonicalName();
    public static final String CONTENT_ROOT_VARIABLE = "$CONTENT_ROOT";
    public static final String PROJECT_ROOT_VARIABLE = "$PROJECT_ROOT";

    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement e) {
        UElement uElement;
        if (e == null) {
            TestDataLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (!((uElement = UastUtils.getUParentForIdentifier((PsiElement)e)) instanceof UMethod) && !(uElement instanceof UClass)) {
            return null;
        }
        Project project = e.getProject();
        if (DumbService.isDumb((Project)project) || !PsiUtil.isPluginProject(project)) {
            return null;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)e);
        if (file == null || !ProjectFileIndex.SERVICE.getInstance((Project)project).isInTestSourceContent(file)) {
            return null;
        }
        if (uElement instanceof UMethod) {
            return new RunLineMarkerContributor.Info(ActionManager.getInstance().getAction("TestData.Navigate"));
        }
        PsiClass psiClass = ((UClass)uElement).getJavaPsi();
        String testDataBasePath = TestDataLineMarkerProvider.getTestDataBasePath(psiClass);
        if (testDataBasePath == null) {
            return null;
        }
        return new RunLineMarkerContributor.Info((AnAction)new GotoTestDataAction(testDataBasePath, psiClass.getProject(), AllIcons.Nodes.Folder));
    }

    @Nullable
    public static String getTestDataBasePath(@Nullable PsiClass psiClass) {
        UExpression value;
        if (psiClass == null) {
            return null;
        }
        UAnnotation annotation = (UAnnotation)UastContextKt.toUElement((PsiElement)AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)psiClass, Collections.singleton(TEST_DATA_PATH_ANNOTATION_QUALIFIED_NAME)), UAnnotation.class);
        if (annotation != null && (value = annotation.findAttributeValue("value")) != null) {
            Project project = psiClass.getProject();
            Object constantValue = value.evaluate();
            if (constantValue instanceof String) {
                String path = (String)constantValue;
                if (path.contains(CONTENT_ROOT_VARIABLE)) {
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                    VirtualFile file = psiClass.getContainingFile().getVirtualFile();
                    if (file == null) {
                        return null;
                    }
                    VirtualFile contentRoot = fileIndex.getContentRootForFile(file);
                    if (contentRoot == null) {
                        return null;
                    }
                    path = path.replace(CONTENT_ROOT_VARIABLE, contentRoot.getPath());
                }
                if (path.contains(PROJECT_ROOT_VARIABLE)) {
                    String baseDir = project.getBasePath();
                    if (baseDir == null) {
                        return null;
                    }
                    path = path.replace(PROJECT_ROOT_VARIABLE, baseDir);
                }
                return path;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/devkit/testAssistant/TestDataLineMarkerProvider", "getInfo"));
    }
}

