/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class FileEqualsUsageInspection
extends DevKitUastInspectionBase {
    private static final Set<String> METHOD_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"equals", "compareTo", "hashCode"});

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileEqualsUsageInspection.inspectCallExpression(node, holder);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/devkit/inspections/internal/FileEqualsUsageInspection$1", "visitCallExpression"));
            }
        }, (Class[])new Class[]{UCallExpression.class});
        if (psiElementVisitor == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static void inspectCallExpression(@NotNull UCallExpression node, @NotNull ProblemsHolder holder) {
        if (node == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(3);
        }
        if (node.getKind() != UastCallKind.METHOD_CALL) {
            return;
        }
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (!"java.io.File".equals(containingClass.getQualifiedName())) {
            return;
        }
        if (!METHOD_NAMES.contains(node.getMethodName())) {
            return;
        }
        if (JavaPsiFacade.getInstance((Project)holder.getProject()).findClass(FileUtil.class.getName(), holder.getFile().getResolveScope()) == null) {
            return;
        }
        UIdentifier identifier = node.getMethodIdentifier();
        if (identifier == null) {
            return;
        }
        PsiElement sourcePsi = identifier.getSourcePsi();
        if (sourcePsi == null) {
            return;
        }
        holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.file.equals.method", new Object[0]), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/FileEqualsUsageInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/FileEqualsUsageInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inspectCallExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

