/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.impl.PluginPsiClassConverter;
import org.jetbrains.idea.devkit.inspections.PluginXmlDomInspection;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001!B5\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019J\u0012\u0010 \u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/idea/devkit/inspections/ComponentModuleRegistrationChecker;", "", "moduleToModuleSet", "Lcom/intellij/openapi/util/ClearableLazyValue;", "", "", "Lorg/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$PluginModuleSet;", "ignoredClasses", "", "annotationHolder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "(Lcom/intellij/openapi/util/ClearableLazyValue;Ljava/util/List;Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;)V", "checkProperModule", "", "extensionPoint", "Lorg/jetbrains/idea/devkit/dom/ExtensionPoint;", "checkProperXmlFileForClass", "", "element", "Lcom/intellij/util/xml/DomElement;", "psiClass", "Lcom/intellij/psi/PsiClass;", "checkProperXmlFileForExtension", "Lorg/jetbrains/idea/devkit/dom/Extension;", "findMatchingImplModule", "Lcom/intellij/openapi/module/Module;", "module", "findModulePluginXmlFile", "Lcom/intellij/psi/xml/XmlFile;", "getExtensionPointClass", "Lcom/intellij/psi/PsiElement;", "isIdeaPlatformModule", "shouldCheckExtensionPointClassAttribute", "MoveRegistrationQuickFix", "intellij.devkit"})
public final class ComponentModuleRegistrationChecker {
    private final ClearableLazyValue<Map<String, PluginXmlDomInspection.PluginModuleSet>> moduleToModuleSet;
    private final List<String> ignoredClasses;
    private final DomElementAnnotationHolder annotationHolder;

    /*
     * WARNING - void declaration
     */
    public final void checkProperModule(@NotNull ExtensionPoint extensionPoint) {
        block2: {
            void extensionPointClass;
            Module module;
            Intrinsics.checkNotNullParameter((Object)extensionPoint, (String)"extensionPoint");
            PsiClass effectiveEpClass = extensionPoint.getEffectiveClass();
            if (this.shouldCheckExtensionPointClassAttribute(effectiveEpClass) && this.checkProperXmlFileForClass(extensionPoint, effectiveEpClass)) {
                return;
            }
            String string = extensionPoint.getEffectiveQualifiedName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extensionPoint.effectiveQualifiedName");
            String shortName = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null);
            Module module2 = module = extensionPoint.getModule();
            Intrinsics.checkNotNull((Object)module2);
            Project project = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module!!.project");
            Project project2 = project;
            PsiSearchHelper psiSearchHelper = PsiSearchHelper.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)psiSearchHelper, (String)"PsiSearchHelper.getInstance(project)");
            PsiSearchHelper psiSearchHelper2 = psiSearchHelper;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.projectScope(project)");
            GlobalSearchScope scope = globalSearchScope;
            if (psiSearchHelper2.isCheapEnoughToSearch(shortName, scope, null, null) != PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES) break block2;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            psiSearchHelper2.processElementsWithWord(new TextOccurenceProcessor(this, (Ref.ObjectRef)extensionPointClass){
                final /* synthetic */ ComponentModuleRegistrationChecker this$0;
                final /* synthetic */ Ref.ObjectRef $extensionPointClass;

                public final boolean execute(@NotNull PsiElement element, int $noName_1) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    this.$extensionPointClass.element = ComponentModuleRegistrationChecker.access$getExtensionPointClass(this.this$0, element);
                    return (PsiClass)this.$extensionPointClass.element == null;
                }
                {
                    this.this$0 = componentModuleRegistrationChecker;
                    this.$extensionPointClass = objectRef;
                }
            }, (SearchScope)scope, shortName, (short)4, true, false);
            PsiClass psiClass = (PsiClass)extensionPointClass.element;
            if (psiClass != null) {
                PsiClass psiClass2 = psiClass;
                boolean bl = false;
                boolean bl2 = false;
                PsiClass it = psiClass2;
                boolean bl3 = false;
                this.checkProperXmlFileForClass(extensionPoint, it);
            }
        }
    }

    private final PsiClass getExtensionPointClass(PsiElement element) {
        PsiClassType psiClassType;
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (psiField == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiField, (String)"PsiTreeUtil.getParentOfT\u2026lass.java) ?: return null");
        PsiField epName = psiField;
        PsiType psiType = epName.getType();
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        if ((psiClassType = (PsiClassType)psiType) == null || (psiClassType = psiClassType.resolve()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"(epName.type as? PsiClas\u2026.resolve() ?: return null");
        PsiClassType psiClass = psiClassType;
        if (Intrinsics.areEqual((Object)psiClass.getQualifiedName(), (Object)"com.intellij.openapi.extensions.ExtensionPointName")) {
            return epName.getContainingClass();
        }
        return null;
    }

    public final void checkProperXmlFileForExtension(@NotNull Extension element) {
        CharSequence beanClass;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        CharSequence charSequence = element.getXmlTag().getAttributeValue("language");
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            GenericAttributeValue<PsiClass> genericAttributeValue = element.getExtensionPoint();
            Object object = genericAttributeValue != null && (genericAttributeValue = genericAttributeValue.getBeanClass()) != null ? (PsiClass)genericAttributeValue.getValue() : (beanClass = null);
            if (beanClass != null && InheritanceUtil.isInheritor((PsiClass)beanClass, (String)"com.intellij.lang.LanguageExtensionPoint")) {
                return;
            }
        }
        beanClass = element.getXmlTag().getAttributeValue("filetype");
        bl = false;
        bl2 = false;
        if (!(beanClass == null || beanClass.length() == 0)) {
            GenericAttributeValue<PsiClass> genericAttributeValue = element.getExtensionPoint();
            Object object = genericAttributeValue != null && (genericAttributeValue = genericAttributeValue.getBeanClass()) != null ? (PsiClass)genericAttributeValue.getValue() : (beanClass = null);
            if (beanClass != null && InheritanceUtil.isInheritor((PsiClass)beanClass, (String)"com.intellij.openapi.fileTypes.FileTypeExtensionPoint")) {
                return;
            }
        }
        DomGenericInfo domGenericInfo = element.getGenericInfo();
        Intrinsics.checkNotNullExpressionValue((Object)domGenericInfo, (String)"element.genericInfo");
        Iterator iterator = domGenericInfo.getAttributeChildrenDescriptions().iterator();
        while (iterator.hasNext()) {
            PsiClass psiClass;
            GenericAttributeValue attributeValue;
            DomAttributeChildDescription attributeDescription;
            DomAttributeChildDescription domAttributeChildDescription = attributeDescription = (DomAttributeChildDescription)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)domAttributeChildDescription, (String)"attributeDescription");
            String attributeName = domAttributeChildDescription.getName();
            if (Intrinsics.areEqual((Object)attributeName, (Object)"forClass") || Intrinsics.areEqual((Object)attributeName, (Object)"serviceInterface") && Intrinsics.areEqual((Object)element.getXmlTag().getAttributeValue("overrides"), (Object)"true") || (attributeValue = attributeDescription.getDomAttributeValue((DomElement)element)) == null || !DomUtil.hasXml((DomElement)((DomElement)attributeValue)) || !(attributeValue.getConverter() instanceof PluginPsiClassConverter)) continue;
            if ((PsiClass)attributeValue.getValue() == null) {
                continue;
            }
            if (!this.checkProperXmlFileForClass(element, psiClass)) continue;
            return;
        }
        DomGenericInfo domGenericInfo2 = element.getGenericInfo();
        Intrinsics.checkNotNullExpressionValue((Object)domGenericInfo2, (String)"element.genericInfo");
        for (DomFixedChildDescription childDescription : domGenericInfo2.getFixedChildrenDescriptions()) {
            Project project;
            XmlTag tag;
            DomElement domElement;
            List list = childDescription.getValues((DomElement)element);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"childDescription.getValues(element)");
            if ((DomElement)CollectionsKt.firstOrNull((List)list) == null) {
                continue;
            }
            if (domElement.getXmlTag() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"domElement.xmlTag ?: continue");
            Intrinsics.checkNotNullExpressionValue((Object)tag.getProject(), (String)"tag.project");
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            XmlTagValue xmlTagValue = tag.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)xmlTagValue, (String)"tag.value");
            PsiClass psiClass = javaPsiFacade.findClass(xmlTagValue.getText(), GlobalSearchScope.projectScope((Project)project));
            if (psiClass == null || !this.checkProperXmlFileForClass(element, psiClass)) continue;
            return;
        }
    }

    private final boolean shouldCheckExtensionPointClassAttribute(PsiClass psiClass) {
        PsiField[] psiFieldArray = psiClass;
        if (psiClass != null && (psiFieldArray = psiFieldArray.getFields()) != null) {
            PsiField[] $this$forEach$iv = psiFieldArray;
            boolean $i$f$forEach = false;
            PsiField[] psiFieldArray2 = $this$forEach$iv;
            int n = psiFieldArray2.length;
            for (int i = 0; i < n; ++i) {
                PsiField element$iv;
                PsiField field = element$iv = psiFieldArray2[i];
                boolean bl = false;
                String string = ExtensionPointName.class.getCanonicalName();
                PsiField psiField = field;
                Intrinsics.checkNotNullExpressionValue((Object)psiField, (String)"field");
                if (!TypeUtils.typeEquals((String)string, (PsiType)psiField.getType())) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean checkProperXmlFileForClass(@NotNull DomElement element, @Nullable PsiClass psiClass) {
        MoveRegistrationQuickFix moveRegistrationQuickFix;
        Module implModule;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (psiClass == null) {
            return false;
        }
        if (CollectionsKt.contains((Iterable)this.ignoredClasses, (Object)psiClass.getQualifiedName())) {
            return false;
        }
        PsiClass psiClass2 = psiClass;
        boolean bl = false;
        boolean bl2 = false;
        PsiClass it = psiClass2;
        boolean bl3 = false;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)it));
        if (module == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"psiClass.let { ModuleUti\u2026ent(it) } ?: return false");
        Module definingModule = module;
        Module elementModule = element.getModule();
        if (elementModule == null || Intrinsics.areEqual((Object)definingModule, (Object)elementModule)) {
            return false;
        }
        PluginXmlDomInspection.PluginModuleSet definingPlugin = (PluginXmlDomInspection.PluginModuleSet)((Map)this.moduleToModuleSet.getValue()).get(definingModule.getName());
        PluginXmlDomInspection.PluginModuleSet elementPlugin = (PluginXmlDomInspection.PluginModuleSet)((Map)this.moduleToModuleSet.getValue()).get(elementModule.getName());
        if (definingPlugin != null && definingPlugin == elementPlugin) {
            return false;
        }
        Module pluginXmlModule = definingModule;
        XmlFile modulePluginXmlFile = this.findModulePluginXmlFile(pluginXmlModule);
        if (modulePluginXmlFile == null && (implModule = this.findMatchingImplModule(pluginXmlModule)) != null) {
            pluginXmlModule = implModule;
            modulePluginXmlFile = this.findModulePluginXmlFile(implModule);
        }
        if (modulePluginXmlFile != null) {
            String string = modulePluginXmlFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"modulePluginXmlFile.name");
            moveRegistrationQuickFix = new MoveRegistrationQuickFix(pluginXmlModule, string);
        } else {
            moveRegistrationQuickFix = null;
        }
        MoveRegistrationQuickFix fix = moveRegistrationQuickFix;
        this.annotationHolder.createProblem(element, ProblemHighlightType.WARNING, DevKitBundle.message("inspections.plugin.xml.ComponentModuleRegistrationChecker.element.registered.wrong.module", definingModule.getName(), psiClass.getQualifiedName()), null, new LocalQuickFix[]{fix});
        return true;
    }

    public final boolean isIdeaPlatformModule(@Nullable Module module) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return true;
        }
        if (module == null || !PsiUtil.isIdeaProject(module.getProject())) {
            return false;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        VirtualFile[] contentRoots = moduleRootManager.getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)contentRoots, (String)"contentRoots");
        VirtualFile[] virtualFileArray = contentRoots;
        boolean bl = false;
        if (virtualFileArray.length == 0) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)contentRoots[0], (String)"contentRoots[0]");
        for (VirtualFile parent = (v40028).getParent(); parent != null; parent = parent.getParent()) {
            if (Intrinsics.areEqual((Object)parent.getName(), (Object)"plugins")) {
                return false;
            }
            if (parent.findChild(".idea") == null) continue;
            return true;
        }
        return true;
    }

    private final Module findMatchingImplModule(Module module) {
        return ModuleManager.getInstance((Project)module.getProject()).findModuleByName(module.getName() + ".impl");
    }

    private final XmlFile findModulePluginXmlFile(Module module) {
        for (VirtualFile sourceRoot : ModuleRootManager.getInstance((Module)module).getSourceRoots(false)) {
            VirtualFile metaInf = sourceRoot.findChild("META-INF");
            if (metaInf == null || !metaInf.isDirectory()) continue;
            VirtualFile[] virtualFileArray = metaInf.getChildren();
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                PsiFile psiFile;
                VirtualFile file;
                VirtualFile virtualFile = file = virtualFileArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
                String string = virtualFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                if (!StringsKt.endsWith$default((String)string, (String)"Plugin.xml", (boolean)false, (int)2, null) || !((psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file)) instanceof XmlFile)) continue;
                return (XmlFile)psiFile;
            }
        }
        return null;
    }

    public ComponentModuleRegistrationChecker(@NotNull ClearableLazyValue<Map<String, PluginXmlDomInspection.PluginModuleSet>> moduleToModuleSet, @NotNull List<String> ignoredClasses, @NotNull DomElementAnnotationHolder annotationHolder) {
        Intrinsics.checkNotNullParameter(moduleToModuleSet, (String)"moduleToModuleSet");
        Intrinsics.checkNotNullParameter(ignoredClasses, (String)"ignoredClasses");
        Intrinsics.checkNotNullParameter((Object)annotationHolder, (String)"annotationHolder");
        this.moduleToModuleSet = moduleToModuleSet;
        this.ignoredClasses = ignoredClasses;
        this.annotationHolder = annotationHolder;
    }

    public static final /* synthetic */ PsiClass access$getExtensionPointClass(ComponentModuleRegistrationChecker $this, PsiElement element) {
        return $this.getExtensionPointClass(element);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0017J\b\u0010\u000e\u001a\u00020\u0005H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/ComponentModuleRegistrationChecker$MoveRegistrationQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "myTargetModule", "Lcom/intellij/openapi/module/Module;", "myTargetFileName", "", "(Lorg/jetbrains/idea/devkit/inspections/ComponentModuleRegistrationChecker;Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "intellij.devkit"})
    public final class MoveRegistrationQuickFix
    implements LocalQuickFix {
        private final Module myTargetModule;
        private final String myTargetFileName;

        @Nls
        @NotNull
        public String getName() {
            String string = DevKitBundle.message("inspections.plugin.xml.ComponentModuleRegistrationChecker.fix.move.registration.name", this.myTargetFileName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"in\u2026.name\", myTargetFileName)");
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.plugin.xml.ComponentModuleRegistrationChecker.fix.move.registration.family.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DevKitBundle.message(\"in\u2026egistration.family.name\")");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            block16: {
                PsiElement psiElement;
                XmlTag tag;
                block15: {
                    XmlTag newParentTag;
                    block14: {
                        PsiElement anchor;
                        PsiElement psiElement2;
                        boolean bl;
                        block13: {
                            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlTag.class, (boolean)false);
                            if (xmlTag == null) {
                                return;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"PsiTreeUtil.getParentOfT\u2026ss.java, false) ?: return");
                            tag = xmlTag;
                            XmlTag xmlTag2 = tag.getParentTag();
                            if (xmlTag2 == null) {
                                return;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)xmlTag2, (String)"tag.parentTag ?: return");
                            XmlTag parentTag = xmlTag2;
                            XmlFile xmlFile = ComponentModuleRegistrationChecker.this.findModulePluginXmlFile(this.myTargetModule);
                            if (xmlFile == null) {
                                return;
                            }
                            XmlFile targetFile = xmlFile;
                            XmlTag xmlTag3 = targetFile.getRootTag();
                            if (xmlTag3 == null) {
                                return;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)xmlTag3, (String)"targetFile.rootTag ?: return");
                            XmlTag rootTag = xmlTag3;
                            XmlTag xmlTag4 = tag.getParentTag();
                            Intrinsics.checkNotNull((Object)xmlTag4);
                            Intrinsics.checkNotNullExpressionValue((Object)xmlTag4, (String)"tag.parentTag!!");
                            Object[] subTags = rootTag.findSubTags(xmlTag4.getName());
                            Intrinsics.checkNotNullExpressionValue((Object)subTags, (String)"subTags");
                            XmlTag xmlTag5 = (XmlTag)ArraysKt.firstOrNull((Object[])subTags);
                            if (xmlTag5 == null) {
                                XmlTag xmlTag6 = rootTag.addSubTag(rootTag.createChildTag(parentTag.getLocalName(), "", null, false), false);
                                boolean bl2 = false;
                                boolean bl3 = false;
                                XmlTag $this$apply = xmlTag6;
                                boolean bl4 = false;
                                XmlAttribute[] xmlAttributeArray = parentTag.getAttributes();
                                int n = xmlAttributeArray.length;
                                for (int i = 0; i < n; ++i) {
                                    XmlAttribute attribute;
                                    XmlAttribute xmlAttribute = attribute = xmlAttributeArray[i];
                                    Intrinsics.checkNotNullExpressionValue((Object)xmlAttribute, (String)"attribute");
                                    $this$apply.setAttribute(xmlAttribute.getName(), attribute.getValue());
                                }
                                xmlTag5 = xmlTag6;
                            }
                            XmlTag xmlTag7 = newParentTag = xmlTag5;
                            Intrinsics.checkNotNullExpressionValue((Object)xmlTag7, (String)"newParentTag");
                            XmlTag[] xmlTagArray = xmlTag7.getSubTags();
                            Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"newParentTag.subTags");
                            XmlTag[] $this$lastOrNull$iv = xmlTagArray;
                            boolean $i$f$lastOrNull = false;
                            int $this$apply = $this$lastOrNull$iv.length;
                            --$this$apply;
                            bl = false;
                            while ($this$apply >= 0) {
                                void index$iv;
                                XmlTag element$iv;
                                XmlTag it = element$iv = $this$lastOrNull$iv[index$iv];
                                boolean bl5 = false;
                                XmlTag xmlTag8 = it;
                                Intrinsics.checkNotNullExpressionValue((Object)xmlTag8, (String)"it");
                                if (Intrinsics.areEqual((Object)xmlTag8.getName(), (Object)tag.getName())) {
                                    psiElement2 = element$iv;
                                    break block13;
                                }
                                --index$iv;
                            }
                            psiElement2 = null;
                        }
                        if ((psiElement = (anchor = psiElement2)) == null) break block14;
                        PsiElement psiElement3 = psiElement;
                        boolean bl6 = false;
                        bl = false;
                        PsiElement it = psiElement3;
                        boolean bl7 = false;
                        psiElement = newParentTag.addAfter((PsiElement)tag, anchor);
                        if (psiElement != null) break block15;
                    }
                    psiElement = (PsiElement)newParentTag.addSubTag(tag, false);
                }
                PsiElement newTag = psiElement;
                tag.delete();
                PsiElement psiElement4 = newTag;
                if (!(psiElement4 instanceof Navigatable)) {
                    psiElement4 = null;
                }
                Navigatable navigatable = (Navigatable)psiElement4;
                if (navigatable == null) break block16;
                navigatable.navigate(true);
            }
        }

        public MoveRegistrationQuickFix(@NotNull Module myTargetModule, String myTargetFileName) {
            Intrinsics.checkNotNullParameter((Object)myTargetModule, (String)"myTargetModule");
            Intrinsics.checkNotNullParameter((Object)myTargetFileName, (String)"myTargetFileName");
            this.myTargetModule = myTargetModule;
            this.myTargetFileName = myTargetFileName;
        }
    }
}

