/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.impl.ExtensionDomExtender;
import org.jetbrains.idea.devkit.dom.index.ExtensionPointIndex;
import org.jetbrains.idea.devkit.dom.index.PluginIdDependenciesIndex;
import org.jetbrains.idea.devkit.dom.index.PluginIdModuleIndex;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class ExtensionsDomExtender
extends DomExtender<Extensions> {
    private static final DomExtender<Extension> EXTENSION_EXTENDER = new ExtensionDomExtender();

    public boolean supportsStubs() {
        return false;
    }

    public void registerExtensions(@NotNull Extensions extensions, @NotNull DomExtensionsRegistrar registrar) {
        if (extensions == null) {
            ExtensionsDomExtender.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            ExtensionsDomExtender.$$$reportNull$$$0(1);
        }
        Project project = extensions.getManager().getProject();
        VirtualFile currentFile = ExtensionsDomExtender.getVirtualFile(extensions);
        if (currentFile == null || DumbService.isDumb((Project)project)) {
            return;
        }
        Set<VirtualFile> files = ExtensionsDomExtender.getVisibleFiles(project, currentFile);
        String epPrefix = extensions.getEpPrefix();
        Map<String, Supplier<ExtensionPoint>> points = ExtensionPointIndex.getExtensionPoints(project, files, epPrefix);
        for (Map.Entry<String, Supplier<ExtensionPoint>> entry : points.entrySet()) {
            registrar.registerCollectionChildrenExtension(new XmlName(entry.getKey().substring(epPrefix.length())), Extension.class).setDeclaringDomElement(entry.getValue()).addExtender(EXTENSION_EXTENDER);
        }
        registrar.registerCustomChildrenExtension(Extensions.UnresolvedExtension.class, new CustomDomChildrenDescription.TagNameDescriptor());
    }

    @Nullable
    private static VirtualFile getVirtualFile(DomElement domElement) {
        VirtualFile file = DomUtil.getFile((DomElement)domElement).getOriginalFile().getVirtualFile();
        return file instanceof VirtualFileWithId ? file : null;
    }

    private static Set<VirtualFile> getVisibleFiles(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            ExtensionsDomExtender.$$$reportNull$$$0(2);
        }
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        ExtensionsDomExtender.collectFiles(project, file, result);
        result.addAll(PluginIdModuleIndex.getFiles(project, ""));
        return result;
    }

    private static void collectFiles(Project project, @NotNull VirtualFile file, Set<VirtualFile> result) {
        if (file == null) {
            ExtensionsDomExtender.$$$reportNull$$$0(3);
        }
        ProgressManager.checkCanceled();
        if (!result.add(file)) {
            return;
        }
        for (String id : ExtensionsDomExtender.getDependencies(project, file)) {
            for (VirtualFile dep : PluginIdModuleIndex.getFiles(project, id)) {
                ExtensionsDomExtender.collectFiles(project, dep, result);
            }
        }
    }

    static Collection<String> getDependencies(IdeaPlugin ideaPlugin) {
        VirtualFile currentFile = ExtensionsDomExtender.getVirtualFile(ideaPlugin);
        if (currentFile == null) {
            return Collections.emptySet();
        }
        Project project = ideaPlugin.getManager().getProject();
        return ExtensionsDomExtender.getDependencies(project, currentFile);
    }

    private static Collection<String> getDependencies(Project project, @NotNull VirtualFile currentFile) {
        if (currentFile == null) {
            ExtensionsDomExtender.$$$reportNull$$$0(4);
        }
        HashSet<String> result = new HashSet<String>();
        result.add("com.intellij");
        result.addAll(PluginIdDependenciesIndex.getPluginAndDependsIds(project, Collections.singleton(currentFile)));
        String pluginId = PluginIdDependenciesIndex.getPluginId(project, currentFile);
        if (pluginId != null) {
            result.remove(pluginId);
            return result;
        }
        VirtualFile[] includingFiles = FileIncludeManager.getManager((Project)project).getIncludingFiles(currentFile, false);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        HashSet<VirtualFile> includingAndDependsFiles = new HashSet<VirtualFile>();
        for (VirtualFile virtualFile : includingFiles) {
            if (!fileIndex.isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.PRODUCTION)) continue;
            includingAndDependsFiles.add(virtualFile);
        }
        Collection<VirtualFile> dependsToFiles = PluginIdDependenciesIndex.findDependsTo(project, currentFile);
        includingAndDependsFiles.addAll(dependsToFiles);
        if (includingAndDependsFiles.isEmpty()) {
            return result;
        }
        Set<String> ids = PluginIdDependenciesIndex.getPluginAndDependsIds(project, includingAndDependsFiles);
        result.addAll(ids);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/ExtensionsDomExtender";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerExtensions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getVisibleFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDependencies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

