/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticBuilder;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnosticDumper;", "", "()V", "jacksonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getIndexContentDiagnosticForProject", "Lcom/intellij/util/indexing/diagnostic/dump/IndexContentDiagnostic;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readFrom", "file", "Ljava/nio/file/Path;", "writeTo", "", "destination", "contentDiagnostic", "intellij.platform.lang.impl"})
public final class IndexContentDiagnosticDumper {
    private static final ObjectMapper jacksonObjectMapper;
    public static final IndexContentDiagnosticDumper INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IndexContentDiagnostic getIndexContentDiagnosticForProject(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (fileBasedIndex == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        }
        List<IndexableFilesIterator> list2 = ((FileBasedIndexImpl)fileBasedIndex).getOrderedIndexableFilesProviders(project);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"(FileBasedIndex.getInsta\u2026leFilesProviders(project)");
        List<IndexableFilesIterator> providers = list2;
        ConcurrentBitSet visitedFiles = new ConcurrentBitSet();
        indicator.setText(IndexingBundle.message((String)"index.content.diagnostic.dumping", (Object[])new Object[0]));
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        IndexContentDiagnosticBuilder builder2 = new IndexContentDiagnosticBuilder(project);
        boolean bl = false;
        Iterator iterator2 = ((Iterable)providers).iterator();
        while (iterator2.hasNext()) {
            void index;
            IndexableFilesIterator provider2;
            IndexableFilesIterator indexableFilesIterator = provider2 = (IndexableFilesIterator)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)indexableFilesIterator, (String)"provider");
            indicator.setText2(indexableFilesIterator.getDebugName());
            provider2.iterateFiles(project, new ContentIterator(builder2, provider2){
                final /* synthetic */ IndexContentDiagnosticBuilder $builder;
                final /* synthetic */ IndexableFilesIterator $provider;

                public final boolean processFile(@NotNull VirtualFile fileOrDir) {
                    Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                    IndexableFilesIterator indexableFilesIterator = this.$provider;
                    Intrinsics.checkNotNullExpressionValue((Object)indexableFilesIterator, (String)"provider");
                    String string = indexableFilesIterator.getDebugName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"provider.debugName");
                    this.$builder.addFile(fileOrDir, string);
                    return true;
                }
                {
                    this.$builder = indexContentDiagnosticBuilder;
                    this.$provider = indexableFilesIterator;
                }
            }, visitedFiles);
            indicator.setFraction((double)(index + true) / (double)providers.size());
            ++index;
        }
        return builder2.build();
    }

    public final void writeTo(@NotNull Path destination, @NotNull IndexContentDiagnostic contentDiagnostic) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)contentDiagnostic, (String)"contentDiagnostic");
        jacksonObjectMapper.writerWithDefaultPrettyPrinter().writeValue(destination.toFile(), (Object)contentDiagnostic);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IndexContentDiagnostic readFrom(@NotNull Path file2) {
        void $this$readValue$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ObjectMapper objectMapper2 = jacksonObjectMapper;
        File file3 = file2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file.toFile()");
        File src$iv = file3;
        boolean $i$f$readValue = false;
        File file4 = src$iv;
        void var6_6 = $this$readValue$iv;
        boolean $i$f$jacksonTypeRef = false;
        TypeReference typeReference = (TypeReference)new TypeReference<IndexContentDiagnostic>(){};
        return (IndexContentDiagnostic)var6_6.readValue(file4, typeReference);
    }

    private IndexContentDiagnosticDumper() {
    }

    static {
        IndexContentDiagnosticDumper indexContentDiagnosticDumper;
        INSTANCE = indexContentDiagnosticDumper = new IndexContentDiagnosticDumper();
        jacksonObjectMapper = ExtensionsKt.jacksonObjectMapper();
    }
}

