/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui.tree;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.SingleRemoteServerConfigurable;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServerNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNode;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import icons.RemoteServersIcons;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServersTreeStructure {
    private ServersTreeStructure() {
    }

    public static Icon getServerNodeIcon(@NotNull Icon itemIcon, @Nullable Icon statusIcon) {
        if (itemIcon == null) {
            ServersTreeStructure.$$$reportNull$$$0(0);
        }
        if (statusIcon == null) {
            return itemIcon;
        }
        LayeredIcon icon2 = new LayeredIcon(2);
        icon2.setIcon(itemIcon, 0);
        icon2.setIcon(statusIcon, 1, itemIcon.getIconWidth() - statusIcon.getIconWidth(), itemIcon.getIconHeight() - statusIcon.getIconHeight());
        return icon2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemIcon", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure", "getServerNodeIcon"));
    }

    @FunctionalInterface
    public static interface DeploymentNodeProducer {
        public AbstractTreeNode<?> createDeploymentNode(ServerConnection<?> var1, RemoteServerNode var2, Deployment var3);
    }

    public static class DeploymentLogNode
    extends AbstractTreeNode<LoggingHandlerBase>
    implements ServersTreeNode,
    LogProvidingNode {
        @NotNull
        private final DeploymentNodeImpl myDeploymentNode;

        public DeploymentLogNode(Project project, @NotNull LoggingHandlerBase value2, @NotNull DeploymentNodeImpl deploymentNode) {
            if (value2 == null) {
                DeploymentLogNode.$$$reportNull$$$0(0);
            }
            if (deploymentNode == null) {
                DeploymentLogNode.$$$reportNull$$$0(1);
            }
            super(project, (Object)value2);
            this.myDeploymentNode = deploymentNode;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode<?>> getChildren() {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                DeploymentLogNode.$$$reportNull$$$0(2);
            }
            return list2;
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                DeploymentLogNode.$$$reportNull$$$0(3);
            }
            presentation2.setIcon(AllIcons.Debugger.Console);
            presentation2.setPresentableText(this.getLogName());
        }

        private String getLogName() {
            return ((LoggingHandlerBase)this.getValue()).getPresentableName();
        }

        @Override
        @Nullable
        public JComponent getComponent() {
            return ((LoggingHandlerBase)this.getValue()).getComponent();
        }

        @Override
        @NotNull
        public String getLogId() {
            String string = this.myDeploymentNode.getId() + ";log:" + this.getLogName();
            if (string == null) {
                DeploymentLogNode.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deploymentNode";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentLogNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentLogNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DeploymentNodeImpl
    extends AbstractTreeNode<Deployment>
    implements LogProvidingNode,
    DeploymentNode {
        private final ServerConnection<?> myConnection;
        private final RemoteServerNode myServerNode;
        private final DeploymentNodeProducer myNodeProducer;

        public DeploymentNodeImpl(Project project, @NotNull ServerConnection<?> connection, @NotNull RemoteServerNode serverNode, @NotNull Deployment value2, @NotNull DeploymentNodeProducer nodeProducer) {
            if (connection == null) {
                DeploymentNodeImpl.$$$reportNull$$$0(0);
            }
            if (serverNode == null) {
                DeploymentNodeImpl.$$$reportNull$$$0(1);
            }
            if (value2 == null) {
                DeploymentNodeImpl.$$$reportNull$$$0(2);
            }
            if (nodeProducer == null) {
                DeploymentNodeImpl.$$$reportNull$$$0(3);
            }
            super(project, (Object)value2);
            this.myConnection = connection;
            this.myServerNode = serverNode;
            this.myNodeProducer = nodeProducer;
        }

        @NotNull
        public Deployment getDeployment() {
            Deployment deployment = (Deployment)this.getValue();
            if (deployment == null) {
                DeploymentNodeImpl.$$$reportNull$$$0(4);
            }
            return deployment;
        }

        @Override
        @NotNull
        public RemoteServerNode getServerNode() {
            RemoteServerNode remoteServerNode = this.myServerNode;
            if (remoteServerNode == null) {
                DeploymentNodeImpl.$$$reportNull$$$0(5);
            }
            return remoteServerNode;
        }

        @Override
        public boolean isDeployActionVisible() {
            DeploymentTask deploymentTask = ((Deployment)this.getValue()).getDeploymentTask();
            return deploymentTask instanceof DeploymentTaskImpl && deploymentTask.getExecutionEnvironment().getRunnerAndConfigurationSettings() != null;
        }

        @Override
        public boolean isDeployActionEnabled() {
            return true;
        }

        @Override
        public void deploy() {
            this.doDeploy(DefaultRunExecutor.getRunExecutorInstance());
        }

        public void doDeploy(Executor executor) {
            ExecutionEnvironment environment;
            RunnerAndConfigurationSettings settings;
            DeploymentTask deploymentTask = this.getDeployment().getDeploymentTask();
            if (deploymentTask != null && (settings = (environment = deploymentTask.getExecutionEnvironment()).getRunnerAndConfigurationSettings()) != null) {
                ProgramRunnerUtil.executeConfiguration(settings, executor);
            }
        }

        @Override
        public boolean isDebugActionVisible() {
            return this.myServerNode.getServer().getType().createDebugConnector() != null;
        }

        @Override
        public void deployWithDebug() {
            this.doDeploy(DefaultDebugExecutor.getDebugExecutorInstance());
        }

        @Override
        public boolean isUndeployActionEnabled() {
            DeploymentRuntime runtime = this.getDeployment().getRuntime();
            return runtime != null && runtime.isUndeploySupported();
        }

        @Override
        public void undeploy() {
            DeploymentRuntime runtime = this.getDeployment().getRuntime();
            if (runtime != null) {
                this.getConnection().undeploy(this.getDeployment(), runtime);
            }
        }

        public boolean isEditConfigurationActionVisible() {
            return this.getDeployment().getDeploymentTask() != null;
        }

        public void editConfiguration() {
            RunnerAndConfigurationSettings settings;
            DeploymentTask task2 = this.getDeployment().getDeploymentTask();
            if (task2 != null && (settings = task2.getExecutionEnvironment().getRunnerAndConfigurationSettings()) != null) {
                RunDialog.editConfiguration(this.myProject, settings, CloudBundle.message((String)"dialog.title.edit.deployment.configuration", (Object[])new Object[0]));
            }
        }

        @Override
        public boolean isDeployed() {
            return this.getDeployment().getStatus() == DeploymentStatus.DEPLOYED;
        }

        @Override
        public String getDeploymentName() {
            return this.getDeployment().getName();
        }

        public ServerConnection<?> getConnection() {
            return this.myConnection;
        }

        @Override
        @Nullable
        public JComponent getComponent() {
            DeploymentLogManagerImpl logManager = this.getLogManager();
            return logManager != null && logManager.isMainHandlerVisible() ? logManager.getMainLoggingHandler().getConsole().getComponent() : null;
        }

        @Nullable
        protected DeploymentLogManagerImpl getLogManager() {
            return (DeploymentLogManagerImpl)this.myConnection.getLogManager(this.myProject, this.getDeployment());
        }

        public String getId() {
            return this.myServerNode.getName() + ";deployment" + this.getDeployment().getName();
        }

        @Override
        @NotNull
        public String getLogId() {
            String string = this.getId() + ";main-log";
            if (string == null) {
                DeploymentNodeImpl.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode<?>> getChildren() {
            ArrayList result2 = new ArrayList();
            this.collectDeploymentChildren(result2);
            this.collectLogChildren(result2);
            ArrayList arrayList = result2;
            if (arrayList == null) {
                DeploymentNodeImpl.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        protected void collectDeploymentChildren(List<AbstractTreeNode<?>> children2) {
            ServerConnection<?> connection = this.getConnection();
            if (connection == null) {
                return;
            }
            for (Deployment deployment : connection.getDeployments()) {
                DeploymentRuntime parent = deployment.getParentRuntime();
                if (parent == null || parent != this.getDeployment().getRuntime()) continue;
                children2.add(this.myNodeProducer.createDeploymentNode(connection, this.myServerNode, deployment));
            }
        }

        protected void collectLogChildren(List<AbstractTreeNode<?>> children2) {
            ServerConnection<?> connection = this.getConnection();
            if (connection == null) {
                return;
            }
            DeploymentLogManagerImpl logManager = (DeploymentLogManagerImpl)connection.getLogManager(this.myProject, this.getDeployment());
            if (logManager != null) {
                for (LoggingHandlerBase loggingComponent : logManager.getAdditionalLoggingHandlers()) {
                    children2.add(new DeploymentLogNode(this.myProject, loggingComponent, this));
                }
            }
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                DeploymentNodeImpl.$$$reportNull$$$0(8);
            }
            Deployment deployment = this.getDeployment();
            presentation2.setIcon(deployment.getStatus().getIcon());
            presentation2.setPresentableText(deployment.getPresentableName());
            presentation2.setTooltip(deployment.getStatusText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeProducer";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentNodeImpl";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentNodeImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeployment";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServerNode";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogId";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RemoteServerNode
    extends AbstractTreeNode<RemoteServer<?>>
    implements ServerNode {
        private final DeploymentNodeProducer myNodeProducer;

        public RemoteServerNode(Project project, @NotNull RemoteServer<?> server, @NotNull DeploymentNodeProducer nodeProducer) {
            if (server == null) {
                RemoteServerNode.$$$reportNull$$$0(0);
            }
            if (nodeProducer == null) {
                RemoteServerNode.$$$reportNull$$$0(1);
            }
            super(project, server);
            this.myNodeProducer = nodeProducer;
        }

        @NotNull
        public RemoteServer<?> getServer() {
            RemoteServer remoteServer = (RemoteServer)this.getValue();
            if (remoteServer == null) {
                RemoteServerNode.$$$reportNull$$$0(2);
            }
            return remoteServer;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode<?>> getChildren() {
            ServerConnection<?> connection = this.getConnection();
            if (connection == null) {
                List list2 = Collections.emptyList();
                if (list2 == null) {
                    RemoteServerNode.$$$reportNull$$$0(3);
                }
                return list2;
            }
            ArrayList children2 = new ArrayList();
            for (Deployment deployment : connection.getDeployments()) {
                if (deployment.getParentRuntime() != null) continue;
                children2.add(this.myNodeProducer.createDeploymentNode(connection, this, deployment));
            }
            ArrayList arrayList = children2;
            if (arrayList == null) {
                RemoteServerNode.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                RemoteServerNode.$$$reportNull$$$0(5);
            }
            RemoteServer<?> server = this.getServer();
            ServerConnection<?> connection = this.getConnection();
            presentation2.setPresentableText(server.getName());
            presentation2.setIcon(ServersTreeStructure.getServerNodeIcon(server.getType().getIcon(), connection != null ? RemoteServerNode.getStatusIcon(connection.getStatus()) : null));
            presentation2.setTooltip(connection != null ? connection.getStatusText() : null);
        }

        @Nullable
        private ServerConnection<?> getConnection() {
            return ServerConnectionManager.getInstance().getConnection(this.getServer());
        }

        public boolean isConnected() {
            ServerConnection<?> connection = this.getConnection();
            return connection != null && connection.getStatus() == ConnectionStatus.CONNECTED;
        }

        public void deploy(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoteServerNode.$$$reportNull$$$0(6);
            }
            this.doDeploy(e, DefaultRunExecutor.getRunExecutorInstance(), CloudBundle.message((String)"ServersTreeStructure.RemoteServerNode.popup.title.deploy.configuration", (Object[])new Object[0]), true);
        }

        public void deployWithDebug(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoteServerNode.$$$reportNull$$$0(7);
            }
            this.doDeploy(e, DefaultDebugExecutor.getDebugExecutorInstance(), CloudBundle.message((String)"ServersTreeStructure.RemoteServerNode.popup.title.deploy.debug.configuration", (Object[])new Object[0]), false);
        }

        public void doDeploy(@NotNull AnActionEvent e, final Executor executor, @NlsContexts.PopupTitle String popupTitle, boolean canCreate) {
            if (e == null) {
                RemoteServerNode.$$$reportNull$$$0(8);
            }
            RemoteServer<?> server = this.getServer();
            final ServerType serverType = server.getType();
            final DeploymentConfigurationManager configurationManager = DeploymentConfigurationManager.getInstance((Project)this.myProject);
            LinkedList runConfigsAndTypes = new LinkedList();
            List runConfigs = ContainerUtil.filter((Collection)configurationManager.getDeploymentConfigurations(serverType), settings -> {
                DeployToServerRunConfiguration configuration = (DeployToServerRunConfiguration)settings.getConfiguration();
                return StringUtil.equals((CharSequence)server.getName(), (CharSequence)configuration.getServerName());
            });
            runConfigsAndTypes.addAll(runConfigs);
            if (canCreate) {
                runConfigsAndTypes.addAll(server.getType().getSingletonDeploymentSourceTypes());
                if (server.getType().mayHaveProjectSpecificDeploymentSources()) {
                    runConfigsAndTypes.add(null);
                }
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Object>(popupTitle, runConfigsAndTypes){

                public Icon getIconFor(Object runConfigOrSourceType) {
                    return runConfigOrSourceType != null ? serverType.getIcon() : null;
                }

                @NotNull
                public String getTextFor(Object runConfigOrSourceType) {
                    if (runConfigOrSourceType instanceof RunnerAndConfigurationSettings) {
                        String string = ((RunnerAndConfigurationSettings)runConfigOrSourceType).getName();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }
                    if (runConfigOrSourceType instanceof SingletonDeploymentSourceType) {
                        String displayName = ((SingletonDeploymentSourceType)runConfigOrSourceType).getPresentableName();
                        String string = CloudBundle.message((String)"create.new.deployment.configuration.for.singleton.type", (Object[])new Object[]{displayName});
                        if (string == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string;
                    }
                    String string = CloudBundle.message((String)"create.new.deployment.configuration.generic", (Object[])new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                public PopupStep<?> onChosen(Object selectedRunConfigOrSourceType, boolean finalChoice) {
                    return this.doFinalStep(() -> {
                        if (selectedRunConfigOrSourceType instanceof RunnerAndConfigurationSettings) {
                            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)selectedRunConfigOrSourceType, executor);
                        } else if (selectedRunConfigOrSourceType instanceof SingletonDeploymentSourceType) {
                            SingletonDeploymentSourceType sourceType = (SingletonDeploymentSourceType)selectedRunConfigOrSourceType;
                            configurationManager.createAndRunConfiguration(serverType, (RemoteServer)this.getValue(), (DeploymentSourceType)sourceType);
                        } else {
                            assert (selectedRunConfigOrSourceType == null);
                            configurationManager.createAndRunConfiguration(serverType, (RemoteServer)this.getValue(), null);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$RemoteServerNode$1", "getTextFor"));
                }
            });
            if (e.getInputEvent() instanceof MouseEvent) {
                popup2.show(new RelativePoint((MouseEvent)e.getInputEvent()));
            } else {
                popup2.showInBestPositionFor(e.getDataContext());
            }
        }

        public void editConfiguration() {
            ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)new SingleRemoteServerConfigurable((RemoteServer)this.getValue(), null, false));
        }

        @Nullable
        private static Icon getStatusIcon(ConnectionStatus status) {
            switch (status) {
                case CONNECTED: {
                    return RemoteServersIcons.ResumeScaled;
                }
                case DISCONNECTED: {
                    return RemoteServersIcons.SuspendScaled;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "server";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeProducer";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$RemoteServerNode";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$RemoteServerNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServer";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "deploy";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "deployWithDebug";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "doDeploy";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface LogProvidingNode {
        @Nullable
        public JComponent getComponent();

        @NotNull
        public String getLogId();
    }
}

