/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.rename.naming.NameSuggester;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;

public abstract class AutomaticRenamer {
    private static final Logger LOG = Logger.getInstance(AutomaticRenamer.class);
    private final LinkedHashMap<PsiNamedElement, String> myRenames = new LinkedHashMap();
    protected final List<PsiNamedElement> myElements = new ArrayList<PsiNamedElement>();

    protected AutomaticRenamer() {
    }

    public boolean hasAnythingToRename() {
        return this.myRenames.values().stream().anyMatch(Objects::nonNull);
    }

    public void findUsages(List<UsageInfo> result2, boolean searchInStringsAndComments, boolean searchInNonJavaFiles) {
        this.findUsages(result2, searchInStringsAndComments, searchInNonJavaFiles, null);
    }

    public void findUsages(List<UsageInfo> result2, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, List<UnresolvableCollisionUsageInfo> unresolvedUsages) {
        this.findUsages(result2, searchInStringsAndComments, searchInNonJavaFiles, unresolvedUsages, null);
    }

    public void findUsages(List<UsageInfo> result2, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, List<UnresolvableCollisionUsageInfo> unresolvedUsages, Map<PsiElement, String> allRenames) {
        Iterator<PsiNamedElement> iterator2 = this.myElements.iterator();
        while (iterator2.hasNext()) {
            PsiNamedElement variable = iterator2.next();
            RenameProcessor.assertNonCompileElement((PsiElement)variable);
            boolean success = this.findUsagesForElement(variable, result2, searchInStringsAndComments, searchInNonJavaFiles, unresolvedUsages, allRenames);
            if (success) continue;
            iterator2.remove();
        }
    }

    private boolean findUsagesForElement(PsiNamedElement element2, List<? super UsageInfo> result2, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, List<? super UnresolvableCollisionUsageInfo> unresolvedUsages, Map<PsiElement, String> allRenames) {
        String newName2 = this.getNewName(element2);
        if (newName2 != null) {
            Object[] usages;
            LinkedHashMap<PsiNamedElement, String> renames = new LinkedHashMap<PsiNamedElement, String>(this.myRenames);
            if (allRenames != null) {
                for (PsiElement psiElement : allRenames.keySet()) {
                    if (!(psiElement instanceof PsiNamedElement)) continue;
                    renames.put((PsiNamedElement)psiElement, allRenames.get(psiElement));
                }
            }
            for (UsageInfo usageInfo : usages = RenameUtil.findUsages((PsiElement)element2, newName2, searchInStringsAndComments, searchInNonJavaFiles, renames)) {
                if (!(usageInfo instanceof UnresolvableCollisionUsageInfo)) continue;
                if (unresolvedUsages != null) {
                    unresolvedUsages.add((UnresolvableCollisionUsageInfo)usageInfo);
                }
                return false;
            }
            ContainerUtil.addAll(result2, (Object[])usages);
        }
        return true;
    }

    public List<PsiNamedElement> getElements() {
        return Collections.unmodifiableList(this.myElements);
    }

    public String getNewName(PsiNamedElement namedElement) {
        return this.myRenames.get(namedElement);
    }

    public Map<PsiNamedElement, String> getRenames() {
        return Collections.unmodifiableMap(this.myRenames);
    }

    public void setRename(PsiNamedElement element2, String replacement) {
        LOG.assertTrue(this.myRenames.put(element2, replacement) != null);
    }

    public void doNotRename(PsiNamedElement element2) {
        LOG.assertTrue(this.myRenames.remove(element2) != null);
    }

    protected void suggestAllNames(String oldClassName, String newClassName) {
        NameSuggester suggester = new NameSuggester(oldClassName, newClassName);
        for (int varIndex = this.myElements.size() - 1; varIndex >= 0; --varIndex) {
            PsiNamedElement element2 = this.myElements.get(varIndex);
            String name = element2.getName();
            if (!this.myRenames.containsKey(element2) && name != null) {
                String newName2 = this.suggestNameForElement(element2, suggester, newClassName, oldClassName);
                if (!newName2.equals(name)) {
                    this.myRenames.put(element2, newName2);
                } else {
                    this.myRenames.put(element2, null);
                }
            }
            if (this.myRenames.get(element2) != null) continue;
            this.myElements.remove(varIndex);
        }
    }

    protected String suggestNameForElement(PsiNamedElement element2, NameSuggester suggester, String newClassName, String oldClassName) {
        String name = element2.getName();
        if (oldClassName.equals(name)) {
            return newClassName;
        }
        String canonicalName = this.nameToCanonicalName(name, element2);
        String newCanonicalName = suggester.suggestName(canonicalName);
        if (newCanonicalName.length() == 0) {
            LOG.error("oldClassName = " + oldClassName + ", newClassName = " + newClassName + ", name = " + name + ", canonicalName = " + canonicalName + ", newCanonicalName = " + newCanonicalName);
        }
        return this.canonicalNameToName(newCanonicalName, element2);
    }

    @NonNls
    protected String canonicalNameToName(@NonNls String canonicalName, PsiNamedElement element2) {
        return canonicalName;
    }

    protected String nameToCanonicalName(@NonNls String name, PsiNamedElement element2) {
        return name;
    }

    public boolean allowChangeSuggestedName() {
        return true;
    }

    public boolean isSelectedByDefault() {
        return false;
    }

    @NlsContexts.DialogTitle
    public abstract String getDialogTitle();

    @NlsContexts.Button
    public abstract String getDialogDescription();

    @NlsContexts.ColumnName
    public abstract String entityName();
}

