/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.Alarm;
import com.intellij.util.MathUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class FloatingDecorator
extends JDialog {
    private static final Logger LOG = Logger.getInstance(FloatingDecorator.class);
    static final int DIVIDER_WIDTH = 3;
    private static final int ANCHOR_TOP = 1;
    private static final int ANCHOR_LEFT = 2;
    private static final int ANCHOR_BOTTOM = 4;
    private static final int ANCHOR_RIGHT = 8;
    private static final int DELAY = 15;
    private static final int TOTAL_FRAME_COUNT = 7;
    private final MyUISettingsListener myUISettingsListener;
    private WindowInfo myInfo;
    private final Disposable myDisposable;
    private final Alarm myDelayAlarm;
    private final Alarm myFrameTicker;
    private final MyAnimator myAnimator;
    private int myCurrentFrame;
    private float myStartRatio;
    private float myEndRatio;

    FloatingDecorator(@NotNull JFrame owner, final @NotNull InternalDecorator decorator) {
        if (owner == null) {
            FloatingDecorator.$$$reportNull$$$0(0);
        }
        if (decorator == null) {
            FloatingDecorator.$$$reportNull$$$0(1);
        }
        super((Frame)owner, decorator.getToolWindow().getStripeTitle());
        this.myDisposable = Disposer.newDisposable();
        MnemonicHelper.init((Component)this.getContentPane());
        this.setDefaultCloseOperation(0);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        if (SystemInfo.isWindows) {
            this.setUndecorated(true);
            contentPane.add((Component)new BorderItem(1), "North");
            contentPane.add((Component)new BorderItem(2), "West");
            contentPane.add((Component)new BorderItem(4), "South");
            contentPane.add((Component)new BorderItem(8), "East");
            contentPane.add((Component)decorator, "Center");
        } else {
            contentPane.add((Component)decorator, "Center");
            this.getRootPane().putClientProperty("Window.style", "small");
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ToolWindowImpl toolWindow = decorator.getToolWindow();
                toolWindow.getToolWindowManager().resized(decorator);
                toolWindow.getToolWindowManager().hideToolWindow(toolWindow.getId(), false);
            }
        });
        this.myDelayAlarm = new Alarm();
        this.myFrameTicker = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        this.myAnimator = new MyAnimator();
        this.myCurrentFrame = 0;
        this.myStartRatio = 0.0f;
        this.myEndRatio = 0.0f;
        this.myUISettingsListener = new MyUISettingsListener();
        IdeGlassPaneImpl ideGlassPane = new IdeGlassPaneImpl(this.getRootPane(), true);
        this.getRootPane().setGlassPane(ideGlassPane);
        ideGlassPane.addMousePreprocessor(new MouseAdapter(){}, this.myDisposable);
    }

    @Override
    public final void show() {
        boolean isActive = this.myInfo.isActiveOnStart();
        this.setFocusableWindowState(isActive);
        super.show();
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getState().getEnableAlphaMode()) {
            WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
            windowManager.setAlphaModeEnabled(this, true);
            if (isActive) {
                windowManager.setAlphaModeRatio(this, 0.0f);
            } else {
                windowManager.setAlphaModeRatio(this, uiSettings.getState().getAlphaModeRatio());
            }
        }
        this.paint(this.getGraphics());
        this.setFocusableWindowState(true);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myDelayAlarm).subscribe(UISettingsListener.TOPIC, (Object)this.myUISettingsListener);
    }

    @Override
    public final void dispose() {
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this.getParent())) {
            Disposer.dispose((Disposable)this.myDelayAlarm);
            Disposer.dispose((Disposable)this.myDisposable);
        } else if (this.isShowing()) {
            SwingUtilities.invokeLater(() -> this.show());
        }
        super.dispose();
    }

    void apply(@NotNull WindowInfo info) {
        if (info == null) {
            FloatingDecorator.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(info.getType() == ToolWindowType.FLOATING);
        this.myInfo = info;
        UISettings uiSettings = UISettings.getInstance();
        if (!(uiSettings.getState().getEnableAlphaMode() && this.isShowing() && this.isDisplayable())) {
            return;
        }
        this.myDelayAlarm.cancelAllRequests();
        if (info.isActiveOnStart()) {
            this.myFrameTicker.cancelAllRequests();
            this.myStartRatio = this.getCurrentAlphaRatio();
            if (this.myCurrentFrame > 0) {
                this.myCurrentFrame = 7 - this.myCurrentFrame;
            }
            this.myEndRatio = 0.0f;
            this.myFrameTicker.addRequest((Runnable)this.myAnimator, 15);
        } else {
            this.myDelayAlarm.addRequest(() -> {
                this.myFrameTicker.cancelAllRequests();
                this.myStartRatio = this.getCurrentAlphaRatio();
                if (this.myCurrentFrame > 0) {
                    this.myCurrentFrame = 7 - this.myCurrentFrame;
                }
                this.myEndRatio = uiSettings.getState().getAlphaModeRatio();
                this.myFrameTicker.addRequest((Runnable)this.myAnimator, 15);
            }, uiSettings.getState().getAlphaModeDelay());
        }
    }

    private float getCurrentAlphaRatio() {
        float delta = (this.myEndRatio - this.myStartRatio) / 7.0f;
        if (this.myStartRatio > this.myEndRatio) {
            delta *= 2.0f;
        }
        float ratio = this.myStartRatio + (float)this.myCurrentFrame * delta;
        return MathUtil.clamp((float)ratio, (float)0.0f, (float)1.0f);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/FloatingDecorator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(@NotNull UISettings uiSettings) {
            if (uiSettings == null) {
                MyUISettingsListener.$$$reportNull$$$0(0);
            }
            LOG.assertTrue(FloatingDecorator.this.isDisplayable());
            LOG.assertTrue(FloatingDecorator.this.isShowing());
            WindowManager windowManager = WindowManager.getInstance();
            FloatingDecorator.this.myDelayAlarm.cancelAllRequests();
            if (uiSettings.getState().getEnableAlphaMode()) {
                if (!FloatingDecorator.this.isActive()) {
                    windowManager.setAlphaModeEnabled((Window)FloatingDecorator.this, true);
                    windowManager.setAlphaModeRatio((Window)FloatingDecorator.this, uiSettings.getState().getAlphaModeRatio());
                }
            } else {
                windowManager.setAlphaModeEnabled((Window)FloatingDecorator.this, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiSettings", "com/intellij/openapi/wm/impl/FloatingDecorator$MyUISettingsListener", "uiSettingsChanged"));
        }
    }

    private final class MyAnimator
    implements Runnable {
        private MyAnimator() {
        }

        @Override
        public final void run() {
            if (FloatingDecorator.this.isDisplayable() && FloatingDecorator.this.isShowing()) {
                WindowManager.getInstance().setAlphaModeRatio((Window)FloatingDecorator.this, FloatingDecorator.this.getCurrentAlphaRatio());
            }
            if (FloatingDecorator.this.myCurrentFrame < 7) {
                ++FloatingDecorator.this.myCurrentFrame;
                FloatingDecorator.this.myFrameTicker.addRequest((Runnable)FloatingDecorator.this.myAnimator, 15);
            } else {
                FloatingDecorator.this.myFrameTicker.cancelAllRequests();
            }
        }
    }

    private final class BorderItem
    extends JPanel {
        private static final int RESIZER_WIDTH = 10;
        private final int myAnchor;
        private int myMotionMask;
        private Point myLastPoint;
        private boolean myDragging;

        BorderItem(int anchor2) {
            this.myAnchor = anchor2;
            this.enableEvents(48L);
        }

        @Override
        protected final void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (506 == e.getID() && this.myLastPoint != null) {
                Point offset;
                Point newPoint = e.getPoint();
                SwingUtilities.convertPointToScreen(newPoint, this);
                Rectangle screenBounds = WindowManagerEx.getInstanceEx().getScreenBounds();
                int screenMaxX = screenBounds.x + screenBounds.width;
                int screenMaxY = screenBounds.y + screenBounds.height;
                newPoint.x = MathUtil.clamp((int)newPoint.x, (int)screenBounds.x, (int)screenMaxX);
                newPoint.y = MathUtil.clamp((int)newPoint.y, (int)screenBounds.y, (int)screenMaxY);
                Rectangle oldBounds = FloatingDecorator.this.getBounds();
                Rectangle newBounds = new Rectangle(oldBounds);
                if ((this.myMotionMask & 1) > 0) {
                    newPoint.y = Math.min(newPoint.y, oldBounds.y + oldBounds.height - 6);
                    if (newPoint.y < screenBounds.y + 3) {
                        newPoint.y = screenBounds.y;
                    }
                    offset = new Point(newPoint.x - this.myLastPoint.x, newPoint.y - this.myLastPoint.y);
                    newBounds.y = oldBounds.y + offset.y;
                    newBounds.height = oldBounds.height - offset.y;
                }
                if ((this.myMotionMask & 2) > 0) {
                    newPoint.x = Math.min(newPoint.x, oldBounds.x + oldBounds.width - 6);
                    if (newPoint.x < screenBounds.x + 3) {
                        newPoint.x = screenBounds.x;
                    }
                    offset = new Point(newPoint.x - this.myLastPoint.x, newPoint.y - this.myLastPoint.y);
                    newBounds.x = oldBounds.x + offset.x;
                    newBounds.width = oldBounds.width - offset.x;
                }
                if ((this.myMotionMask & 4) > 0) {
                    newPoint.y = Math.max(newPoint.y, oldBounds.y + 6);
                    if (newPoint.y > screenMaxY - 3) {
                        newPoint.y = screenMaxY;
                    }
                    offset = new Point(newPoint.x - this.myLastPoint.x, newPoint.y - this.myLastPoint.y);
                    newBounds.height = oldBounds.height + offset.y;
                }
                if ((this.myMotionMask & 8) > 0) {
                    newPoint.x = Math.max(newPoint.x, oldBounds.x + 6);
                    if (newPoint.x > screenMaxX - 3) {
                        newPoint.x = screenMaxX;
                    }
                    offset = new Point(newPoint.x - this.myLastPoint.x, newPoint.y - this.myLastPoint.y);
                    newBounds.width = oldBounds.width + offset.x;
                }
                FloatingDecorator.this.setBounds(newBounds.x, newBounds.y, newBounds.width, newBounds.height);
                this.myLastPoint = newPoint;
            } else if (e.getID() == 503 && !this.myDragging) {
                this.setMotionMask(e.getPoint());
            }
        }

        @Override
        protected final void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            switch (e.getID()) {
                case 501: {
                    this.myLastPoint = e.getPoint();
                    SwingUtilities.convertPointToScreen(this.myLastPoint, this);
                    this.setMotionMask(e.getPoint());
                    this.myDragging = true;
                    break;
                }
                case 502: {
                    FloatingDecorator.this.validate();
                    FloatingDecorator.this.repaint();
                    this.myDragging = false;
                    break;
                }
                case 504: {
                    if (this.myDragging) break;
                    this.setMotionMask(e.getPoint());
                }
            }
        }

        private void setMotionMask(Point p) {
            this.myMotionMask = this.myAnchor;
            if (1 == this.myAnchor || 4 == this.myAnchor) {
                if (p.getX() < 10.0) {
                    this.myMotionMask |= 2;
                } else if (p.getX() > (double)(this.getWidth() - 10)) {
                    this.myMotionMask |= 8;
                }
            } else if (p.getY() < 10.0) {
                this.myMotionMask |= 1;
            } else if (p.getY() > (double)(this.getHeight() - 10)) {
                this.myMotionMask |= 4;
            }
            if (this.myMotionMask == 1) {
                this.setCursor(Cursor.getPredefinedCursor(8));
            } else if (this.myMotionMask == 3) {
                this.setCursor(Cursor.getPredefinedCursor(6));
            } else if (this.myMotionMask == 2) {
                this.setCursor(Cursor.getPredefinedCursor(10));
            } else if (this.myMotionMask == 6) {
                this.setCursor(Cursor.getPredefinedCursor(4));
            } else if (this.myMotionMask == 4) {
                this.setCursor(Cursor.getPredefinedCursor(9));
            } else if (this.myMotionMask == 12) {
                this.setCursor(Cursor.getPredefinedCursor(5));
            } else if (this.myMotionMask == 8) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (this.myMotionMask == 9) {
                this.setCursor(Cursor.getPredefinedCursor(7));
            }
        }

        @Override
        public final Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (1 == this.myAnchor || 4 == this.myAnchor) {
                d.height = 3;
            } else {
                d.width = 3;
            }
            return d;
        }

        @Override
        public final void paint(Graphics g) {
            super.paint(g);
            JBColor lightGray = new JBColor(Color.lightGray, (Color)Gray._95);
            JBColor gray = new JBColor(Color.gray, (Color)Gray._95);
            if (1 == this.myAnchor) {
                g.setColor((Color)lightGray);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)0.0, (double)(this.getWidth() - 1), (double)0.0);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)0.0, (double)0.0, (double)(this.getHeight() - 1));
                g.setColor((Color)JBColor.GRAY);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(this.getWidth() - 1), (double)0.0, (double)(this.getWidth() - 1), (double)(this.getHeight() - 1));
            } else if (2 == this.myAnchor) {
                g.setColor((Color)lightGray);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)0.0, (double)0.0, (double)(this.getHeight() - 1));
            } else {
                if (4 == this.myAnchor) {
                    g.setColor((Color)lightGray);
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)0.0, (double)0.0, (double)(this.getHeight() - 1));
                    g.setColor((Color)gray);
                    LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)(this.getHeight() - 1), (double)(this.getWidth() - 1), (double)(this.getHeight() - 1));
                } else {
                    g.setColor((Color)gray);
                }
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(this.getWidth() - 1), (double)0.0, (double)(this.getWidth() - 1), (double)(this.getHeight() - 1));
            }
        }
    }
}

