/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.Interval;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ex.ChangedLines;
import com.intellij.openapi.vcs.ex.ChangesBlock;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisibleRangeMerger<T> {
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final FlagsProvider<T> myFlagsProvider;
    @NotNull
    private ChangesBlock<T> myBlock;
    @NotNull
    private final List<ChangesBlock<T>> myResult;

    private VisibleRangeMerger(@NotNull Editor editor, @NotNull FlagsProvider<T> flagsProvider) {
        if (editor == null) {
            VisibleRangeMerger.$$$reportNull$$$0(0);
        }
        if (flagsProvider == null) {
            VisibleRangeMerger.$$$reportNull$$$0(1);
        }
        this.myBlock = new ChangesBlock();
        this.myResult = new ArrayList<ChangesBlock<T>>();
        this.myEditor = editor;
        this.myFlagsProvider = flagsProvider;
    }

    public static List<ChangesBlock<Unit>> merge(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull Rectangle clip) {
        if (editor == null) {
            VisibleRangeMerger.$$$reportNull$$$0(2);
        }
        if (ranges == null) {
            VisibleRangeMerger.$$$reportNull$$$0(3);
        }
        if (clip == null) {
            VisibleRangeMerger.$$$reportNull$$$0(4);
        }
        return new VisibleRangeMerger<Unit>(editor, FlagsProvider.EMPTY).run(ranges, clip);
    }

    public static <T> List<ChangesBlock<T>> merge(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull FlagsProvider<T> flagsProvider, @NotNull Rectangle clip) {
        if (editor == null) {
            VisibleRangeMerger.$$$reportNull$$$0(5);
        }
        if (ranges == null) {
            VisibleRangeMerger.$$$reportNull$$$0(6);
        }
        if (flagsProvider == null) {
            VisibleRangeMerger.$$$reportNull$$$0(7);
        }
        if (clip == null) {
            VisibleRangeMerger.$$$reportNull$$$0(8);
        }
        return new VisibleRangeMerger<T>(editor, flagsProvider).run(ranges, clip);
    }

    @NotNull
    private List<ChangesBlock<T>> run(@NotNull List<? extends Range> ranges, @NotNull Rectangle clip) {
        if (ranges == null) {
            VisibleRangeMerger.$$$reportNull$$$0(9);
        }
        if (clip == null) {
            VisibleRangeMerger.$$$reportNull$$$0(10);
        }
        int visibleLinesStart = EditorUtil.yToLogicalLineRange(this.myEditor, clip.y).intervalStart();
        int visibleLinesEnd = EditorUtil.yToLogicalLineRange(this.myEditor, clip.y + Math.max(clip.height - 1, 0)).intervalEnd() + 1;
        for (Range range2 : ranges) {
            int line1 = range2.getLine1();
            int line2 = range2.getLine2();
            if (line2 < visibleLinesStart) continue;
            if (line1 > visibleLinesEnd) break;
            T flags = this.myFlagsProvider.getFlags(range2);
            List<Range.InnerRange> innerRanges = range2.getInnerRanges();
            if (innerRanges == null || this.myFlagsProvider.shouldIgnoreInnerRanges(flags)) {
                this.processLine(range2, line1, line2, range2.getType(), flags);
                continue;
            }
            for (Range.InnerRange innerRange : innerRanges) {
                int innerLine1 = line1 + innerRange.getLine1();
                int innerLine2 = line1 + innerRange.getLine2();
                byte innerType = innerRange.getType();
                this.processLine(range2, innerLine1, innerLine2, innerType, flags);
            }
        }
        this.finishBlock();
        List<ChangesBlock<T>> list2 = this.myResult;
        if (list2 == null) {
            VisibleRangeMerger.$$$reportNull$$$0(11);
        }
        return list2;
    }

    private void processLine(@NotNull Range range2, int start2, int end, byte type, @NotNull T flags) {
        if (range2 == null) {
            VisibleRangeMerger.$$$reportNull$$$0(12);
        }
        if (flags == null) {
            VisibleRangeMerger.$$$reportNull$$$0(13);
        }
        Pair<@NotNull Interval, @Nullable Interval> pair1 = EditorUtil.logicalLineToYRange(this.myEditor, start2);
        int visualStart = ((Interval)pair1.first).intervalStart();
        int sharedPrefixHeight = pair1.second == null ? ((Interval)pair1.first).intervalEnd() - ((Interval)pair1.first).intervalStart() + 1 : ((Interval)pair1.second).intervalStart() - ((Interval)pair1.first).intervalStart();
        if (start2 == end) {
            if (sharedPrefixHeight != 0) {
                this.appendChange(range2, new ChangedLines<T>(visualStart, visualStart + sharedPrefixHeight, 1, flags));
            } else {
                this.appendChange(range2, new ChangedLines<T>(visualStart, visualStart, type, flags));
            }
        } else {
            Pair<@NotNull Interval, @Nullable Interval> pair2 = EditorUtil.logicalLineToYRange(this.myEditor, end - 1);
            int visualEnd = ((Interval)pair2.first).intervalEnd() + 1;
            int sharedSuffixHeight = pair2.second == null ? ((Interval)pair2.first).intervalEnd() - ((Interval)pair2.first).intervalStart() + 1 : ((Interval)pair2.first).intervalEnd() - ((Interval)pair2.second).intervalEnd();
            if (type == 0 || type == 1) {
                this.appendChange(range2, new ChangedLines<T>(visualStart, visualEnd, type, flags));
            } else {
                if (sharedPrefixHeight != 0 && visualEnd - visualStart > sharedPrefixHeight) {
                    this.appendChange(range2, new ChangedLines<T>(visualStart, visualStart + sharedPrefixHeight, 1, flags));
                    visualStart += sharedPrefixHeight;
                    sharedPrefixHeight = 0;
                }
                if (sharedSuffixHeight != 0 && visualEnd - visualStart > sharedSuffixHeight) {
                    this.appendChange(range2, new ChangedLines<T>(visualStart, visualEnd - sharedSuffixHeight, type, flags));
                    this.appendChange(range2, new ChangedLines<T>(visualEnd - sharedSuffixHeight, visualEnd, 1, flags));
                } else {
                    byte bodyType = sharedPrefixHeight != 0 || sharedSuffixHeight != 0 ? (byte)1 : type;
                    this.appendChange(range2, new ChangedLines<T>(visualStart, visualEnd, bodyType, flags));
                }
            }
        }
    }

    private void appendChange(@NotNull Range range2, @NotNull ChangedLines<T> newChange) {
        ChangedLines lastItem;
        if (range2 == null) {
            VisibleRangeMerger.$$$reportNull$$$0(14);
        }
        if (newChange == null) {
            VisibleRangeMerger.$$$reportNull$$$0(15);
        }
        if ((lastItem = (ChangedLines)ContainerUtil.getLastItem(this.myBlock.changes)) != null && lastItem.y2 < newChange.y1) {
            this.finishBlock();
        }
        List changes = this.myBlock.changes;
        List<Range> ranges = this.myBlock.ranges;
        if (ContainerUtil.getLastItem(ranges) != range2) {
            ranges.add(range2);
        }
        if (changes.isEmpty()) {
            changes.add(newChange);
            return;
        }
        ChangedLines lastChange = changes.remove(changes.size() - 1);
        if (lastChange.y1 == lastChange.y2 && newChange.y1 == newChange.y2) {
            assert (lastChange.y1 == newChange.y1);
            byte type = this.mergeTypes(lastChange, newChange);
            T flags = this.myFlagsProvider.mergeFlags(lastChange.flags, newChange.flags);
            changes.add(new ChangedLines<T>(lastChange.y1, lastChange.y2, type, flags));
        } else if (lastChange.y1 == lastChange.y2 && newChange.type == 0 || newChange.y1 == newChange.y2 && lastChange.type == 0) {
            changes.add(lastChange);
            changes.add(newChange);
        } else if (lastChange.type == newChange.type && Objects.equals(lastChange.flags, newChange.flags)) {
            int union1 = Math.min(lastChange.y1, newChange.y1);
            int union2 = Math.max(lastChange.y2, newChange.y2);
            changes.add(new ChangedLines(union1, union2, lastChange.type, lastChange.flags));
        } else {
            int intersection1 = Math.max(lastChange.y1, newChange.y1);
            int intersection2 = Math.min(lastChange.y2, newChange.y2);
            if (lastChange.y1 != intersection1) {
                changes.add(new ChangedLines(lastChange.y1, intersection1, lastChange.type, lastChange.flags));
            }
            if (intersection1 != intersection2) {
                byte type = this.mergeTypes(lastChange, newChange);
                T flags = this.myFlagsProvider.mergeFlags(lastChange.flags, newChange.flags);
                changes.add(new ChangedLines<T>(intersection1, intersection2, type, flags));
            }
            if (newChange.y2 != intersection2) {
                changes.add(new ChangedLines(intersection2, newChange.y2, newChange.type, newChange.flags));
            }
        }
    }

    private void finishBlock() {
        if (this.myBlock.changes.isEmpty()) {
            return;
        }
        this.myResult.add(this.myBlock);
        this.myBlock = new ChangesBlock();
    }

    private byte mergeTypes(@NotNull ChangedLines<T> change1, @NotNull ChangedLines<T> change2) {
        if (change1 == null) {
            VisibleRangeMerger.$$$reportNull$$$0(16);
        }
        if (change2 == null) {
            VisibleRangeMerger.$$$reportNull$$$0(17);
        }
        return change1.type == change2.type ? change1.type : (byte)1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flagsProvider";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clip";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/VisibleRangeMerger";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flags";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChange";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change1";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/VisibleRangeMerger";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processLine";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendChange";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "mergeTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface FlagsProvider<T> {
        public static final FlagsProvider<Unit> EMPTY = new FlagsProvider<Unit>(){

            @Override
            @NotNull
            public Unit getFlags(@NotNull Range range2) {
                if (range2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                Unit unit = Unit.INSTANCE;
                if (unit == null) {
                    1.$$$reportNull$$$0(1);
                }
                return unit;
            }

            @Override
            @NotNull
            public Unit mergeFlags(@NotNull Unit flags1, @NotNull Unit flags2) {
                if (flags1 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (flags2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                Unit unit = Unit.INSTANCE;
                if (unit == null) {
                    1.$$$reportNull$$$0(4);
                }
                return unit;
            }

            @Override
            public boolean shouldIgnoreInnerRanges(@NotNull Unit flag) {
                if (flag == null) {
                    1.$$$reportNull$$$0(5);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "range";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/ex/VisibleRangeMerger$FlagsProvider$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flags1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flags2";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flag";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/ex/VisibleRangeMerger$FlagsProvider$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFlags";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "mergeFlags";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getFlags";
                        break;
                    }
                    case 1: 
                    case 4: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "mergeFlags";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "shouldIgnoreInnerRanges";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        @NotNull
        public T getFlags(@NotNull Range var1);

        @NotNull
        public T mergeFlags(@NotNull T var1, @NotNull T var2);

        default public boolean shouldIgnoreInnerRanges(@NotNull T flag) {
            if (flag == null) {
                FlagsProvider.$$$reportNull$$$0(0);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flag", "com/intellij/openapi/vcs/ex/VisibleRangeMerger$FlagsProvider", "shouldIgnoreInnerRanges"));
        }
    }
}

