/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusFactory;
import com.intellij.util.containers.MultiMap;
import java.awt.Color;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileStatusFactoryImpl
extends FileStatusFactory {
    private final MultiMap<@Nullable PluginId, FileStatus> myStatuses = new MultiMap();

    public synchronized FileStatus createFileStatus(@NonNls @NotNull String id2, @NotNull @NotNull Supplier<@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String> description, @Nullable Color color, @Nullable PluginId pluginId) {
        if (id2 == null) {
            FileStatusFactoryImpl.$$$reportNull$$$0(0);
        }
        if (description == null) {
            FileStatusFactoryImpl.$$$reportNull$$$0(1);
        }
        FileStatusImpl result2 = new FileStatusImpl(id2, ColorKey.createColorKey((String)("FILESTATUS_" + id2), (Color)color), description);
        this.myStatuses.putValue((Object)pluginId, (Object)result2);
        return result2;
    }

    public synchronized FileStatus[] getAllFileStatuses() {
        return this.myStatuses.values().toArray(new FileStatus[0]);
    }

    private synchronized void onPluginUnload(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            FileStatusFactoryImpl.$$$reportNull$$$0(2);
        }
        this.myStatuses.remove((Object)pluginId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/FileStatusFactoryImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileStatus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onPluginUnload";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PluginListener
    implements DynamicPluginListener {
        private PluginListener() {
        }

        @Override
        public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
            if (pluginDescriptor == null) {
                PluginListener.$$$reportNull$$$0(0);
            }
            PluginId pluginId = pluginDescriptor.getPluginId();
            FileStatusFactory factory2 = FileStatusFactory.getInstance();
            if (pluginId != null && factory2 instanceof FileStatusFactoryImpl) {
                ((FileStatusFactoryImpl)factory2).onPluginUnload(pluginId);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/vcs/FileStatusFactoryImpl$PluginListener", "beforePluginUnload"));
        }
    }

    private static final class FileStatusImpl
    implements FileStatus {
        private final String myStatus;
        private final ColorKey myColorKey;
        private final Supplier<@Nls(capitalization=Nls.Capitalization.Sentence) String> myTextSupplier;

        FileStatusImpl(@NotNull String status, @NotNull ColorKey key, @NotNull Supplier<@Nls(capitalization=Nls.Capitalization.Sentence) String> textSupplier) {
            if (status == null) {
                FileStatusImpl.$$$reportNull$$$0(0);
            }
            if (key == null) {
                FileStatusImpl.$$$reportNull$$$0(1);
            }
            if (textSupplier == null) {
                FileStatusImpl.$$$reportNull$$$0(2);
            }
            this.myStatus = status;
            this.myColorKey = key;
            this.myTextSupplier = textSupplier;
        }

        @NonNls
        public String toString() {
            return this.myStatus;
        }

        public String getText() {
            return this.myTextSupplier.get();
        }

        public Color getColor() {
            return EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getColor(this.getColorKey());
        }

        @NotNull
        public ColorKey getColorKey() {
            ColorKey colorKey = this.myColorKey;
            if (colorKey == null) {
                FileStatusImpl.$$$reportNull$$$0(3);
            }
            return colorKey;
        }

        @NotNull
        public String getId() {
            String string = this.myStatus;
            if (string == null) {
                FileStatusImpl.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textSupplier";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/FileStatusFactoryImpl$FileStatusImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/FileStatusFactoryImpl$FileStatusImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColorKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

