/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.MenuItem;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.MenuSelectionManager;
import org.jetbrains.annotations.NotNull;

@Service
public final class MainMenuCollector {
    public static MainMenuCollector getInstance() {
        return (MainMenuCollector)ApplicationManager.getApplication().getService(MainMenuCollector.class);
    }

    public void record(@NotNull AnAction action2) {
        if (action2 == null) {
            MainMenuCollector.$$$reportNull$$$0(0);
        }
        try {
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo(action2.getClass());
            if (!info.isDevelopedByJetBrains()) {
                return;
            }
            AWTEvent e = EventQueue.getCurrentEvent();
            String path = null;
            if (e instanceof ItemEvent) {
                path = this.getPathFromMenuItem(e, action2);
            } else if (e instanceof MouseEvent) {
                path = this.getPathFromMenuSelectionManager(action2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getPathFromMenuSelectionManager(@NotNull AnAction action2) {
        List<String> groups2;
        if (action2 == null) {
            MainMenuCollector.$$$reportNull$$$0(1);
        }
        if ((groups2 = Arrays.stream(MenuSelectionManager.defaultManager().getSelectedPath()).filter(o -> o instanceof ActionMenu).map(o -> ((ActionMenu)((Object)((Object)o))).getAnAction().getTemplateText()).collect(Collectors.toList())).size() > 0) {
            String text2 = MainMenuCollector.getActionText(action2);
            groups2.add(text2);
            return MainMenuCollector.convertMenuItemsToKey(groups2);
        }
        return null;
    }

    private static String getActionText(@NotNull AnAction action2) {
        String actionId;
        if (action2 == null) {
            MainMenuCollector.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(actionId = ActionManager.getInstance().getId(action2)))) {
            return "generated.on.runtime";
        }
        return action2.getTemplateText();
    }

    @NotNull
    private static String convertMenuItemsToKey(List<String> menuItems) {
        String string = StringUtil.join(menuItems, (String)" -> ");
        if (string == null) {
            MainMenuCollector.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected String getPathFromMenuItem(AWTEvent e, AnAction action2) {
        Object src = e.getSource();
        ArrayList<String> items = new ArrayList<String>();
        while (src instanceof MenuItem) {
            items.add(0, ((MenuItem)src).getLabel());
            src = ((MenuItem)src).getParent();
        }
        if (items.size() > 1) {
            items.set(items.size() - 1, MainMenuCollector.getActionText(action2));
        }
        return MainMenuCollector.convertMenuItemsToKey(items);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/MainMenuCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/MainMenuCollector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMenuItemsToKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromMenuSelectionManager";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActionText";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class State {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="path", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();
    }
}

