/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.ClassPathXmlPathResolver;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.messages.ListenerDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class XmlReader {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginManager");
    static final String APPLICATION_SERVICE = "com.intellij.applicationService";
    static final String PROJECT_SERVICE = "com.intellij.projectService";
    static final String MODULE_SERVICE = "com.intellij.moduleService";
    @NonNls
    private static final String ATTRIBUTE_AREA = "area";

    XmlReader() {
    }

    static boolean isSuitableForOs(@NotNull String os) {
        if (os == null) {
            XmlReader.$$$reportNull$$$0(0);
        }
        if (os.isEmpty()) {
            return true;
        }
        if (os.equals(IdeaPluginDescriptorImpl.OS.mac.name())) {
            return SystemInfoRt.isMac;
        }
        if (os.equals(IdeaPluginDescriptorImpl.OS.linux.name())) {
            return SystemInfoRt.isLinux;
        }
        if (os.equals(IdeaPluginDescriptorImpl.OS.windows.name())) {
            return SystemInfoRt.isWindows;
        }
        if (os.equals(IdeaPluginDescriptorImpl.OS.unix.name())) {
            return SystemInfoRt.isUnix;
        }
        if (os.equals(IdeaPluginDescriptorImpl.OS.freebsd.name())) {
            return SystemInfoRt.isFreeBSD;
        }
        throw new IllegalArgumentException("Unknown OS '" + os + "'");
    }

    @NotNull
    private static ServiceDescriptor readServiceDescriptor(@NotNull Element element2) {
        if (element2 == null) {
            XmlReader.$$$reportNull$$$0(1);
        }
        ServiceDescriptor descriptor2 = new ServiceDescriptor();
        descriptor2.serviceInterface = element2.getAttributeValue("serviceInterface");
        descriptor2.serviceImplementation = Strings.nullize((String)element2.getAttributeValue("serviceImplementation"));
        descriptor2.testServiceImplementation = Strings.nullize((String)element2.getAttributeValue("testServiceImplementation"));
        descriptor2.headlessImplementation = Strings.nullize((String)element2.getAttributeValue("headlessImplementation"));
        descriptor2.configurationSchemaKey = element2.getAttributeValue("configurationSchemaKey");
        String preload2 = element2.getAttributeValue("preload");
        if (preload2 != null) {
            switch (preload2) {
                case "true": {
                    descriptor2.preload = ServiceDescriptor.PreloadMode.TRUE;
                    break;
                }
                case "await": {
                    descriptor2.preload = ServiceDescriptor.PreloadMode.AWAIT;
                    break;
                }
                case "notHeadless": {
                    descriptor2.preload = ServiceDescriptor.PreloadMode.NOT_HEADLESS;
                    break;
                }
                case "notLightEdit": {
                    descriptor2.preload = ServiceDescriptor.PreloadMode.NOT_LIGHT_EDIT;
                    break;
                }
                default: {
                    LOG.error("Unknown preload mode value: " + JDOMUtil.writeElement((Element)element2));
                }
            }
        }
        descriptor2.overrides = Boolean.parseBoolean(element2.getAttributeValue("overrides"));
        ServiceDescriptor serviceDescriptor = descriptor2;
        if (serviceDescriptor == null) {
            XmlReader.$$$reportNull$$$0(2);
        }
        return serviceDescriptor;
    }

    static void readListeners(@NotNull Element list2, @NotNull ContainerDescriptor containerDescriptor, @NotNull IdeaPluginDescriptorImpl mainDescriptor) {
        if (list2 == null) {
            XmlReader.$$$reportNull$$$0(3);
        }
        if (containerDescriptor == null) {
            XmlReader.$$$reportNull$$$0(4);
        }
        if (mainDescriptor == null) {
            XmlReader.$$$reportNull$$$0(5);
        }
        List content2 = list2.getContent();
        List<ListenerDescriptor> result2 = containerDescriptor.listeners;
        if (result2 == null) {
            containerDescriptor.listeners = result2 = new ArrayList<ListenerDescriptor>(content2.size());
        } else {
            ((ArrayList)result2).ensureCapacity(result2.size() + content2.size());
        }
        for (Content item : content2) {
            Element child2;
            String os;
            if (!(item instanceof Element) || (os = (child2 = (Element)item).getAttributeValue("os")) != null && !XmlReader.isSuitableForOs(os)) continue;
            String listenerClassName = child2.getAttributeValue("class");
            String topicClassName = child2.getAttributeValue("topic");
            if (listenerClassName == null || topicClassName == null) {
                LOG.error("Listener descriptor is not correct: " + JDOMUtil.writeElement((Element)child2));
                continue;
            }
            result2.add(new ListenerDescriptor(listenerClassName, topicClassName, XmlReader.getBoolean("activeInTestMode", child2), XmlReader.getBoolean("activeInHeadlessMode", child2), (PluginDescriptor)mainDescriptor));
        }
    }

    static void readIdAndName(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Element element2) {
        if (descriptor2 == null) {
            XmlReader.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            XmlReader.$$$reportNull$$$0(7);
        }
        String idString = descriptor2.id == null ? element2.getChildTextTrim("id") : descriptor2.id.getIdString();
        String name = element2.getChildTextTrim("name");
        if (idString == null) {
            idString = name;
        } else if (name == null) {
            name = idString;
        }
        descriptor2.name = name;
        if (idString != null && !idString.isEmpty() && descriptor2.id == null) {
            descriptor2.id = PluginId.getId((String)idString);
        }
    }

    static void readMetaInfo(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Element element2) {
        if (descriptor2 == null) {
            XmlReader.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            XmlReader.$$$reportNull$$$0(9);
        }
        if (!element2.hasAttributes()) {
            return;
        }
        List attributes = element2.getAttributes();
        for (Attribute attribute : attributes) {
            switch (attribute.getName()) {
                case "url": {
                    descriptor2.url = Strings.nullize((String)attribute.getValue());
                    break;
                }
                case "use-idea-classloader": {
                    descriptor2.myUseIdeaClassLoader = Boolean.parseBoolean(attribute.getValue());
                    break;
                }
                case "allow-bundled-update": {
                    descriptor2.myAllowBundledUpdate = Boolean.parseBoolean(attribute.getValue());
                    break;
                }
                case "implementation-detail": {
                    descriptor2.myImplementationDetail = Boolean.parseBoolean(attribute.getValue());
                    break;
                }
                case "require-restart": {
                    descriptor2.myRequireRestart = Boolean.parseBoolean(attribute.getValue());
                    break;
                }
                case "version": {
                    String internalVersionString = Strings.nullize((String)attribute.getValue());
                    if (internalVersionString == null) break;
                    try {
                        Integer.parseInt(internalVersionString);
                        break;
                    }
                    catch (NumberFormatException e) {
                        LOG.error((Throwable)new PluginException("Invalid value in plugin.xml format version: '" + internalVersionString + "'", (Throwable)e, descriptor2.id));
                    }
                }
            }
        }
    }

    static <T> void readDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull DescriptorListLoadingContext context, @NotNull PathBasedJdomXIncluder.PathResolver<T> pathResolver, @NotNull List<PluginDependency> dependencies) {
        if (rootDescriptor == null) {
            XmlReader.$$$reportNull$$$0(10);
        }
        if (descriptor2 == null) {
            XmlReader.$$$reportNull$$$0(11);
        }
        if (context == null) {
            XmlReader.$$$reportNull$$$0(12);
        }
        if (pathResolver == null) {
            XmlReader.$$$reportNull$$$0(13);
        }
        if (dependencies == null) {
            XmlReader.$$$reportNull$$$0(14);
        }
        List<String> visitedFiles = null;
        for (PluginDependency dependency : dependencies) {
            Element element2;
            String configFile;
            if (dependency.isDisabledOrBroken || (configFile = dependency.configFile) == null || pathResolver instanceof ClassPathXmlPathResolver && context.checkOptionalConfigShortName(configFile, descriptor2, rootDescriptor)) continue;
            try {
                element2 = pathResolver.resolvePath(descriptor2.basePath, configFile, context.getXmlFactory());
            }
            catch (IOException | JDOMException e) {
                String message = "Plugin " + rootDescriptor + " misses optional descriptor " + configFile;
                if (context.ignoreMissingSubDescriptor) {
                    LOG.info(message);
                    LOG.debug(e);
                    continue;
                }
                throw new RuntimeException(message, e);
            }
            if (visitedFiles == null) {
                visitedFiles = context.getVisitedFiles();
            }
            XmlReader.checkCycle(rootDescriptor, configFile, visitedFiles);
            IdeaPluginDescriptorImpl subDescriptor = new IdeaPluginDescriptorImpl(descriptor2.path, descriptor2.basePath, descriptor2.isBundled());
            subDescriptor.id = rootDescriptor.id;
            subDescriptor.name = rootDescriptor.name;
            visitedFiles.add(configFile);
            if (subDescriptor.readExternal(element2, pathResolver, context, rootDescriptor)) {
                dependency.subDescriptor = subDescriptor;
            }
            visitedFiles.clear();
        }
    }

    private static void checkCycle(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull String configFile, @NotNull List<String> visitedFiles) {
        if (rootDescriptor == null) {
            XmlReader.$$$reportNull$$$0(15);
        }
        if (configFile == null) {
            XmlReader.$$$reportNull$$$0(16);
        }
        if (visitedFiles == null) {
            XmlReader.$$$reportNull$$$0(17);
        }
        int n = visitedFiles.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!configFile.equals(visitedFiles.get(i2))) continue;
            List<String> cycle = visitedFiles.subList(i2, visitedFiles.size());
            throw new RuntimeException("Plugin " + rootDescriptor + " optional descriptors form a cycle: " + String.join((CharSequence)", ", cycle));
        }
    }

    private static boolean getBoolean(@NotNull String name, @NotNull Element child2) {
        String value2;
        if (name == null) {
            XmlReader.$$$reportNull$$$0(18);
        }
        if (child2 == null) {
            XmlReader.$$$reportNull$$$0(19);
        }
        return (value2 = child2.getAttributeValue(name)) == null || Boolean.parseBoolean(value2);
    }

    @Nullable
    static Map<String, List<Element>> readExtensions(@NotNull IdeaPluginDescriptorImpl descriptor2, @Nullable Map<String, List<Element>> epNameToExtensions, @NotNull DescriptorListLoadingContext loadingContext, @NotNull Element child2) {
        if (descriptor2 == null) {
            XmlReader.$$$reportNull$$$0(20);
        }
        if (loadingContext == null) {
            XmlReader.$$$reportNull$$$0(21);
        }
        if (child2 == null) {
            XmlReader.$$$reportNull$$$0(22);
        }
        String ns = child2.getAttributeValue("defaultExtensionNs");
        block10: for (Element extensionElement : child2.getChildren()) {
            ContainerDescriptor containerDescriptor;
            String qualifiedExtensionPointName;
            String os = extensionElement.getAttributeValue("os");
            if (os != null) {
                extensionElement.removeAttribute("os");
                if (!XmlReader.isSuitableForOs(os)) continue;
            }
            switch (qualifiedExtensionPointName = loadingContext.internString(ExtensionsAreaImpl.extractPointName((Element)extensionElement, (String)ns))) {
                case "com.intellij.applicationService": {
                    containerDescriptor = descriptor2.appContainerDescriptor;
                    break;
                }
                case "com.intellij.projectService": {
                    containerDescriptor = descriptor2.projectContainerDescriptor;
                    break;
                }
                case "com.intellij.moduleService": {
                    containerDescriptor = descriptor2.moduleContainerDescriptor;
                    break;
                }
                default: {
                    if (epNameToExtensions == null) {
                        epNameToExtensions = new LinkedHashMap<String, List<Element>>();
                    }
                    epNameToExtensions.computeIfAbsent(qualifiedExtensionPointName, __ -> new ArrayList()).add(extensionElement);
                    continue block10;
                }
            }
            containerDescriptor.addService(XmlReader.readServiceDescriptor(extensionElement));
        }
        return epNameToExtensions;
    }

    static void readExtensionPoints(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Element parentElement) {
        if (descriptor2 == null) {
            XmlReader.$$$reportNull$$$0(23);
        }
        if (parentElement == null) {
            XmlReader.$$$reportNull$$$0(24);
        }
        for (Content child2 : parentElement.getContent()) {
            ContainerDescriptor containerDescriptor;
            if (!(child2 instanceof Element)) continue;
            Element element2 = (Element)child2;
            String area = element2.getAttributeValue(ATTRIBUTE_AREA);
            if (area == null) {
                containerDescriptor = descriptor2.appContainerDescriptor;
            } else if ("IDEA_PROJECT".equals(area)) {
                containerDescriptor = descriptor2.projectContainerDescriptor;
            } else if ("IDEA_MODULE".equals(area)) {
                containerDescriptor = descriptor2.moduleContainerDescriptor;
            } else {
                LOG.error("Unknown area: " + area);
                continue;
            }
            String pointName = XmlReader.getExtensionPointName(element2, descriptor2.getPluginId());
            String beanClassName = element2.getAttributeValue("beanClass");
            String interfaceClassName = element2.getAttributeValue("interface");
            if (beanClassName == null && interfaceClassName == null) {
                throw new RuntimeException("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + descriptor2.getPluginId() + "' plugin");
            }
            if (beanClassName != null && interfaceClassName != null) {
                throw new RuntimeException("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + descriptor2.getPluginId() + "' plugin");
            }
            boolean dynamic = Boolean.parseBoolean(element2.getAttributeValue("dynamic"));
            Object point = interfaceClassName == null ? new BeanExtensionPoint(pointName, beanClassName, (PluginDescriptor)descriptor2, dynamic) : new InterfaceExtensionPoint(pointName, interfaceClassName, (PluginDescriptor)descriptor2, null, dynamic);
            List<ExtensionPointImpl<?>> result2 = containerDescriptor.extensionPoints;
            if (result2 == null) {
                result2 = new ArrayList();
                containerDescriptor.extensionPoints = result2;
            }
            result2.add((ExtensionPointImpl<?>)point);
        }
    }

    @NotNull
    private static String getExtensionPointName(@NotNull Element extensionPointElement, @NotNull PluginId effectivePluginId) {
        String pointName;
        if (extensionPointElement == null) {
            XmlReader.$$$reportNull$$$0(25);
        }
        if (effectivePluginId == null) {
            XmlReader.$$$reportNull$$$0(26);
        }
        if ((pointName = extensionPointElement.getAttributeValue("qualifiedName")) == null) {
            String name = extensionPointElement.getAttributeValue("name");
            if (name == null) {
                throw new RuntimeException("'name' attribute not specified for extension point in '" + effectivePluginId + "' plugin");
            }
            pointName = effectivePluginId.getIdString() + '.' + name;
        }
        String string = pointName;
        if (string == null) {
            XmlReader.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/XmlReader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainDescriptor";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedFiles";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingContext";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectivePluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/XmlReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readServiceDescriptor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPointName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableForOs";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readServiceDescriptor";
                break;
            }
            case 2: 
            case 27: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readListeners";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readIdAndName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readMetaInfo";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readDependencies";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkCycle";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "readExtensions";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readExtensionPoints";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

