/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.usages.impl;

import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.find.usages.api.UsageOptions;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.DefaultUsageSearchParameters;
import com.intellij.find.usages.impl.TextSearchKt;
import com.intellij.find.usages.symbol.SearchableSymbol;
import com.intellij.find.usages.symbol.SymbolSearchTargetFactory;
import com.intellij.model.Symbol;
import com.intellij.model.psi.impl.TargetsKt;
import com.intellij.model.search.SearchParameters;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.usages.Usage;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001aB\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000eH\u0007\u001a\u001a\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u001a$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0000\u001a\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007\"\u0018\u0010\u0000\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"SEARCH_TARGET_EXTENSION", "Lcom/intellij/openapi/util/ClassExtension;", "Lcom/intellij/find/usages/symbol/SymbolSearchTargetFactory;", "buildQuery", "Lcom/intellij/util/Query;", "Lcom/intellij/usages/Usage;", "O", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/find/usages/api/SearchTarget;", "handler", "Lcom/intellij/find/usages/api/UsageHandler;", "allOptions", "Lcom/intellij/find/usages/impl/AllSearchOptions;", "symbolSearchTarget", "symbol", "Lcom/intellij/model/Symbol;", "symbolSearchTargets", "", "targetSymbols", "", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "intellij.platform.lang.impl"})
public final class ImplKt {
    private static final ClassExtension<SymbolSearchTargetFactory<?>> SEARCH_TARGET_EXTENSION = new ClassExtension("com.intellij.lang.symbolSearchTarget");

    @ApiStatus.Internal
    @NotNull
    public static final List<SearchTarget> symbolSearchTargets(@NotNull PsiFile file2, int offset) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Collection<Symbol> targetSymbols = TargetsKt.targetSymbols(file2, offset);
        if (targetSymbols.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        return ImplKt.symbolSearchTargets(project, targetSymbols);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SearchTarget> symbolSearchTargets(@NotNull Project project, @NotNull Collection<? extends Symbol> targetSymbols) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetSymbols, (String)"targetSymbols");
        Iterable iterable = targetSymbols;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            SearchTarget searchTarget;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Symbol it = (Symbol)element$iv;
            boolean bl2 = false;
            if (ImplKt.symbolSearchTarget(project, it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            SearchTarget it$iv = searchTarget;
            boolean bl5 = false;
            destination$iv.add(it$iv);
        }
        return CollectionsKt.toList((Iterable)((Iterable)var3_3));
    }

    @ApiStatus.Internal
    @Nullable
    public static final SearchTarget symbolSearchTarget(@NotNull Project project, @NotNull Symbol symbol) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        for (SymbolSearchTargetFactory factory2 : SEARCH_TARGET_EXTENSION.forKey(symbol.getClass())) {
            SymbolSearchTargetFactory factory_;
            if (factory2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.find.usages.symbol.SymbolSearchTargetFactory<com.intellij.model.Symbol>");
            }
            SearchTarget target2 = factory_.createTarget(project, symbol);
            if (target2 == null) continue;
            return target2;
        }
        if (symbol instanceof SearchableSymbol) {
            return ((SearchableSymbol)symbol).getSearchTarget();
        }
        if (symbol instanceof SearchTarget) {
            return (SearchTarget)symbol;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final <O> Query<? extends Usage> buildQuery(@NotNull Project project, @NotNull SearchTarget target2, @NotNull UsageHandler<O> handler2, @NotNull AllSearchOptions<O> allOptions) {
        void textSearch;
        boolean bl;
        Query query2;
        void options2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        Intrinsics.checkNotNullParameter(allOptions, (String)"allOptions");
        ArrayList queries = new ArrayList();
        Object object = allOptions;
        UsageOptions usageOptions = ((AllSearchOptions)object).component1();
        Boolean bl2 = ((AllSearchOptions)object).component2();
        O customOptions = ((AllSearchOptions)object).component3();
        if (options2.isUsages()) {
            object = queries;
            SearchService searchService = SearchService.getInstance();
            SearchScope searchScope2 = options2.getSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"options.searchScope");
            query2 = searchService.searchParameters((SearchParameters)new DefaultUsageSearchParameters(project, target2, searchScope2));
            bl = false;
            object.add(query2);
        }
        object = queries;
        query2 = handler2.buildSearchQuery((UsageOptions)options2, customOptions);
        bl = false;
        object.add(query2);
        if (Intrinsics.areEqual((Object)textSearch, (Object)true)) {
            Iterable $this$mapTo$iv = target2.getTextSearchStrings();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                String string = (String)item$iv;
                Collection collection = queries;
                boolean bl3 = false;
                SearchScope searchScope3 = options2.getSearchScope();
                Intrinsics.checkNotNullExpressionValue((Object)searchScope3, (String)"options.searchScope");
                Query<? extends Usage> query3 = TextSearchKt.buildTextQuery(project, (String)it, searchScope3);
                collection.add(query3);
            }
        }
        Query query4 = SearchService.getInstance().merge((List)queries);
        Intrinsics.checkNotNullExpressionValue((Object)query4, (String)"SearchService.getInstance().merge(queries)");
        return query4;
    }
}

