/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nullable;

public class TestFailedState
extends AbstractState
implements Disposable {
    private final String myErrorMsgPresentation;
    private final String myStacktracePresentation;

    public TestFailedState(@Nullable String localizedMessage, @Nullable String stackTrace) {
        this.myErrorMsgPresentation = StringUtil.isEmptyOrSpaces((String)localizedMessage) ? "" : localizedMessage;
        this.myStacktracePresentation = StringUtil.isEmptyOrSpaces((String)stackTrace) ? "" : stackTrace;
    }

    @Nullable
    public static String buildErrorPresentationText(@Nullable String localizedMessage, @Nullable String stackTrace) {
        String text2 = (String)(StringUtil.isEmptyOrSpaces((String)localizedMessage) ? "" : localizedMessage + "\n") + (String)(StringUtil.isEmptyOrSpaces((String)stackTrace) ? "" : stackTrace + "\n");
        return StringUtil.isEmptyOrSpaces((String)text2) ? null : text2;
    }

    public void dispose() {
    }

    @Override
    public void printOn(Printer printer) {
        printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        String compoundMessage = TestFailedState.buildErrorPresentationText(this.myErrorMsgPresentation, this.myStacktracePresentation);
        if (compoundMessage != null) {
            printer.mark();
            printer.printWithAnsiColoring(compoundMessage, ProcessOutputTypes.STDERR);
        }
    }

    public boolean isDefect() {
        return true;
    }

    public boolean wasLaunched() {
        return true;
    }

    public boolean isFinal() {
        return true;
    }

    public boolean isInProgress() {
        return false;
    }

    public boolean wasTerminated() {
        return false;
    }

    public TestStateInfo.Magnitude getMagnitude() {
        return TestStateInfo.Magnitude.FAILED_INDEX;
    }

    protected String getErrorMsgPresentation() {
        return this.myErrorMsgPresentation;
    }

    protected String getStacktracePresentation() {
        return this.myStacktracePresentation;
    }

    public String toString() {
        return "TEST FAILED";
    }
}

