/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnifiedDiffChangeUi {
    @NotNull
    protected final UnifiedDiffViewer myViewer;
    @NotNull
    protected final EditorEx myEditor;
    @NotNull
    protected final UnifiedDiffChange myChange;
    @NotNull
    protected final List<RangeHighlighter> myHighlighters;
    @NotNull
    protected final List<DiffGutterOperation> myOperations;

    public UnifiedDiffChangeUi(@NotNull UnifiedDiffViewer viewer, @NotNull UnifiedDiffChange change) {
        if (viewer == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(0);
        }
        if (change == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(1);
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myOperations = new ArrayList<DiffGutterOperation>();
        this.myViewer = viewer;
        this.myEditor = viewer.getEditor();
        this.myChange = change;
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    public void installHighlighter() {
        assert (this.myHighlighters.isEmpty() && this.myOperations.isEmpty());
        this.doInstallHighlighters();
        this.doInstallActionHighlighters();
    }

    protected void doInstallActionHighlighters() {
        if (this.myChange.isSkipped()) {
            return;
        }
        boolean leftEditable = this.myViewer.isEditable(Side.LEFT, false);
        boolean rightEditable = this.myViewer.isEditable(Side.RIGHT, false);
        if (leftEditable && rightEditable) {
            this.myOperations.add(this.createAcceptOperation(Side.LEFT));
            this.myOperations.add(this.createAcceptOperation(Side.RIGHT));
        } else if (rightEditable) {
            this.myOperations.add(this.createAcceptOperation(Side.LEFT));
        }
    }

    private void doInstallHighlighters() {
        this.myHighlighters.addAll(DiffDrawUtil.createUnifiedChunkHighlighters(this.myEditor, this.myChange.getDeletedRange(), this.myChange.getInsertedRange(), this.myChange.isExcluded(), this.myChange.isSkipped(), this.myChange.getLineFragment().getInnerFragments()));
    }

    public void updateGutterActions() {
        for (DiffGutterOperation operation : this.myOperations) {
            operation.update(true);
        }
    }

    @NotNull
    protected DiffGutterOperation createOperation(@NotNull DiffGutterOperation.RendererBuilder builder2) {
        if (builder2 == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(2);
        }
        int offset = this.myEditor.getDocument().getLineStartOffset(this.myChange.getLine1());
        return new DiffGutterOperation.Simple(this.myEditor, offset, builder2);
    }

    @NotNull
    @Nls
    static String getApplyActionText(@NotNull UnifiedDiffViewer viewer, @NotNull Side sourceSide) {
        String customValue;
        if (viewer == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(3);
        }
        if (sourceSide == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(4);
        }
        if ((customValue = (String)DiffUtil.getUserData((UserDataHolder)viewer.getRequest(), (UserDataHolder)viewer.getContext(), (Key)sourceSide.select(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_LEFT_ACTION_TEXT, DiffUserDataKeysEx.VCS_DIFF_ACCEPT_RIGHT_ACTION_TEXT))) != null) {
            String string = customValue;
            if (string == null) {
                UnifiedDiffChangeUi.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = sourceSide.isLeft() ? DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]) : DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]);
        if (string == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    static Icon getApplyIcon(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(7);
        }
        Icon icon2 = (Icon)sourceSide.select((Object)AllIcons.Diff.Revert, (Object)AllIcons.Actions.Checked);
        if (icon2 == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(8);
        }
        return icon2;
    }

    @NotNull
    private DiffGutterOperation createAcceptOperation(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(9);
        }
        DiffGutterOperation diffGutterOperation = this.createOperation(() -> {
            if (this.myViewer.isStateIsOutOfDate()) {
                return null;
            }
            if (!this.myViewer.isEditable(sourceSide.other(), true)) {
                return null;
            }
            String text2 = UnifiedDiffChangeUi.getApplyActionText(this.myViewer, sourceSide);
            Icon icon2 = UnifiedDiffChangeUi.getApplyIcon(sourceSide);
            return this.createIconRenderer(sourceSide, text2, icon2);
        });
        if (diffGutterOperation == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(10);
        }
        return diffGutterOperation;
    }

    private GutterIconRenderer createIconRenderer(final @NotNull Side sourceSide, @NotNull @NlsContexts.Tooltip String tooltipText, @NotNull Icon icon2) {
        if (sourceSide == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(11);
        }
        if (tooltipText == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(12);
        }
        if (icon2 == null) {
            UnifiedDiffChangeUi.$$$reportNull$$$0(13);
        }
        return new DiffGutterRenderer(icon2, tooltipText){

            @Override
            protected void handleMouseClick() {
                if (UnifiedDiffChangeUi.this.myViewer.isStateIsOutOfDate()) {
                    return;
                }
                if (!UnifiedDiffChangeUi.this.myViewer.isEditable(sourceSide.other(), true)) {
                    return;
                }
                Project project = UnifiedDiffChangeUi.this.myViewer.getProject();
                Document document = UnifiedDiffChangeUi.this.myViewer.getDocument(sourceSide.other());
                DiffUtil.executeWriteCommand(document, project, DiffBundle.message((String)"message.replace.change.command", (Object[])new Object[0]), () -> {
                    UnifiedDiffChangeUi.this.myViewer.replaceChange(UnifiedDiffChangeUi.this.myChange, sourceSide);
                    UnifiedDiffChangeUi.this.myViewer.scheduleRediff();
                });
                UnifiedDiffChangeUi.this.myViewer.rediff();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffChangeUi";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffChangeUi";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplyActionText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplyIcon";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAcceptOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createOperation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getApplyActionText";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getApplyIcon";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAcceptOperation";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createIconRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

