/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InlayTextMetrics;
import com.intellij.codeInsight.hints.presentation.InlayTextMetricsStorage;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.IconUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/intellij/codeInsight/hints/presentation/ScaledIconPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "metricsStorage", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "isSmall", "", "icon", "Ljavax/swing/Icon;", "component", "Ljava/awt/Component;", "(Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;ZLjavax/swing/Icon;Ljava/awt/Component;)V", "height", "", "getHeight", "()I", "value", "getIcon", "()Ljavax/swing/Icon;", "setIcon", "(Ljavax/swing/Icon;)V", "()Z", "getMetricsStorage", "()Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "width", "getWidth", "getMetrics", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "getScaleFactor", "", "paint", "", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "", "intellij.platform.lang.impl"})
public final class ScaledIconPresentation
extends BasePresentation {
    @NotNull
    private Icon icon;
    @NotNull
    private final InlayTextMetricsStorage metricsStorage;
    private final boolean isSmall;
    private final Component component;

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    public final void setIcon(@NotNull Icon value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.icon = value2;
        InlayHintsUtilsKt.fireContentChanged((InlayPresentation)this);
    }

    private final InlayTextMetrics getMetrics() {
        return this.metricsStorage.getFontMetrics(this.isSmall);
    }

    private final double getScaleFactor() {
        return (double)this.getMetrics().getFontHeight() / (double)this.icon.getIconHeight();
    }

    public int getWidth() {
        return (int)((double)this.icon.getIconWidth() * this.getScaleFactor());
    }

    public int getHeight() {
        return this.getMetrics().getFontHeight();
    }

    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D graphics2 = (Graphics2D)graphics;
        graphics2.setComposite(AlphaComposite.SrcAtop.derive(1.0f));
        Icon icon2 = IconUtil.scale((Icon)this.icon, (Component)this.component, (float)((float)this.getScaleFactor()));
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"IconUtil.scale(icon, com\u2026ScaleFactor()).toFloat())");
        Icon scaledIcon = icon2;
        scaledIcon.paintIcon(this.component, graphics2, 0, 0);
        graphics2.dispose();
    }

    @NotNull
    public String toString() {
        return "<image>";
    }

    @NotNull
    public final InlayTextMetricsStorage getMetricsStorage() {
        return this.metricsStorage;
    }

    public final boolean isSmall() {
        return this.isSmall;
    }

    public ScaledIconPresentation(@NotNull InlayTextMetricsStorage metricsStorage, boolean isSmall, @NotNull Icon icon2, @NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)metricsStorage, (String)"metricsStorage");
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.metricsStorage = metricsStorage;
        this.isSmall = isSmall;
        this.component = component2;
        this.icon = icon2;
    }
}

